/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei.category;

import java.util.Arrays;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.compat.jei.JEIIntegration;
import net.dries007.tfc.compat.jei.category.BaseRecipeCategory;
import net.dries007.tfc.config.TFCConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;

public class HeatingRecipeCategory
extends BaseRecipeCategory<HeatingRecipe> {
    public HeatingRecipeCategory(RecipeType<HeatingRecipe> type, IGuiHelper helper) {
        super(type, helper, 120, 38, new ItemStack((ItemLike)TFCBlocks.FIREPIT.get()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, HeatingRecipe recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder inputSlot = builder.addSlot(RecipeIngredientRole.INPUT, 21, 17);
        IRecipeSlotBuilder outputSlot = builder.addSlot(RecipeIngredientRole.OUTPUT, 85, 17);
        inputSlot.addIngredients(recipe.getIngredient());
        inputSlot.setBackground((IDrawable)this.slot, -1, -1);
        List<ItemStack> outputItems = Arrays.stream(recipe.getIngredient().getItems()).map(stack -> recipe.assembleStacked((ItemStack)stack, Integer.MAX_VALUE, true)).toList();
        FluidStack resultFluid = recipe.getDisplayOutputFluid();
        if (!outputItems.isEmpty() && !outputItems.stream().allMatch(ItemStack::isEmpty)) {
            outputSlot.addItemStacks(outputItems);
        }
        if (!resultFluid.isEmpty()) {
            outputSlot.addIngredient(JEIIntegration.FLUID_STACK, (Object)resultFluid);
            outputSlot.setFluidRenderer(1L, false, 16, 16);
        }
        outputSlot.setBackground((IDrawable)this.slot, -1, -1);
    }

    public void draw(HeatingRecipe recipe, IRecipeSlotsView recipeSlots, GuiGraphics graphics, double mouseX, double mouseY) {
        this.fire.draw(graphics, 54, 16);
        this.fireAnimated.draw(graphics, 54, 16);
        MutableComponent color = TFCConfig.CLIENT.heatTooltipStyle.get().formatColored(recipe.getTemperature());
        if (color != null) {
            Minecraft mc = Minecraft.getInstance();
            Font font = mc.font;
            graphics.drawString(font, (Component)color, 60 - font.width((FormattedText)color) / 2, 4, 0xFFFFFF, true);
        }
        for (IRecipeSlotView view : recipeSlots.getSlotViews()) {
            view.getDisplayedItemStack().ifPresent(stack -> HeatCapability.setTemperature(stack, recipe.getTemperature()));
        }
    }
}

