/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei.category;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.dries007.tfc.client.screen.KnappingScreen;
import net.dries007.tfc.common.recipes.KnappingRecipe;
import net.dries007.tfc.compat.jei.JEIIntegration;
import net.dries007.tfc.compat.jei.category.BaseRecipeCategory;
import net.dries007.tfc.util.data.KnappingType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.Nullable;

public class KnappingRecipeCategory<T extends KnappingRecipe>
extends BaseRecipeCategory<T> {
    private static final String INPUT_SLOT_NAME = "input";
    private final KnappingType knappingType;
    private final IGuiHelper helper;

    public KnappingRecipeCategory(RecipeType<T> type, IGuiHelper helper, KnappingType knappingType) {
        super(type, helper, 155, 82, knappingType.icon());
        this.knappingType = knappingType;
        this.helper = helper;
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlots, GuiGraphics stack, double mouseX, double mouseY) {
        this.arrow.draw(stack, 106, 33);
        this.arrowAnimated.draw(stack, 106, 33);
        IDrawable high = this.getTexture(recipeSlots, false);
        IDrawable low = this.getTexture(recipeSlots, true);
        int height = ((KnappingRecipe)recipe).getPattern().getHeight();
        int width = ((KnappingRecipe)recipe).getPattern().getWidth();
        boolean osr = ((KnappingRecipe)recipe).getPattern().defaultIsOn();
        int offsetX = Math.floorDiv(5 - width, 2);
        int offsetY = Math.floorDiv(5 - height, 2);
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 5; ++x) {
                int yd = y - offsetY;
                int xd = x - offsetX;
                if (0 <= yd && yd < height && 0 <= xd && xd < width) {
                    if (((KnappingRecipe)recipe).getPattern().get(xd, yd)) {
                        if (high == null) continue;
                        high.draw(stack, 21 + x * 16, 1 + y * 16);
                        continue;
                    }
                    if (low == null) continue;
                    low.draw(stack, 21 + x * 16, 1 + y * 16);
                    continue;
                }
                if (osr) {
                    if (high == null) continue;
                    high.draw(stack, 21 + x * 16, 1 + y * 16);
                    continue;
                }
                if (low == null) continue;
                low.draw(stack, 21 + x * 16, 1 + y * 16);
            }
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        SizedIngredient inputItem = ((KnappingRecipe)recipe).getIngredient() != null ? new SizedIngredient(((KnappingRecipe)recipe).getIngredient(), ((KnappingRecipe)recipe).knappingType().get().inputItem().count()) : ((KnappingRecipe)recipe).knappingType().get().inputItem();
        IRecipeSlotBuilder inputSlot = builder.addSlot(RecipeIngredientRole.INPUT, 0, 33);
        ((IRecipeSlotBuilder)inputSlot.addItemStacks(KnappingRecipeCategory.collapse(inputItem))).setSlotName(INPUT_SLOT_NAME);
        inputSlot.setBackground((IDrawable)this.slot, -1, -1);
        IRecipeSlotBuilder outputSlot = builder.addSlot(RecipeIngredientRole.OUTPUT, 137, 33);
        outputSlot.addItemStack(((KnappingRecipe)recipe).getResultItem((HolderLookup.Provider)KnappingRecipeCategory.registryAccess()));
        outputSlot.setBackground((IDrawable)this.slot, -1, -1);
    }

    @Nullable
    private IDrawable getTexture(IRecipeSlotsView slots, boolean disabled) {
        if (disabled && !this.knappingType.hasOffTexture()) {
            return null;
        }
        return slots.findSlotByName(INPUT_SLOT_NAME).flatMap(slot -> slot.getDisplayedIngredient(JEIIntegration.ITEM_STACK)).map(displayed -> {
            ResourceLocation high = KnappingScreen.getButtonLocation(displayed.getItem(), disabled);
            return this.helper.drawableBuilder(high, 0, 0, 16, 16).setTextureSize(16, 16).build();
        }).orElse(null);
    }
}

