/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei.category;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.dries007.tfc.client.screen.SewingTableScreen;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.common.recipes.SewingRecipe;
import net.dries007.tfc.compat.jei.category.BaseRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.logging.log4j.util.TriConsumer;

public class SewingRecipeCategory
extends BaseRecipeCategory<SewingRecipe> {
    private final IDrawable sewingBackground;
    private final IDrawable stitch;
    private final IDrawable wool;
    private final IDrawable burlap;

    public SewingRecipeCategory(RecipeType<SewingRecipe> type, IGuiHelper helper) {
        super(type, helper, 144, 70, new ItemStack((ItemLike)TFCItems.BONE_NEEDLE.get()));
        this.sewingBackground = helper.drawableBuilder(SewingTableScreen.TEXTURE, 8, 14, 112, 64).build();
        this.stitch = helper.drawableBuilder(SewingTableScreen.TEXTURE, 192, 0, 5, 5).build();
        this.wool = helper.drawableBuilder(SewingTableScreen.TEXTURE, 208, 0, 12, 12).build();
        this.burlap = helper.drawableBuilder(SewingTableScreen.TEXTURE, 208, 16, 12, 12).build();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SewingRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 120, 25).addItemStack(recipe.getResultItem((HolderLookup.Provider)SewingRecipeCategory.registryAccess()))).setBackground((IDrawable)this.slot, -1, -1);
    }

    public void draw(SewingRecipe recipe, IRecipeSlotsView slots, GuiGraphics graphics, double mouseX, double mouseY) {
        int xPadding = 3;
        int yPadding = 4;
        this.sewingBackground.draw(graphics, 3, 4);
        SewingTableScreen.forEachClothSquare((TriConsumer<Integer, Integer, Integer>)((TriConsumer)(x, y, i) -> {
            int material = recipe.getSquare((int)i);
            if (material != -1) {
                if (material == 0) {
                    this.burlap.draw(graphics, x * 12 + 8 + 3, y * 12 + 8 + 4);
                } else {
                    this.wool.draw(graphics, x * 12 + 8 + 3, y * 12 + 8 + 4);
                }
            }
        }));
        SewingTableScreen.forEachStitch((TriFunction<Integer, Integer, Integer, Boolean>)((TriFunction)(x, y, i) -> {
            if (recipe.getStitch((int)i)) {
                this.stitch.draw(graphics, x * 12 + 8 + 3 - 2, y * 12 + 8 + 4 - 2);
            }
            return false;
        }));
    }
}

