/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.patchouli.component;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.compat.patchouli.PatchouliIntegration;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.tooltip.Tooltips;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.slf4j.Logger;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.page.PageMultiblock;
import vazkii.patchouli.common.multiblock.SerializedMultiblock;

public abstract class CustomComponent
implements ICustomComponent {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new Gson();
    private static final Field MULTIBLOCK_OBJ = (Field)Helpers.uncheck(() -> {
        Field field = PageMultiblock.class.getDeclaredField("multiblockObj");
        field.setAccessible(true);
        return field;
    });
    protected transient int x;
    protected transient int y;
    protected transient HolderLookup.Provider provider;

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup, HolderLookup.Provider provider) {
        this.provider = provider;
    }

    public void build(int componentX, int componentY, int pageNum) {
        this.x = componentX;
        this.y = componentY;
    }

    public abstract void render(GuiGraphics var1, IComponentRenderContext var2, float var3, int var4, int var5);

    protected void renderSetup(GuiGraphics graphics) {
        graphics.pose().pushPose();
        graphics.pose().translate((float)this.x, (float)this.y, 0.0f);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)PatchouliIntegration.TEXTURE);
    }

    protected void renderItemStacks(IComponentRenderContext context, GuiGraphics graphics, int x, int y, int mouseX, int mouseY, List<ItemStack> stacks) {
        if (!stacks.isEmpty()) {
            context.renderItemStack(graphics, x, y, mouseX, mouseY, stacks.get(context.getTicksInBook() / 20 % stacks.size()));
        }
    }

    protected void renderFluidStacks(IComponentRenderContext context, GuiGraphics graphics, int x, int y, int mouseX, int mouseY, List<FluidStack> fluids) {
        if (!fluids.isEmpty()) {
            this.renderFluidStack(context, graphics, x, y, mouseX, mouseY, fluids.get(context.getTicksInBook() / 20 % fluids.size()));
        }
    }

    protected void renderFluidStack(IComponentRenderContext context, GuiGraphics graphics, int x, int y, int mouseX, int mouseY, FluidStack fluid) {
        if (!fluid.isEmpty()) {
            TextureAtlasSprite sprite = RenderHelpers.getAndBindFluidSprite(fluid);
            graphics.blit(x, y, 0, 16, 16, sprite);
            if (context.isAreaHovered(mouseX, mouseY, x, y, 16, 16)) {
                ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>(1);
                tooltip.add(Tooltips.fluidUnitsOf(fluid));
                context.setHoverTooltipComponents(tooltip);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected List<ItemStack> unpackItemStackIngredient(SizedIngredient ingredient) {
        return List.of(ingredient.getItems());
    }

    protected List<FluidStack> unpackFluidStackIngredient(SizedFluidIngredient ingredient) {
        return List.of(ingredient.getFluids());
    }

    protected <V, T> Optional<T> asJson(V value, Function<V, T> parse) {
        try {
            return Optional.of(parse.apply(value));
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Parsing {}: {}", value, (Object)e);
            return Optional.empty();
        }
    }

    protected Optional<Component> asTextComponent(JsonElement json) {
        MutableComponent text;
        try {
            text = Component.Serializer.fromJson((JsonElement)json, (HolderLookup.Provider)this.provider);
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Cannot load text component from json {}: {}", (Object)json, (Object)e);
            return Optional.empty();
        }
        if (text == null) {
            LOGGER.error("Cannot load text component from json {}", (Object)json);
            return Optional.empty();
        }
        return Optional.of(text);
    }

    protected <T extends Recipe<?>> Optional<T> asRecipe(String variable, RecipeType<T> type) {
        return this.asResourceLocation(variable).flatMap(e -> ClientHelpers.getLevelOrThrow().getRecipeManager().byKey(e).flatMap(recipe -> {
            if (recipe.value().getType() != type) {
                LOGGER.error("The recipe {} of type {} is not of type {}", new Object[]{e, BuiltInRegistries.RECIPE_TYPE.getKey((Object)recipe.value().getType()), type});
                return Optional.empty();
            }
            return Optional.of(recipe.value());
        }).or(() -> {
            LOGGER.error("No recipe of type {} named {} ", (Object)BuiltInRegistries.RECIPE_TYPE.getKey((Object)type), e);
            return Optional.empty();
        }));
    }

    protected Optional<ResourceLocation> asResourceLocation(String variable) {
        try {
            return Optional.of(Helpers.resourceLocation(variable));
        }
        catch (ResourceLocationException e) {
            LOGGER.error(e.getMessage());
            return Optional.empty();
        }
    }

    protected Optional<Supplier<IMultiblock>> asMultiblock(IVariable variable) {
        try {
            if (variable.unwrap().isJsonPrimitive()) {
                return this.asResourceLocation(GsonHelper.convertToString((JsonElement)variable.unwrap(), (String)"multiblock id")).flatMap(id -> {
                    IMultiblock multiblock = PatchouliAPI.get().getMultiblock(id);
                    if (multiblock != null) {
                        return Optional.of(() -> multiblock);
                    }
                    LOGGER.error("No multiblock by id: {}", id);
                    return Optional.empty();
                });
            }
            SerializedMultiblock serialized = (SerializedMultiblock)GSON.fromJson(variable.unwrap(), SerializedMultiblock.class);
            return Optional.of(() -> ((SerializedMultiblock)serialized).toMultiblock());
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Deserializing multiblock: ", (Throwable)e);
            return Optional.empty();
        }
    }

    protected Optional<MultiblockRenderer> asMultiblockRenderer(Supplier<IMultiblock> resolved) {
        try {
            IMultiblock multiblock = resolved.get();
            MultiblockRenderer stub = new MultiblockRenderer();
            MULTIBLOCK_OBJ.set((Object)stub, multiblock);
            return Optional.of(stub);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            LOGGER.error("Building multiblock: ", (Throwable)e);
            return Optional.empty();
        }
    }

    public static class MultiblockRenderer
    extends PageMultiblock {
        public void render(IComponentRenderContext context, GuiGraphics poseStack, int mouseX, int mouseY, float partialTicks) {
            if (context instanceof GuiBookEntry) {
                GuiBookEntry entryContext = (GuiBookEntry)context;
                this.mc = context.getGui().getMinecraft();
                this.parent = entryContext;
                this.book = entryContext.book;
                this.render(poseStack, mouseX, mouseY, partialTicks);
            }
        }

        public boolean shouldRenderText() {
            return false;
        }
    }
}

