/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.config;

public enum HealthDisplayStyle {
    TFC((curr, max) -> String.format("%.0f/%.0f", Float.valueOf(curr * 50.0f), Float.valueOf(max * 50.0f))),
    VANILLA((curr, max) -> String.format("%.1f/%.1f", Float.valueOf(curr), Float.valueOf(max))),
    TFC_CURRENT((curr, max) -> String.format("%.0f", Float.valueOf(curr * 50.0f))),
    VANILLA_CURRENT((curr, max) -> String.format("%.1f", Float.valueOf(curr)));

    private final Formatter formatter;

    private HealthDisplayStyle(Formatter formatter) {
        this.formatter = formatter;
    }

    public String format(float currentHealth, float maxHealth) {
        return this.formatter.apply(currentHealth, maxHealth);
    }

    @FunctionalInterface
    public static interface Formatter {
        public String apply(float var1, float var2);
    }
}

