/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.dries007.tfc.client.BarSystem;
import net.dries007.tfc.common.component.ItemStackHooks;
import net.dries007.tfc.common.component.forge.ForgingBonusComponent;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Inject(method={"<init>(Lnet/minecraft/world/level/ItemLike;ILnet/minecraft/core/component/PatchedDataComponentMap;)V"}, at={@At(value="TAIL")})
    private void modifyItemStackOnConstructing(CallbackInfo ci) {
        ItemStackHooks.onModifyItemStackComponents((ItemStack)this);
    }

    @Redirect(method={"copy"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/component/PatchedDataComponentMap;copy()Lnet/minecraft/core/component/PatchedDataComponentMap;"))
    private PatchedDataComponentMap modifyItemCopyToUpdateComponents(PatchedDataComponentMap map) {
        return ItemStackHooks.onCopyItemStackComponents((ItemStack)this, map);
    }

    @WrapOperation(method={"hurtAndBreak(ILnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;Ljava/util/function/Consumer;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/enchantment/EnchantmentHelper;processDurabilityChange(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/item/ItemStack;I)I")})
    private int applyForgingBonusToPreventItemDamage(ServerLevel level, ItemStack stack, int damage, Operation<Integer> original) {
        return ForgingBonusComponent.applyLikeUnbreaking(stack, level.random, (Integer)original.call(new Object[]{level, stack, damage}));
    }

    @Inject(method={"isBarVisible"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject$isBarVisible(CallbackInfoReturnable<Boolean> cir) {
        ItemStack stack = (ItemStack)this;
        BarSystem.Bar bar = BarSystem.getCustomBar(stack);
        if (bar != null) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getBarColor"}, at={@At(value="TAIL")}, cancellable=true)
    private void inject$getBarColor(CallbackInfoReturnable<Integer> cir) {
        ItemStack stack = (ItemStack)this;
        BarSystem.Bar bar = BarSystem.getCustomBar(stack);
        if (bar != null) {
            cir.setReturnValue((Object)bar.getBarColor(stack));
        }
    }

    @Inject(method={"getBarWidth"}, at={@At(value="TAIL")}, cancellable=true)
    private void inject$getBarWidth(CallbackInfoReturnable<Integer> cir) {
        ItemStack stack = (ItemStack)this;
        BarSystem.Bar bar = BarSystem.getCustomBar(stack);
        if (bar != null) {
            cir.setReturnValue((Object)bar.getBarWidth(stack));
        }
    }
}

