/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.mixin;

import net.dries007.tfc.common.component.food.FoodData;
import net.dries007.tfc.common.player.IPlayerInfo;
import net.dries007.tfc.config.TFCConfig;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MilkBucketItem.class})
public abstract class MilkBucketItemMixin
extends Item {
    private MilkBucketItemMixin(Item.Properties properties) {
        super(properties);
    }

    @Inject(method={"finishUsingItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void changeBehaviorOfDrinkingMilk(ItemStack stack, Level level, LivingEntity entity, CallbackInfoReturnable<ItemStack> cir) {
        if (!TFCConfig.SERVER.enableVanillaDrinkingMilkClearsPotionEffects.get().booleanValue()) {
            Player player;
            if (entity instanceof Player) {
                player = (Player)entity;
                IPlayerInfo.get(player).eat(FoodData.MILK);
            }
            if (entity instanceof ServerPlayer) {
                player = (ServerPlayer)entity;
                CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)player, stack);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
            if (entity instanceof Player) {
                player = (Player)entity;
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
            }
            cir.setReturnValue((Object)(stack.isEmpty() ? new ItemStack((ItemLike)Items.BUCKET) : stack));
        }
    }
}

