/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.mixin;

import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.wood.ILeavesBlock;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SnowLayerBlock.class})
public abstract class SnowLayerBlockMixin
extends Block {
    private SnowLayerBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public float getSpeedFactor() {
        return TFCConfig.SERVER.enableSnowSlowEntities.get() != false ? 0.6f : 1.0f;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        int prevLayers = (Integer)state.getValue((Property)SnowLayerBlock.LAYERS);
        if (prevLayers > 1 && !player.isCreative()) {
            return level.setBlock(pos, (BlockState)state.setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(prevLayers - 1)), level.isClientSide() ? 11 : 3);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    @Inject(method={"canSurvive"}, at={@At(value="RETURN")}, cancellable=true)
    private void canSurviveAddIceAndLeavesConditions(BlockState state, LevelReader level, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        if (!cir.getReturnValueZ() && level.getBlockState(pos.below()).getBlock() instanceof ILeavesBlock && (Integer)state.getValue((Property)SnowLayerBlock.LAYERS) == 1) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"updateShape"}, at={@At(value="RETURN")}, cancellable=true)
    private void updateShapeSurviveOnLeavesWithSingleLayer(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos, CallbackInfoReturnable<BlockState> cir) {
        BlockState state;
        if (Helpers.isBlock((BlockState)cir.getReturnValue(), Blocks.AIR) && (Integer)stateIn.getValue((Property)SnowLayerBlock.LAYERS) > 1 && (state = (BlockState)stateIn.setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(1))).canSurvive((LevelReader)level, currentPos)) {
            cir.setReturnValue((Object)state);
        }
    }

    @Inject(method={"getStateForPlacement"}, at={@At(value="HEAD")}, cancellable=true)
    private void getStateForPlacementOnSnowPile(BlockPlaceContext context, CallbackInfoReturnable<BlockState> cir) {
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        if (Helpers.isBlock(state, (Block)TFCBlocks.SNOW_PILE.get())) {
            cir.setReturnValue((Object)((BlockState)state.setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(Math.min(8, (Integer)state.getValue((Property)SnowLayerBlock.LAYERS) + 1)))));
        }
    }
}

