/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import io.netty.buffer.ByteBuf;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.network.PacketHandler;
import net.dries007.tfc.network.StreamCodecs;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.ForestType;
import net.dries007.tfc.world.chunkdata.LerpFloatLayer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;

public record ChunkWatchPacket(ChunkPos pos, LerpFloatLayer rainfall, LerpFloatLayer rainVariance, LerpFloatLayer baseGroundwater, LerpFloatLayer temperature, ForestType forestType) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ChunkWatchPacket> TYPE = PacketHandler.type("chunk_watch");
    public static final StreamCodec<ByteBuf, ChunkWatchPacket> CODEC = new StreamCodec<ByteBuf, ChunkWatchPacket>(){

        public ChunkWatchPacket decode(ByteBuf byteBuf) {
            ChunkPos chunkPos = (ChunkPos)StreamCodecs.CHUNK_POS.decode((Object)byteBuf);
            LerpFloatLayer rainfall = (LerpFloatLayer)LerpFloatLayer.STREAM_CODEC.decode((Object)byteBuf);
            LerpFloatLayer rainVariance = (LerpFloatLayer)LerpFloatLayer.STREAM_CODEC.decode((Object)byteBuf);
            LerpFloatLayer baseGroundwater = (LerpFloatLayer)LerpFloatLayer.STREAM_CODEC.decode((Object)byteBuf);
            LerpFloatLayer temperature = (LerpFloatLayer)LerpFloatLayer.STREAM_CODEC.decode((Object)byteBuf);
            ForestType forestType = (ForestType)((Object)ForestType.STREAM.decode((Object)byteBuf));
            return new ChunkWatchPacket(chunkPos, rainfall, rainVariance, baseGroundwater, temperature, forestType);
        }

        public void encode(ByteBuf o, ChunkWatchPacket chunkWatchPacket) {
            StreamCodecs.CHUNK_POS.encode((Object)o, (Object)chunkWatchPacket.pos);
            LerpFloatLayer.STREAM_CODEC.encode((Object)o, (Object)chunkWatchPacket.rainfall);
            LerpFloatLayer.STREAM_CODEC.encode((Object)o, (Object)chunkWatchPacket.rainVariance);
            LerpFloatLayer.STREAM_CODEC.encode((Object)o, (Object)chunkWatchPacket.baseGroundwater);
            LerpFloatLayer.STREAM_CODEC.encode((Object)o, (Object)chunkWatchPacket.temperature);
            ForestType.STREAM.encode((Object)o, (Object)chunkWatchPacket.forestType);
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    void handle() {
        LevelChunk chunk;
        ChunkData data;
        Level level = ClientHelpers.getLevel();
        if (level != null && (data = ChunkData.get((ChunkAccess)(chunk = level.getChunk(this.pos.x, this.pos.z)))).status() != ChunkData.Status.INVALID) {
            data.onUpdatePacket(this.rainfall, this.rainVariance, this.baseGroundwater, this.temperature, this.forestType);
        }
    }
}

