/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import io.netty.buffer.ByteBuf;
import net.dries007.tfc.common.entities.livestock.pet.TamableMammal;
import net.dries007.tfc.network.PacketHandler;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public record PetCommandPacket(int entityId, TamableMammal.Command command) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PetCommandPacket> TYPE = PacketHandler.type("pet_command");
    public static final StreamCodec<ByteBuf, PetCommandPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, c -> c.entityId, TamableMammal.Command.STREAM, c -> c.command, PetCommandPacket::new);

    public PetCommandPacket(Entity entityId, TamableMammal.Command command) {
        this(entityId.getId(), command);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    void handle(@Nullable ServerPlayer player) {
        Entity entity;
        if (player != null && (entity = player.serverLevel().getEntity(this.entityId)) instanceof TamableMammal) {
            TamableMammal pet = (TamableMammal)entity;
            if (pet.willListenTo(this.command, false)) {
                pet.receiveCommand(player, this.command);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"tfc.pet.will_not_listen"), true);
            }
        }
    }
}

