/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.dries007.tfc.common.container.ButtonHandlerContainer;
import net.dries007.tfc.network.PacketHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public record ScreenButtonPacket(int buttonId, Optional<CompoundTag> extraNbt) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ScreenButtonPacket> TYPE = PacketHandler.type("screen_button");
    public static final StreamCodec<ByteBuf, ScreenButtonPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, c -> c.buttonId, (StreamCodec)ByteBufCodecs.OPTIONAL_COMPOUND_TAG, c -> c.extraNbt, ScreenButtonPacket::new);

    public ScreenButtonPacket(int buttonId) {
        this(buttonId, Optional.empty());
    }

    public ScreenButtonPacket(int buttonId, CompoundTag extraNbt) {
        this(buttonId, Optional.of(extraNbt));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    void handle(@Nullable ServerPlayer player) {
        AbstractContainerMenu abstractContainerMenu;
        if (player != null && (abstractContainerMenu = player.containerMenu) instanceof ButtonHandlerContainer) {
            ButtonHandlerContainer handler = (ButtonHandlerContainer)abstractContainerMenu;
            handler.onButtonPress(this.buttonId, this.extraNbt.orElse(null));
        }
    }
}

