/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import com.mojang.datafixers.util.Function7;
import com.mojang.datafixers.util.Function8;
import io.netty.buffer.ByteBuf;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public interface StreamCodecs {
    public static final StreamCodec<ByteBuf, ChunkPos> CHUNK_POS;
    public static final StreamCodec<RegistryFriendlyByteBuf, Block> BLOCK;
    public static final StreamCodec<RegistryFriendlyByteBuf, BlockState> BLOCK_STATE;

    public static <E extends Enum<E>> StreamCodec<ByteBuf, E> forEnum(Supplier<E[]> values) {
        Enum[] valuesArray = (Enum[])values.get();
        if (!3.$assertionsDisabled && valuesArray.length > 127) {
            throw new AssertionError();
        }
        return ByteBufCodecs.BYTE.map(e -> valuesArray[e], e -> (byte)e.ordinal());
    }

    public static <B, C, T1, T2, T3, T4, T5, T6, T7> StreamCodec<B, C> composite(final StreamCodec<? super B, T1> codec1, final Function<C, T1> getter1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> getter2, final StreamCodec<? super B, T3> codec3, final Function<C, T3> getter3, final StreamCodec<? super B, T4> codec4, final Function<C, T4> getter4, final StreamCodec<? super B, T5> codec5, final Function<C, T5> getter5, final StreamCodec<? super B, T6> codec6, final Function<C, T6> getter6, final StreamCodec<? super B, T7> codec7, final Function<C, T7> getter7, final Function7<T1, T2, T3, T4, T5, T6, T7, C> factory) {
        return new StreamCodec<B, C>(){

            public C decode(B buffer) {
                Object t1 = codec1.decode(buffer);
                Object t2 = codec2.decode(buffer);
                Object t3 = codec3.decode(buffer);
                Object t4 = codec4.decode(buffer);
                Object t5 = codec5.decode(buffer);
                Object t6 = codec6.decode(buffer);
                Object t7 = codec7.decode(buffer);
                return factory.apply(t1, t2, t3, t4, t5, t6, t7);
            }

            public void encode(B buffer, C value) {
                codec1.encode(buffer, getter1.apply(value));
                codec2.encode(buffer, getter2.apply(value));
                codec3.encode(buffer, getter3.apply(value));
                codec4.encode(buffer, getter4.apply(value));
                codec5.encode(buffer, getter5.apply(value));
                codec6.encode(buffer, getter6.apply(value));
                codec7.encode(buffer, getter7.apply(value));
            }
        };
    }

    public static <B, C, T1, T2, T3, T4, T5, T6, T7, T8> StreamCodec<B, C> composite(final StreamCodec<? super B, T1> codec1, final Function<C, T1> getter1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> getter2, final StreamCodec<? super B, T3> codec3, final Function<C, T3> getter3, final StreamCodec<? super B, T4> codec4, final Function<C, T4> getter4, final StreamCodec<? super B, T5> codec5, final Function<C, T5> getter5, final StreamCodec<? super B, T6> codec6, final Function<C, T6> getter6, final StreamCodec<? super B, T7> codec7, final Function<C, T7> getter7, final StreamCodec<? super B, T8> codec8, final Function<C, T8> getter8, final Function8<T1, T2, T3, T4, T5, T6, T7, T8, C> factory) {
        return new StreamCodec<B, C>(){

            public C decode(B buffer) {
                Object t1 = codec1.decode(buffer);
                Object t2 = codec2.decode(buffer);
                Object t3 = codec3.decode(buffer);
                Object t4 = codec4.decode(buffer);
                Object t5 = codec5.decode(buffer);
                Object t6 = codec6.decode(buffer);
                Object t7 = codec7.decode(buffer);
                Object t8 = codec8.decode(buffer);
                return factory.apply(t1, t2, t3, t4, t5, t6, t7, t8);
            }

            public void encode(B buffer, C value) {
                codec1.encode(buffer, getter1.apply(value));
                codec2.encode(buffer, getter2.apply(value));
                codec3.encode(buffer, getter3.apply(value));
                codec4.encode(buffer, getter4.apply(value));
                codec5.encode(buffer, getter5.apply(value));
                codec6.encode(buffer, getter6.apply(value));
                codec7.encode(buffer, getter7.apply(value));
                codec8.encode(buffer, getter8.apply(value));
            }
        };
    }

    static {
        if (3.$assertionsDisabled) {
            // empty if block
        }
        CHUNK_POS = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, c -> c.x, (StreamCodec)ByteBufCodecs.VAR_INT, c -> c.z, ChunkPos::new);
        BLOCK = ByteBufCodecs.registry((ResourceKey)Registries.BLOCK);
        BLOCK_STATE = BLOCK.map(Block::defaultBlockState, BlockBehaviour.BlockStateBase::getBlock);
    }
}

