/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import java.util.Collections;
import java.util.function.Supplier;
import net.dries007.tfc.util.InteractionManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;

public class BlockItemPlacement
implements InteractionManager.OnItemUseAction {
    private final ItemLike item;
    private final Supplier<? extends Block> block;

    public static boolean placeBlock(BlockPlaceContext context, BlockState state) {
        return context.getLevel().setBlock(context.getClickedPos(), state, 11);
    }

    public static boolean canPlace(BlockPlaceContext context, BlockState stateToPlace) {
        return BlockItemPlacement.canPlace(context, stateToPlace, context.getClickedPos());
    }

    public static boolean canPlace(BlockPlaceContext context, BlockState stateToPlace, BlockPos pos) {
        Player player = context.getPlayer();
        CollisionContext selectionContext = player == null ? CollisionContext.empty() : CollisionContext.of((Entity)player);
        return stateToPlace.canSurvive((LevelReader)context.getLevel(), pos) && context.getLevel().isUnobstructed(stateToPlace, pos, selectionContext);
    }

    public static BlockState updateBlockStateFromTag(BlockPos pos, Level level, ItemStack stack, BlockState state) {
        BlockItemStateProperties properties = (BlockItemStateProperties)stack.getOrDefault(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY);
        if (properties.isEmpty()) {
            return state;
        }
        BlockState newState = properties.apply(state);
        if (newState != state) {
            level.setBlock(pos, newState, 2);
        }
        return newState;
    }

    public BlockItemPlacement(ItemLike item, Supplier<? extends Block> block) {
        this.item = item;
        this.block = block;
    }

    public Iterable<Item> getItems() {
        return Collections.singleton(this.item.asItem());
    }

    public Item getItem() {
        return this.item.asItem();
    }

    @Override
    public InteractionResult onItemUse(ItemStack stack, UseOnContext context) {
        Player player = context.getPlayer();
        if (player != null && !player.getAbilities().mayBuild) {
            return InteractionResult.PASS;
        }
        Item item = this.getItem();
        InteractionResult result = this.place(new BlockPlaceContext(context));
        if (player != null && result.consumesAction()) {
            player.awardStat(Stats.ITEM_USED.get((Object)item));
        }
        return result;
    }

    public InteractionResult place(BlockPlaceContext context) {
        if (!context.canPlace()) {
            return InteractionResult.FAIL;
        }
        BlockState placementState = this.getPlacementState(context);
        if (placementState == null) {
            return InteractionResult.FAIL;
        }
        if (!BlockItemPlacement.placeBlock(context, placementState)) {
            return InteractionResult.FAIL;
        }
        return this.postPlacement(context);
    }

    public InteractionResult postPlacement(BlockPlaceContext context) {
        return this.postPlacement(context, context.getClickedPos());
    }

    public InteractionResult postPlacement(BlockPlaceContext context, BlockPos pos) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        BlockState placedState = level.getBlockState(pos);
        SoundType placementSound = placedState.getSoundType((LevelReader)level, pos, (Entity)player);
        level.playSound(player, pos, placedState.getSoundType((LevelReader)level, pos, (Entity)player).getPlaceSound(), SoundSource.BLOCKS, (placementSound.getVolume() + 1.0f) / 2.0f, placementSound.getPitch() * 0.8f);
        if (player == null || !player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext context) {
        BlockState placementState = this.block.get().getStateForPlacement(context);
        return placementState != null && BlockItemPlacement.canPlace(context, placementState) ? placementState : null;
    }
}

