/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.dries007.tfc.common.blockentities.ChannelBlockEntity;
import net.dries007.tfc.common.blockentities.CrucibleBlockEntity;
import net.dries007.tfc.common.blockentities.MoldTableBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.devices.ChannelBlock;
import net.dries007.tfc.common.blocks.devices.MoldTableBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.tuple.Pair;

public class ChannelFlow {
    public static void fromCrucible(LevelAccessor level, CrucibleBlockEntity source, BlockPos originChannel) {
        Optional<IFluidHandler> iFldHandler = MoldTableBlockEntity.getFluidHandlerIfAppropriate(source, Optional.empty());
        if (iFldHandler.isEmpty()) {
            return;
        }
        FluidStack fluidStack = iFldHandler.get().drain(1, IFluidHandler.FluidAction.SIMULATE);
        Fluid fluid = fluidStack.getFluid();
        ResourceLocation fluidKey = BuiltInRegistries.FLUID.getKey((Object)fluid);
        int counter = 0;
        HashBiMap channelsAndMolds = HashBiMap.create();
        HashMap<Object, List<BlockPos>> neighbors = new HashMap<Object, List<BlockPos>>();
        ArrayDeque<BlockPos> pendingVisit = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> molds = new HashSet<BlockPos>();
        pendingVisit.add(originChannel);
        while (pendingVisit.size() > 0) {
            BlockPos current = (BlockPos)pendingVisit.pop();
            if (channelsAndMolds.containsValue((Object)current)) continue;
            channelsAndMolds.put((Object)counter, (Object)current);
            ++counter;
            List<BlockPos> adjacentChannels = ChannelFlow.findAdjacent(level, current, false);
            List<BlockPos> adjacentMolds = ChannelFlow.findAdjacent(level, current, true);
            adjacentChannels.stream().forEach(adj -> pendingVisit.add((BlockPos)adj));
            molds.addAll(adjacentMolds);
            neighbors.put(current, adjacentChannels);
            ((List)neighbors.get(current)).addAll(adjacentMolds);
        }
        molds.removeIf(pos -> {
            Optional moldEnt = level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.MOLD_TABLE.get());
            if (moldEnt.isEmpty()) {
                return true;
            }
            if (!((MoldTableBlockEntity)moldEnt.get()).getOutputStack().isEmpty()) {
                return true;
            }
            FluidStack outputDrop = ((IFluidHandler)iFldHandler.get()).drain(1, IFluidHandler.FluidAction.SIMULATE);
            return !ChannelFlow.couldBeFilled(((MoldTableBlockEntity)moldEnt.get()).getInventory(), outputDrop, 0);
        });
        if (molds.size() == 0) {
            return;
        }
        for (BlockPos mold2 : molds) {
            channelsAndMolds.put((Object)counter, (Object)mold2);
            ++counter;
        }
        int[][] graph = new int[channelsAndMolds.size()][channelsAndMolds.size()];
        double[][] heuristic = new double[channelsAndMolds.size()][channelsAndMolds.size()];
        for (BlockPos channel2 : channelsAndMolds.values()) {
            if (!neighbors.containsKey(channel2)) continue;
            for (BlockPos neighborChannelOrMold : (List)neighbors.get(channel2)) {
                int x = (Integer)channelsAndMolds.inverse().get((Object)channel2);
                if (!channelsAndMolds.containsValue((Object)neighborChannelOrMold)) continue;
                int y = (Integer)channelsAndMolds.inverse().get((Object)neighborChannelOrMold);
                graph[x][y] = 1;
                if (heuristic[x][y] != 0.0) continue;
                double d = Math.sqrt(channel2.distSqr((Vec3i)neighborChannelOrMold));
                heuristic[y][x] = d;
                heuristic[x][y] = d;
            }
        }
        HashMap<BlockPos, Pair> flowSource = new HashMap<BlockPos, Pair>();
        HashMap<BlockPos, Integer> numFlows = new HashMap<BlockPos, Integer>();
        for (BlockPos mold3 : molds) {
            List<BlockPos> path = ChannelFlow.aStar(graph, heuristic, 0, (Integer)channelsAndMolds.inverse().get((Object)mold3)).stream().map(arg_0 -> ((BiMap)channelsAndMolds).get(arg_0)).toList();
            for (int i = 0; i < path.size() - 1; ++i) {
                BlockPos currentChannel = path.get(i);
                BlockPos channelSource = path.get(i + 1);
                BlockPos relative = channelSource.offset((Vec3i)currentChannel.multiply(-1));
                int distance = Math.abs(relative.getX() + relative.getY() + relative.getZ());
                BlockPos normal = new BlockPos(relative.getX() / distance, relative.getY() / distance, relative.getZ() / distance);
                flowSource.put(currentChannel, Pair.of((Object)Direction.fromDelta((int)normal.getX(), (int)normal.getY(), (int)normal.getZ()), (Object)((byte)distance)));
                numFlows.put(channelSource, numFlows.getOrDefault(channelSource, 0) + 1);
            }
        }
        for (BlockPos channelOrMold : flowSource.keySet()) {
            level.getBlockEntity(channelOrMold, (BlockEntityType)TFCBlockEntities.CHANNEL.get()).ifPresent(channel -> channel.setLinkProperties((Pair<Direction, Byte>)((Pair)flowSource.get(channelOrMold)), true, (Integer)numFlows.get(channelOrMold), fluidKey));
            level.getBlockEntity(channelOrMold, (BlockEntityType)TFCBlockEntities.MOLD_TABLE.get()).ifPresent(mold -> mold.setSource(source.getBlockPos(), fluid, (Pair<Direction, Byte>)((Pair)flowSource.get(channelOrMold))));
        }
        BlockPos pos2 = source.getBlockPos().offset((Vec3i)originChannel.multiply(-1));
        ((ChannelBlockEntity)((Object)level.getBlockEntity(originChannel, (BlockEntityType)TFCBlockEntities.CHANNEL.get()).get())).setLinkProperties((Pair<Direction, Byte>)Pair.of((Object)Direction.fromDelta((int)pos2.getX(), (int)pos2.getY(), (int)pos2.getZ()), (Object)1), false, (Integer)numFlows.get(originChannel), fluidKey);
    }

    private static List<BlockPos> findAdjacent(LevelAccessor level, BlockPos current, boolean findMolds) {
        ArrayList<BlockPos> adjacent = new ArrayList<BlockPos>();
        block0: for (Direction dir : Direction.values()) {
            if (dir == Direction.UP) continue;
            int maxDistance = dir == Direction.DOWN ? 127 : 1;
            for (int i = 1; i < maxDistance + 1; i = (int)((byte)(i + 1))) {
                BlockPos relative = current.relative(dir, i);
                BlockState blockState = level.getBlockState(relative);
                if (findMolds && blockState.getBlock() instanceof MoldTableBlock) {
                    adjacent.add(relative);
                    continue block0;
                }
                if (!findMolds && blockState.getBlock() instanceof ChannelBlock) {
                    adjacent.add(relative);
                    continue block0;
                }
                if (!blockState.isAir()) continue block0;
            }
        }
        return adjacent;
    }

    private static List<Integer> aStar(int[][] graph, double[][] heuristic, int start, int goal) {
        int[] distances = new int[graph.length];
        Arrays.fill(distances, Integer.MAX_VALUE);
        distances[start] = 0;
        int[] parent = new int[graph.length];
        double[] priorities = new double[graph.length];
        Arrays.fill(priorities, 2.147483647E9);
        priorities[start] = heuristic[start][goal];
        boolean[] visited = new boolean[graph.length];
        while (true) {
            int i;
            double lowestPriority = 2.147483647E9;
            int lowestPriorityIndex = -1;
            for (i = 0; i < priorities.length; ++i) {
                if (!(priorities[i] < lowestPriority) || visited[i]) continue;
                lowestPriority = priorities[i];
                lowestPriorityIndex = i;
            }
            if (lowestPriorityIndex == -1) {
                throw new IllegalArgumentException("Illegal graph! No connection between start and end.");
            }
            if (lowestPriorityIndex == goal) {
                ArrayList<Integer> finalPath = new ArrayList<Integer>();
                int currentIndex = lowestPriorityIndex;
                while (currentIndex != start) {
                    finalPath.add(currentIndex);
                    currentIndex = parent[currentIndex];
                }
                finalPath.add(start);
                return finalPath;
            }
            for (i = 0; i < graph[lowestPriorityIndex].length; ++i) {
                if (graph[lowestPriorityIndex][i] == 0 || visited[i] || distances[lowestPriorityIndex] + graph[lowestPriorityIndex][i] >= distances[i]) continue;
                distances[i] = distances[lowestPriorityIndex] + graph[lowestPriorityIndex][i];
                parent[i] = lowestPriorityIndex;
                priorities[i] = (double)distances[i] + heuristic[i][goal];
            }
            visited[lowestPriorityIndex] = true;
        }
    }

    public static boolean couldBeFilled(IItemHandlerModifiable inventory, FluidStack fluidStack, int slot) {
        ItemStack stack;
        IFluidHandler fluidCap;
        if (!fluidStack.isEmpty() && (fluidCap = (IFluidHandler)(stack = inventory.getStackInSlot(slot)).getCapability(Capabilities.FluidHandler.ITEM)) != null) {
            int filled = fluidCap.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE);
            return filled > 0;
        }
        return false;
    }
}

