/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import java.util.stream.Stream;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.QuernBlockEntity;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.QuernBlock;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.items.FluidContainerItem;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.common.items.TFCMinecartItem;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.events.StartFireEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public final class DispenserBehaviors {
    public static final DispenseItemBehavior DEFAULT = new DefaultDispenseItemBehavior();
    public static final DispenseItemBehavior VANILLA_BUCKET_BEHAVIOR = new DefaultDispenseItemBehavior(){

        public ItemStack execute(BlockSource source, ItemStack stack) {
            BucketItem bucket = (BucketItem)stack.getItem();
            BlockPos pos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
            ServerLevel level = source.level();
            if (bucket.emptyContents(null, (Level)level, pos, null, stack)) {
                bucket.checkExtraContent(null, (Level)level, stack, pos);
                return new ItemStack((ItemLike)Items.BUCKET);
            }
            return DEFAULT.dispense(source, stack);
        }
    };
    public static final DispenseItemBehavior TFC_BUCKET_BEHAVIOR = new DefaultDispenseItemBehavior(){

        public ItemStack execute(BlockSource source, ItemStack stack) {
            ServerLevel level = source.level();
            BlockPos pos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
            Item item = stack.getItem();
            if (item instanceof FluidContainerItem) {
                FluidContainerItem item2 = (FluidContainerItem)item;
                MutableObject result = new MutableObject();
                result.setValue((Object)stack);
                FluidHelpers.transferBetweenWorldAndItem(stack, (Level)level, pos, null, (arg_0, arg_1) -> 2.lambda$execute$0((Mutable)result, source, arg_0, arg_1), item2.canPlaceLiquidsInWorld(), item2.canPlaceSourceBlocks(), false);
                return (ItemStack)result.getValue();
            }
            return stack;
        }

        private static /* synthetic */ void lambda$execute$0(Mutable result, BlockSource source, ItemStack newOriginalStack, ItemStack newContainerStack) {
            ItemStack leftover;
            result.setValue((Object)newOriginalStack);
            if (!newContainerStack.isEmpty() && !(leftover = source.blockEntity().insertItem(newContainerStack)).isEmpty()) {
                DEFAULT.dispense(source, newContainerStack);
            }
        }
    };
    public static final DispenseItemBehavior CHEST_BEHAVIOR = new OptionalDispenseItemBehavior(){

        public ItemStack execute(BlockSource level, ItemStack stack) {
            BlockPos blockpos = level.pos().relative((Direction)level.state().getValue((Property)DispenserBlock.FACING));
            for (AbstractChestedHorse horse2 : level.level().getEntitiesOfClass(AbstractChestedHorse.class, new AABB(blockpos), horse -> horse.isAlive() && !horse.hasChest())) {
                if (!horse2.isTamed() || !horse2.getSlot(499).set(stack)) continue;
                stack.shrink(1);
                this.setSuccess(true);
                return stack;
            }
            return super.execute(level, stack);
        }
    };
    public static DispenseItemBehavior MINECART_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultBehavior = new DefaultDispenseItemBehavior();

        public ItemStack execute(BlockSource source, ItemStack stack) {
            Item item = stack.getItem();
            if (item instanceof TFCMinecartItem) {
                double offset;
                RailShape railshape;
                TFCMinecartItem cartItem = (TFCMinecartItem)item;
                Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
                ServerLevel level = source.level();
                double x = source.center().x + (double)direction.getStepX() * 1.125;
                double y = Math.floor(source.center().y) + (double)direction.getStepY();
                double z = source.center().z + (double)direction.getStepZ() * 1.125;
                BlockPos offsetPos = source.pos().relative(direction);
                BlockState state = level.getBlockState(offsetPos);
                RailShape railShape = railshape = state.getBlock() instanceof BaseRailBlock ? ((BaseRailBlock)state.getBlock()).getRailDirection(state, (BlockGetter)level, offsetPos, null) : RailShape.NORTH_SOUTH;
                if (Helpers.isBlock(state, (TagKey<Block>)BlockTags.RAILS)) {
                    offset = railshape.isAscending() ? 0.6 : 0.1;
                } else {
                    if (!state.isAir() || !Helpers.isBlock(level.getBlockState(offsetPos.below()), (TagKey<Block>)BlockTags.RAILS)) {
                        return this.defaultBehavior.dispense(source, stack);
                    }
                    BlockState offsetState = level.getBlockState(offsetPos.below());
                    RailShape offsetShape = offsetState.getBlock() instanceof BaseRailBlock ? (RailShape)offsetState.getValue(((BaseRailBlock)offsetState.getBlock()).getShapeProperty()) : RailShape.NORTH_SOUTH;
                    offset = direction != Direction.DOWN && offsetShape.isAscending() ? -0.4 : -0.9;
                }
                cartItem.createMinecartEntity((Level)level, stack, x, y + offset, z);
                return stack;
            }
            return ItemStack.EMPTY;
        }

        protected void playSound(BlockSource source) {
            source.level().levelEvent(1000, source.pos(), 0);
        }
    };
    public static final OptionalDispenseItemBehavior TFC_FLINT_AND_STEEL_BEHAVIOR = new OptionalDispenseItemBehavior(){

        protected ItemStack execute(BlockSource source, ItemStack stack) {
            ServerLevel level = source.level();
            Direction facing = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            BlockPos pos = source.pos().relative(facing);
            BlockState state = level.getBlockState(pos);
            if (TFCConfig.SERVER.dispenserEnableLighting.get().booleanValue() && StartFireEvent.startFire((Level)level, pos, state, facing.getOpposite(), null, stack, StartFireEvent.FireStrength.STRONG, 1.0)) {
                stack.hurtAndBreak(1, level, null, i -> {});
                return stack;
            }
            this.setSuccess(false);
            return stack;
        }
    };
    public static final DispenseItemBehavior HANDSTONE_BEHAVIOR = new DefaultDispenseItemBehavior(){

        public ItemStack execute(BlockSource source, ItemStack stack) {
            QuernBlockEntity quern;
            BlockEntity blockEntity;
            ServerLevel level = source.level();
            BlockPos pos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
            if (Helpers.isItem(stack, TFCTags.Items.QUERN_HANDSTONES) && level.getBlockState(pos).getBlock() instanceof QuernBlock && (blockEntity = level.getBlockEntity(pos)) instanceof QuernBlockEntity && !(quern = (QuernBlockEntity)blockEntity).hasHandstone()) {
                return ((ItemStackHandler)quern.getInventory()).insertItem(0, stack, false);
            }
            return stack;
        }
    };

    public static void registerDispenserBehaviors() {
        Stream.of(TFCItems.BLUE_STEEL_BUCKET, TFCItems.RED_STEEL_BUCKET, TFCItems.JUG, TFCItems.WOODEN_BUCKET, TFCItems.SILICA_GLASS_BOTTLE, TFCItems.HEMATITIC_GLASS_BOTTLE, TFCItems.OLIVINE_GLASS_BOTTLE, TFCItems.VOLCANIC_GLASS_BOTTLE).forEach(reg -> DispenserBlock.registerBehavior((ItemLike)((ItemLike)reg.get()), (DispenseItemBehavior)TFC_BUCKET_BEHAVIOR));
        Stream.of(TFCItems.COD_BUCKET, TFCItems.JELLYFISH_BUCKET, TFCItems.TROPICAL_FISH_BUCKET, TFCItems.PUFFERFISH_BUCKET).forEach(reg -> DispenserBlock.registerBehavior((ItemLike)((ItemLike)reg.get()), (DispenseItemBehavior)VANILLA_BUCKET_BEHAVIOR));
        TFCItems.FLUID_BUCKETS.values().forEach(reg -> DispenserBlock.registerBehavior((ItemLike)((ItemLike)reg.get()), (DispenseItemBehavior)VANILLA_BUCKET_BEHAVIOR));
        TFCItems.FRESHWATER_FISH_BUCKETS.values().forEach(reg -> DispenserBlock.registerBehavior((ItemLike)((ItemLike)reg.get()), (DispenseItemBehavior)VANILLA_BUCKET_BEHAVIOR));
        TFCBlocks.WOODS.values().stream().map(map -> (Block)((TFCBlocks.Id)map.get((Object)Wood.BlockType.CHEST)).get()).forEach(chest -> DispenserBlock.registerBehavior((ItemLike)chest, (DispenseItemBehavior)CHEST_BEHAVIOR));
        TFCItems.CHEST_MINECARTS.values().forEach(reg -> DispenserBlock.registerBehavior((ItemLike)((ItemLike)reg.get()), (DispenseItemBehavior)MINECART_BEHAVIOR));
        DispenserBlock.registerBehavior((ItemLike)Items.EGG, (DispenseItemBehavior)new DefaultDispenseItemBehavior());
        DispenserBlock.registerBehavior((ItemLike)Items.FLINT_AND_STEEL, (DispenseItemBehavior)new MultipleItemBehavior(TFC_FLINT_AND_STEEL_BEHAVIOR, (DispenseItemBehavior)DispenserBlock.DISPENSER_REGISTRY.get(Items.FLINT_AND_STEEL)));
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)TFCItems.HANDSTONE.get()), (DispenseItemBehavior)HANDSTONE_BEHAVIOR);
    }

    public static class MultipleItemBehavior
    implements DispenseItemBehavior {
        private final OptionalDispenseItemBehavior primary;
        private final DispenseItemBehavior defaultBehavior;

        public MultipleItemBehavior(OptionalDispenseItemBehavior first, DispenseItemBehavior second) {
            this.primary = first;
            this.defaultBehavior = second;
        }

        public ItemStack dispense(BlockSource source, ItemStack stack) {
            ItemStack result = this.primary.dispense(source, stack);
            if (this.primary.isSuccess()) {
                return result;
            }
            return this.defaultBehavior.dispense(source, stack);
        }
    }
}

