/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;

public final class EnvironmentHelpers {
    public static float adjustAvgTempForElev(int y, float averageTemp) {
        return EnvironmentHelpers.adjustAvgTempForElev(y, averageTemp, 63.0f);
    }

    public static float adjustAvgTempForElev(int y, float averageTemp, float seaLevel) {
        if ((float)y > seaLevel) {
            float elevationTemperature = Mth.clamp((float)(((float)y - seaLevel) * 0.16225f), (float)0.0f, (float)17.822f);
            return averageTemp - elevationTemperature;
        }
        return averageTemp;
    }

    public static boolean isAdjacentToNotWater(LevelAccessor level, BlockPos pos) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (EnvironmentHelpers.isWaterAt(level, (BlockPos)mutablePos.setWithOffset((Vec3i)pos, direction))) continue;
            return true;
        }
        return false;
    }

    public static boolean isWaterAt(LevelAccessor level, BlockPos pos) {
        return Helpers.isFluid(level.getFluidState(pos), TFCTags.Fluids.ANY_INFINITE_WATER);
    }

    public static boolean isWorldgenReplaceable(WorldGenLevel level, BlockPos pos) {
        return EnvironmentHelpers.isWorldgenReplaceable(level.getBlockState(pos));
    }

    public static boolean isWorldgenReplaceable(BlockState state) {
        return FluidHelpers.isAirOrEmptyFluid(state) || Helpers.isBlock(state, TFCTags.Blocks.SINGLE_BLOCK_REPLACEABLE);
    }

    public static boolean canPlaceBushOn(WorldGenLevel level, BlockPos pos) {
        BlockState stateAt = level.getBlockState(pos);
        return stateAt.getFluidState().isEmpty() && EnvironmentHelpers.isWorldgenReplaceable(stateAt) && Helpers.isBlock(level.getBlockState(pos.below()), TFCTags.Blocks.BUSH_PLANTABLE_ON);
    }

    public static boolean isOnSturdyFace(WorldGenLevel level, BlockPos pos) {
        pos = pos.below();
        return level.getBlockState(pos).isFaceSturdy((BlockGetter)level, pos, Direction.UP);
    }
}

