/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.MoldTableBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.CharcoalPileBlock;
import net.dries007.tfc.common.blocks.GroundcoverBlockType;
import net.dries007.tfc.common.blocks.SnowPileBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.ThatchBedBlock;
import net.dries007.tfc.common.blocks.devices.DoubleIngotPileBlock;
import net.dries007.tfc.common.blocks.devices.IngotPileBlock;
import net.dries007.tfc.common.blocks.devices.LogPileBlock;
import net.dries007.tfc.common.container.ItemStackContainerProvider;
import net.dries007.tfc.common.container.KnappingContainer;
import net.dries007.tfc.common.container.TFCContainerProviders;
import net.dries007.tfc.common.recipes.ItemRecipe;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.ScrapingRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.ingredients.KeyedIngredient;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.BlockItemPlacement;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.dries007.tfc.util.data.KnappingType;
import net.dries007.tfc.util.events.DouseFireEvent;
import net.dries007.tfc.util.events.StartFireEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public final class InteractionManager {
    private static final ThreadLocal<Boolean> ACTIVE = ThreadLocal.withInitial(() -> false);
    private static final List<CachedEntry> ACTIONS = new ArrayList<CachedEntry>();
    private static final List<FallbackEntry> FALLBACKS = new ArrayList<FallbackEntry>();
    private static final IndirectHashCollection<Item, CachedEntry> CACHE = IndirectHashCollection.create(e -> e.input.keys(), () -> ACTIONS);

    public static void registerBlock(BlockItemPlacement placement) {
        InteractionManager.register(Ingredient.of((ItemLike[])new ItemLike[]{placement.getItem()}), Target.BLOCKS, (OnItemUseAction)placement);
    }

    public static void registerBlock(Ingredient item, OnItemUseAction action) {
        InteractionManager.register(item, Target.BLOCKS, action);
    }

    public static void registerBlock(KeyedIngredient ingredient, OnItemUseAction action) {
        InteractionManager.register(ingredient, Target.BLOCKS, action);
    }

    public static void register(Ingredient item, Target target, OnItemUseAction action) {
        InteractionManager.register(KeyedIngredient.of(item), target, action);
    }

    private static synchronized void register(KeyedIngredient input, Target target, OnItemUseAction action) {
        ACTIONS.add(new CachedEntry(input, target, action));
    }

    public static synchronized void register(ItemAbility ability, Target target, OnItemUseAction action) {
        FALLBACKS.add(new FallbackEntry(ability, target, action));
    }

    public static void registerDefaultInteractions() {
        InteractionManager.registerBlock(Ingredient.of(TFCTags.Items.THATCH_BED_HIDES), (ItemStack stack, UseOnContext context) -> {
            Level level = context.getLevel();
            Player player = context.getPlayer();
            if (!level.isClientSide() && player != null) {
                BlockPos basePos = context.getClickedPos();
                BlockState baseState = level.getBlockState(basePos);
                Direction facing = context.getHorizontalDirection();
                BlockState bed = ((Block)TFCBlocks.THATCH_BED.get()).defaultBlockState();
                for (Direction direction : new Direction[]{facing, facing.getClockWise(), facing.getOpposite(), facing.getCounterClockWise()}) {
                    BlockPos playerPos;
                    BlockPos headPos = basePos.relative(direction, 1);
                    BlockState headState = level.getBlockState(headPos);
                    if (!Helpers.isBlock(baseState, TFCTags.Blocks.THATCH_BED_THATCH) || !Helpers.isBlock(headState, TFCTags.Blocks.THATCH_BED_THATCH) || (playerPos = player.blockPosition()) == headPos || playerPos == basePos) continue;
                    level.setBlock(basePos, (BlockState)((BlockState)bed.setValue((Property)ThatchBedBlock.PART, (Comparable)BedPart.FOOT)).setValue((Property)ThatchBedBlock.FACING, (Comparable)direction), 18);
                    level.setBlock(headPos, (BlockState)((BlockState)bed.setValue((Property)ThatchBedBlock.PART, (Comparable)BedPart.HEAD)).setValue((Property)ThatchBedBlock.FACING, (Comparable)direction), 18);
                    level.getBlockEntity(headPos, (BlockEntityType)TFCBlockEntities.THATCH_BED.get()).ifPresent(entity -> entity.setBed(headState, baseState, stack.split(1)));
                    return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            }
            return InteractionResult.CONSUME;
        });
        InteractionManager.registerBlock(Ingredient.of((ItemLike[])new ItemLike[]{Items.SNOW}), (ItemStack stack, UseOnContext context) -> {
            BlockState stateAt;
            BlockPos pos;
            Player player = context.getPlayer();
            if (player != null && !player.getAbilities().mayBuild) {
                return InteractionResult.PASS;
            }
            BlockPlaceContext blockContext = new BlockPlaceContext(context);
            Level level = blockContext.getLevel();
            if (SnowPileBlock.canPlaceSnowPile((LevelAccessor)level, pos = blockContext.getClickedPos(), stateAt = level.getBlockState(blockContext.getClickedPos()))) {
                SnowPileBlock.placeSnowPile((LevelAccessor)level, pos, stateAt, true);
                BlockState placedState = level.getBlockState(pos);
                SoundType placementSound = placedState.getSoundType((LevelReader)level, pos, (Entity)player);
                Helpers.playPlaceSound(player, (LevelAccessor)level, pos, placedState);
                level.playSound(player, pos, placedState.getSoundType((LevelReader)level, pos, (Entity)player).getPlaceSound(), SoundSource.BLOCKS, (placementSound.getVolume() + 1.0f) / 2.0f, placementSound.getPitch() * 0.8f);
                if (player == null || !player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return ((BlockItem)Items.SNOW).place(blockContext);
        });
        InteractionManager.registerBlock(Ingredient.of((ItemLike[])new ItemLike[]{Items.CHARCOAL}), (ItemStack stack, UseOnContext context) -> {
            Player player = context.getPlayer();
            if (player != null && player.mayBuild()) {
                BlockPlaceContext blockContext = new BlockPlaceContext(context);
                Level level = blockContext.getLevel();
                BlockPos clickedPos = context.getClickedPos();
                BlockPos offsetPos = blockContext.getClickedPos();
                BlockState clickedState = level.getBlockState(clickedPos);
                BlockState offsetState = level.getBlockState(offsetPos);
                BlockItemPlacement placement = new BlockItemPlacement((ItemLike)Items.CHARCOAL, TFCBlocks.CHARCOAL_PILE);
                if (Helpers.isBlock(clickedState, (Block)TFCBlocks.CHARCOAL_PILE.get()) && (Integer)clickedState.getValue((Property)CharcoalPileBlock.LAYERS) < 8) {
                    BlockState placementState = (BlockState)clickedState.setValue((Property)CharcoalPileBlock.LAYERS, (Comparable)Integer.valueOf((Integer)clickedState.getValue((Property)CharcoalPileBlock.LAYERS) + 1));
                    if (BlockItemPlacement.canPlace(blockContext, placementState, clickedPos)) {
                        level.setBlockAndUpdate(clickedPos, placementState);
                        return placement.postPlacement(blockContext, clickedPos);
                    }
                    return InteractionResult.FAIL;
                }
                if (Helpers.isBlock(offsetState, (Block)TFCBlocks.CHARCOAL_PILE.get()) && (Integer)offsetState.getValue((Property)CharcoalPileBlock.LAYERS) < 8) {
                    BlockState placementState = (BlockState)offsetState.setValue((Property)CharcoalPileBlock.LAYERS, (Comparable)Integer.valueOf((Integer)offsetState.getValue((Property)CharcoalPileBlock.LAYERS) + 1));
                    if (BlockItemPlacement.canPlace(blockContext, placementState, offsetPos)) {
                        level.setBlockAndUpdate(offsetPos, placementState);
                        return placement.postPlacement(blockContext, offsetPos);
                    }
                    return InteractionResult.FAIL;
                }
                return placement.place(blockContext);
            }
            return InteractionResult.PASS;
        });
        BlockItemPlacement logPilePlacement = new BlockItemPlacement((ItemLike)Items.AIR, TFCBlocks.LOG_PILE);
        InteractionManager.registerBlock(Ingredient.of(TFCTags.Items.LOG_PILE_LOGS), (ItemStack stack, UseOnContext context) -> {
            Player player = context.getPlayer();
            if (player != null && player.mayBuild() && player.isShiftKeyDown()) {
                Level level = context.getLevel();
                Direction direction = context.getClickedFace();
                BlockPos posClicked = context.getClickedPos();
                BlockState stateClicked = level.getBlockState(posClicked);
                BlockPos relativePos = posClicked.relative(direction);
                if (Helpers.isBlock(stateClicked, (Block)TFCBlocks.LOG_PILE.get())) {
                    return level.getBlockEntity(posClicked, (BlockEntityType)TFCBlockEntities.LOG_PILE.get()).map(logPileBlockEntity -> {
                        if (!level.isClientSide()) {
                            LogPileBlock.insertAndPushUp(stack, stateClicked, level, posClicked, logPileBlockEntity, true);
                            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                        }
                        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                    }).orElse(InteractionResult.PASS);
                }
                if (level.getBlockState(relativePos.below()).isFaceSturdy((BlockGetter)level, relativePos.below(), Direction.UP)) {
                    ItemStack stackBefore = stack.copy();
                    BlockPos actualPlacedPos = new BlockPlaceContext(context).getClickedPos();
                    InteractionResult result = logPilePlacement.onItemUse(stack, context);
                    if (result.consumesAction()) {
                        Helpers.insertOne(level, actualPlacedPos, TFCBlockEntities.LOG_PILE, stackBefore);
                    }
                    return result;
                }
            }
            return InteractionResult.PASS;
        });
        InteractionManager.registerBlock(KeyedIngredient.ofMatchingAnyRecipeInput(TFCRecipeTypes.SCRAPING, ScrapingRecipe.CACHE, ItemRecipe::getIngredient), (ItemStack stack, UseOnContext context) -> {
            Level level = context.getLevel();
            ScrapingRecipe recipe = ScrapingRecipe.getRecipe(stack);
            if (recipe != null) {
                BlockPos pos = context.getClickedPos();
                BlockPos abovePos = pos.above();
                Player player = context.getPlayer();
                if (player != null && context.getClickedFace() == Direction.UP && Helpers.isBlock(level.getBlockState(pos), TFCTags.Blocks.SCRAPING_SURFACE) && level.getBlockState(abovePos).isAir()) {
                    BlockState state = ((Block)TFCBlocks.SCRAPING.get()).defaultBlockState();
                    level.setBlockAndUpdate(abovePos, state);
                    return level.getBlockEntity(abovePos, (BlockEntityType)TFCBlockEntities.SCRAPING.get()).map(entity -> {
                        ItemStack insertStack = stack.split(1);
                        stack.setCount(stack.getCount() + ((ItemStackHandler)entity.getInventory()).insertItem(0, insertStack, false).getCount());
                        entity.updateDisplayCache();
                        level.sendBlockUpdated(abovePos, state, state, 2);
                        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                    }).orElse(InteractionResult.PASS);
                }
            }
            return InteractionResult.PASS;
        });
        for (GroundcoverBlockType type : GroundcoverBlockType.values()) {
            if (type.getVanillaItem() == null) continue;
            InteractionManager.registerBlock(new BlockItemPlacement(type.getVanillaItem(), (Supplier<? extends Block>)TFCBlocks.GROUNDCOVER.get((Object)type)));
        }
        InteractionManager.registerBlock(new BlockItemPlacement((ItemLike)Items.BOWL, TFCBlocks.WOODEN_BOWL));
        KeyedIngredient knapping = KeyedIngredient.of(stack -> KnappingType.get(stack) != null, () -> KnappingType.MANAGER.getValues().stream().flatMap(type -> RecipeHelpers.stream(type.inputItem().ingredient())).toList());
        InteractionManager.register(knapping, Target.AIR, (ItemStack stack, UseOnContext context) -> {
            Player player = context.getPlayer();
            if (player != null && context.getClickedPos().equals((Object)BlockPos.ZERO)) {
                KnappingType type = KnappingType.get(player.getMainHandItem());
                if (type != null && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ItemStackContainerProvider provider = new ItemStackContainerProvider((stack1, hand, slot, playerInventory, windowId) -> KnappingContainer.create(stack1, type, hand, slot, playerInventory, windowId), (Component)Component.translatable((String)"tfc.screen.knapping"));
                    provider.openScreen(serverPlayer, context.getHand(), buffer -> buffer.writeResourceLocation(KnappingType.MANAGER.getIdOrThrow(type)));
                }
                return InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide);
            }
            return InteractionResult.PASS;
        });
        BlockItemPlacement ingotPilePlacement = new BlockItemPlacement((ItemLike)Items.AIR, TFCBlocks.INGOT_PILE);
        BlockItemPlacement doubleIngotPilePlacement = new BlockItemPlacement((ItemLike)Items.AIR, TFCBlocks.DOUBLE_INGOT_PILE);
        InteractionManager.registerBlock(Ingredient.of((TagKey)Tags.Items.INGOTS), (ItemStack stack, UseOnContext context) -> InteractionManager.doIngotPiling(ingotPilePlacement, stack, context, (IngotPileBlock)TFCBlocks.INGOT_PILE.get(), IngotPileBlock.COUNT, 64));
        InteractionManager.registerBlock(Ingredient.of(TFCTags.Items.DOUBLE_INGOTS), (ItemStack stack, UseOnContext context) -> InteractionManager.doIngotPiling(doubleIngotPilePlacement, stack, context, (IngotPileBlock)TFCBlocks.DOUBLE_INGOT_PILE.get(), DoubleIngotPileBlock.DOUBLE_COUNT, 36));
        InteractionManager.registerBlock(Ingredient.of(TFCTags.Items.USABLE_IN_MOLD_TABLE), (ItemStack stack, UseOnContext context) -> {
            BlockPos posClicked;
            Level level;
            Optional moldTable;
            Player player = context.getPlayer();
            if (player != null && player.mayBuild() && !player.isShiftKeyDown() && (moldTable = (level = context.getLevel()).getBlockEntity(posClicked = context.getClickedPos(), (BlockEntityType)TFCBlockEntities.MOLD_TABLE.get())).isPresent()) {
                ((MoldTableBlockEntity)moldTable.get()).onRightClick(player);
                return InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide);
            }
            return InteractionResult.PASS;
        });
        InteractionManager.register(Ingredient.of(TFCTags.Items.SALAD_BOWLS), Target.BOTH, (ItemStack stack, UseOnContext context) -> {
            if (context.getPlayer() != null && context.getPlayer().isShiftKeyDown()) {
                Player patt0$temp = context.getPlayer();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    player.openMenu(TFCContainerProviders.SALAD);
                }
                return InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide);
            }
            return InteractionResult.PASS;
        });
        InteractionManager.register(Ingredient.of((ItemLike[])new ItemLike[]{Items.EGG}), Target.BOTH, (ItemStack stack, UseOnContext context) -> {
            if (!TFCConfig.SERVER.enableVanillaEggThrowing.get().booleanValue()) {
                return InteractionResult.FAIL;
            }
            return InteractionResult.PASS;
        });
        InteractionManager.register(ItemAbilities.FIRESTARTER_LIGHT, Target.BLOCKS, (ItemStack stack, UseOnContext context) -> {
            Player player = context.getPlayer();
            if (StartFireEvent.startFireWithSound(context.getLevel(), context.getClickedPos(), context.getLevel().getBlockState(context.getClickedPos()), context.getClickedFace(), player, stack)) {
                if (player != null && !player.isCreative()) {
                    stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
                }
                return InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide);
            }
            return InteractionResult.PASS;
        });
        InteractionManager.register(ItemAbilities.SHOVEL_DOUSE, Target.BLOCKS, (ItemStack stack, UseOnContext context) -> {
            Player player = context.getPlayer();
            if (DouseFireEvent.douse(context.getLevel(), context.getClickedPos(), player)) {
                if (player != null && !player.isCreative()) {
                    stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
                }
                return InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide);
            }
            return InteractionResult.PASS;
        });
    }

    @NotNull
    private static InteractionResult doIngotPiling(BlockItemPlacement ingotPilePlacement, ItemStack stack, UseOnContext context, IngotPileBlock pileBlock, IntegerProperty countProperty, int maxIngots) {
        Player player = context.getPlayer();
        if (player != null && player.mayBuild() && player.isShiftKeyDown()) {
            BlockPos posClicked;
            Level level = context.getLevel();
            BlockState stateClicked = level.getBlockState(posClicked = context.getClickedPos());
            if (Helpers.isBlock(stateClicked, pileBlock)) {
                BlockState topState;
                int currentIngots = (Integer)stateClicked.getValue((Property)countProperty);
                if (currentIngots < maxIngots) {
                    ItemStack insertStack = stack.split(1);
                    Helpers.playPlaceSound(player, (LevelAccessor)level, posClicked, stateClicked);
                    level.setBlock(posClicked, (BlockState)stateClicked.setValue((Property)countProperty, (Comparable)Integer.valueOf(currentIngots + 1)), 2);
                    level.getBlockEntity(posClicked, (BlockEntityType)TFCBlockEntities.INGOT_PILE.get()).ifPresent(pile -> pile.addIngot(insertStack));
                    return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
                BlockPos topPos = posClicked;
                while (Helpers.isBlock(topState = level.getBlockState(topPos = topPos.above()), pileBlock) && (Integer)topState.getValue((Property)countProperty) == maxIngots) {
                }
                if (Helpers.isBlock(topState, pileBlock)) {
                    ItemStack insertStack = stack.split(1);
                    int topIngots = (Integer)topState.getValue((Property)countProperty);
                    Helpers.playPlaceSound(player, (LevelAccessor)level, topPos, topState);
                    level.setBlock(topPos, (BlockState)topState.setValue((Property)countProperty, (Comparable)Integer.valueOf(topIngots + 1)), 2);
                    level.getBlockEntity(topPos, (BlockEntityType)TFCBlockEntities.INGOT_PILE.get()).ifPresent(topPile -> topPile.addIngot(insertStack));
                    return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
                if (topState.isAir()) {
                    ItemStack stackBefore = stack.copy();
                    BlockPos topOfIngotPilePos = topPos.below();
                    UseOnContext topOfIngotPileContext = new UseOnContext(player, context.getHand(), new BlockHitResult(Vec3.ZERO, Direction.UP, topOfIngotPilePos, false));
                    InteractionResult result = ingotPilePlacement.onItemUse(stack, topOfIngotPileContext);
                    if (result.consumesAction()) {
                        stackBefore.setCount(1);
                        level.getBlockEntity(topPos, (BlockEntityType)TFCBlockEntities.INGOT_PILE.get()).ifPresent(topPile -> topPile.addIngot(stackBefore));
                    }
                    return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
                return InteractionResult.FAIL;
            }
            ItemStack stackBefore = stack.copyWithCount(1);
            BlockPos actualPlacedPos = new BlockPlaceContext(context).getClickedPos();
            InteractionResult result = ingotPilePlacement.onItemUse(stack, context);
            if (result.consumesAction()) {
                level.getBlockEntity(actualPlacedPos, (BlockEntityType)TFCBlockEntities.INGOT_PILE.get()).ifPresent(pile -> pile.addIngot(stackBefore));
            }
            return result;
        }
        return InteractionResult.PASS;
    }

    public static Optional<InteractionResult> onItemUse(ItemStack stack, UseOnContext context, boolean isTargetingAir) {
        if (!ACTIVE.get().booleanValue()) {
            for (CachedEntry cachedEntry : CACHE.getAll(stack.getItem())) {
                if (!cachedEntry.target.isTarget(isTargetingAir) || !cachedEntry.input.test(stack)) continue;
                InteractionResult result = InteractionManager.onItemUseWith(cachedEntry.action, stack, context);
                return result == InteractionResult.PASS ? Optional.empty() : Optional.of(result);
            }
            for (FallbackEntry fallbackEntry : FALLBACKS) {
                if (!fallbackEntry.target.isTarget(isTargetingAir) || !stack.canPerformAction(fallbackEntry.ability)) continue;
                InteractionResult result = InteractionManager.onItemUseWith(fallbackEntry.action, stack, context);
                return result == InteractionResult.PASS ? Optional.empty() : Optional.of(result);
            }
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InteractionResult onItemUseWith(OnItemUseAction action, ItemStack stack, UseOnContext context) {
        InteractionResult result;
        ACTIVE.set(true);
        try {
            result = action.onItemUse(stack, context);
        }
        finally {
            ACTIVE.set(false);
        }
        return result;
    }

    public static enum Target {
        AIR,
        BLOCKS,
        BOTH;


        public boolean isTarget(boolean isTargetingAir) {
            return this != (isTargetingAir ? BLOCKS : AIR);
        }
    }

    @FunctionalInterface
    public static interface OnItemUseAction {
        public InteractionResult onItemUse(ItemStack var1, UseOnContext var2);
    }

    record CachedEntry(KeyedIngredient input, Target target, OnItemUseAction action) {
    }

    record FallbackEntry(ItemAbility ability, Target target, OnItemUseAction action) {
    }
}

