/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import java.util.Locale;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.common.LevelTier;
import net.dries007.tfc.common.TFCArmorMaterials;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.TFCTiers;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.GrateBlock;
import net.dries007.tfc.common.blocks.IWeatheringBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.TFCChainBlock;
import net.dries007.tfc.common.blocks.WeatheringBlock;
import net.dries007.tfc.common.blocks.WeatheringGrateBlock;
import net.dries007.tfc.common.blocks.WeatheringSlabBlock;
import net.dries007.tfc.common.blocks.WeatheringStairBlock;
import net.dries007.tfc.common.blocks.devices.AnvilBlock;
import net.dries007.tfc.common.blocks.devices.LampBlock;
import net.dries007.tfc.common.items.ChiselItem;
import net.dries007.tfc.common.items.HammerItem;
import net.dries007.tfc.common.items.JavelinItem;
import net.dries007.tfc.common.items.LampBlockItem;
import net.dries007.tfc.common.items.PropickItem;
import net.dries007.tfc.common.items.ScytheItem;
import net.dries007.tfc.common.items.TFCFishingRodItem;
import net.dries007.tfc.common.items.TFCHoeItem;
import net.dries007.tfc.common.items.TFCMaceItem;
import net.dries007.tfc.common.items.TFCShieldItem;
import net.dries007.tfc.common.items.ToolItem;
import net.dries007.tfc.util.registry.RegistryMetal;
import net.minecraft.core.Holder;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.AnimalArmorItem;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;

public enum Metal implements StringRepresentable,
RegistryMetal
{
    BISMUTH(-12031118, MapColor.TERRACOTTA_GREEN, Rarity.COMMON, -1.0f, PartType.DEFAULT),
    BISMUTH_BRONZE(-12480945, MapColor.TERRACOTTA_BLUE, Rarity.COMMON, -1.0f, TFCTiers.BISMUTH_BRONZE, TFCArmorMaterials.BISMUTH_BRONZE),
    BLACK_BRONZE(-12900810, MapColor.TERRACOTTA_PINK, Rarity.COMMON, -1.0f, TFCTiers.BLACK_BRONZE, TFCArmorMaterials.BLACK_BRONZE),
    BRONZE(-6911698, MapColor.TERRACOTTA_ORANGE, Rarity.COMMON, 0.7f, TFCTiers.BRONZE, TFCArmorMaterials.BRONZE),
    BRASS(-8626637, MapColor.GOLD, Rarity.COMMON, 0.7f, PartType.DEFAULT_WEATHERING),
    COPPER(-4833241, MapColor.COLOR_ORANGE, Rarity.COMMON, 0.0f, TFCTiers.COPPER, TFCArmorMaterials.COPPER),
    GOLD(-2310373, MapColor.GOLD, Rarity.COMMON, -1.0f, PartType.DEFAULT),
    NICKEL(-11645380, MapColor.STONE, Rarity.COMMON, -1.0f, PartType.DEFAULT),
    ROSE_GOLD(-1347273, MapColor.COLOR_PINK, Rarity.COMMON, -1.0f, PartType.DEFAULT),
    SILVER(-7039851, MapColor.COLOR_LIGHT_GRAY, Rarity.COMMON, 0.95f, PartType.DEFAULT_WEATHERING),
    TIN(-7297861, MapColor.COLOR_LIGHT_GRAY, Rarity.COMMON, -1.0f, PartType.DEFAULT),
    ZINC(-4474428, MapColor.COLOR_LIGHT_GRAY, Rarity.COMMON, -1.0f, PartType.DEFAULT),
    STERLING_SILVER(-5467525, MapColor.COLOR_LIGHT_GRAY, Rarity.COMMON, 0.95f, PartType.DEFAULT_WEATHERING),
    WROUGHT_IRON(-6776681, MapColor.METAL, Rarity.COMMON, 0.0f, TFCTiers.WROUGHT_IRON, TFCArmorMaterials.WROUGHT_IRON),
    CAST_IRON(-6776681, MapColor.COLOR_BROWN, Rarity.COMMON, -1.0f, PartType.DEFAULT),
    PIG_IRON(-9807524, MapColor.COLOR_GRAY, Rarity.COMMON, -1.0f, PartType.INGOT),
    STEEL(-10526881, MapColor.COLOR_LIGHT_GRAY, Rarity.UNCOMMON, 0.9f, TFCTiers.STEEL, TFCArmorMaterials.STEEL),
    BLACK_STEEL(-15658735, MapColor.COLOR_BLACK, Rarity.RARE, -1.0f, TFCTiers.BLACK_STEEL, TFCArmorMaterials.BLACK_STEEL),
    BLUE_STEEL(-13806186, MapColor.COLOR_BLUE, Rarity.EPIC, -1.0f, TFCTiers.BLUE_STEEL, TFCArmorMaterials.BLUE_STEEL),
    RED_STEEL(-9435901, MapColor.COLOR_RED, Rarity.EPIC, -1.0f, TFCTiers.RED_STEEL, TFCArmorMaterials.RED_STEEL),
    WEAK_STEEL(-15658735, MapColor.COLOR_GRAY, Rarity.COMMON, -1.0f, PartType.INGOT),
    WEAK_BLUE_STEEL(-13806186, MapColor.COLOR_BLUE, Rarity.COMMON, -1.0f, PartType.INGOT),
    WEAK_RED_STEEL(-9435901, MapColor.COLOR_RED, Rarity.COMMON, -1.0f, PartType.INGOT),
    HIGH_CARBON_STEEL(-10526881, MapColor.COLOR_GRAY, Rarity.COMMON, -1.0f, PartType.INGOT),
    HIGH_CARBON_BLACK_STEEL(-15658735, MapColor.COLOR_BLACK, Rarity.COMMON, -1.0f, PartType.INGOT),
    HIGH_CARBON_BLUE_STEEL(-13806186, MapColor.COLOR_BLUE, Rarity.COMMON, -1.0f, PartType.INGOT),
    HIGH_CARBON_RED_STEEL(-9435901, MapColor.COLOR_RED, Rarity.COMMON, -1.0f, PartType.INGOT),
    UNKNOWN(-13685977, MapColor.COLOR_BLACK, Rarity.COMMON, -1.0f, PartType.INGOT);

    private final String serializedName = this.name().toLowerCase(Locale.ROOT);
    private final PartType partType;
    @Nullable
    private final LevelTier toolTier;
    @Nullable
    private final TFCArmorMaterials.Id armorMaterial;
    private final MapColor mapColor;
    private final Rarity rarity;
    private final int color;
    private final float weathering;

    private Metal(int color, MapColor mapColor, Rarity rarity, float weathering, PartType partType) {
        this(color, mapColor, rarity, weathering, partType, null, null);
    }

    private Metal(int color, MapColor mapColor, Rarity rarity, float weathering, LevelTier toolTier, TFCArmorMaterials.Id armorTier) {
        this(color, mapColor, rarity, weathering, weathering == -1.0f ? PartType.ALL : PartType.ALL_WEATHERING, toolTier, armorTier);
    }

    private Metal(int color, MapColor mapColor, Rarity rarity, @Nullable float weathering, @Nullable PartType partType, LevelTier toolTier, TFCArmorMaterials.Id armorTier) {
        this.toolTier = toolTier;
        this.armorMaterial = armorTier;
        this.rarity = rarity;
        this.mapColor = mapColor;
        this.color = color;
        this.partType = partType;
        this.weathering = weathering;
    }

    public String getSerializedName() {
        return this.serializedName;
    }

    public int getColor() {
        return this.color;
    }

    @Override
    public Rarity rarity() {
        return this.rarity;
    }

    @Override
    public float weatheringResistance() {
        return this.weathering;
    }

    public boolean defaultParts() {
        return this.partType != PartType.INGOT;
    }

    public boolean allParts() {
        return this.partType == PartType.ALL || this.partType == PartType.ALL_WEATHERING;
    }

    @Override
    public LevelTier toolTier() {
        return Objects.requireNonNull(this.toolTier, "Tried to get non-existent tier from " + this.name());
    }

    @Override
    public Holder<ArmorMaterial> armorMaterial() {
        return Objects.requireNonNull(this.armorMaterial).holder();
    }

    @Override
    public int armorDurability(ArmorItem.Type type) {
        Objects.requireNonNull(this.armorMaterial);
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ArmorItem.Type.HELMET -> this.armorMaterial.headDamage();
            case ArmorItem.Type.BODY, ArmorItem.Type.CHESTPLATE -> this.armorMaterial.chestDamage();
            case ArmorItem.Type.LEGGINGS -> this.armorMaterial.legDamage();
            case ArmorItem.Type.BOOTS -> this.armorMaterial.feetDamage();
        };
    }

    @Override
    public MapColor mapColor() {
        return this.mapColor;
    }

    @Override
    public Block getBlock(BlockType type) {
        return (Block)TFCBlocks.METALS.get(this).get((Object)type).get();
    }

    public int tier() {
        return this.toolTier != null ? this.toolTier.level() : 0;
    }

    static enum PartType {
        INGOT,
        DEFAULT,
        DEFAULT_WEATHERING,
        ALL,
        ALL_WEATHERING,
        WEATHERED,
        ALL_WEATHERED;


        boolean hasMetal(PartType metal) {
            return switch (this.ordinal()) {
                case 5 -> {
                    if (metal == DEFAULT_WEATHERING || metal == ALL_WEATHERING) {
                        yield true;
                    }
                    yield false;
                }
                case 6 -> {
                    if (metal == ALL_WEATHERING) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> {
                    if (metal.ordinal() >= ALL.ordinal()) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> {
                    if (metal.ordinal() >= DEFAULT.ordinal()) {
                        yield true;
                    }
                    yield false;
                }
                case 0 -> true;
                default -> throw new AssertionError((Object)("Invalid choice for a metal type " + String.valueOf((Object)this)));
            };
        }
    }

    public static enum ItemType {
        INGOT(PartType.INGOT, true),
        DOUBLE_INGOT(PartType.DEFAULT, false),
        SHEET(PartType.DEFAULT, false),
        DOUBLE_SHEET(PartType.DEFAULT, false),
        ROD(PartType.DEFAULT, false),
        TUYERE(PartType.ALL, metal -> new TieredItem((Tier)metal.toolTier(), ItemType.base(metal))),
        FISH_HOOK(PartType.ALL, false),
        FISHING_ROD(PartType.ALL, metal -> new TFCFishingRodItem(ItemType.base(metal).durability(metal.toolTier().getUses()), metal.toolTier())),
        UNFINISHED_LAMP(PartType.ALL, metal -> new Item(ItemType.base(metal))),
        PICKAXE(PartType.ALL, metal -> new PickaxeItem((Tier)metal.toolTier(), ItemType.tool(metal, 0.75f, -2.8f))),
        PICKAXE_HEAD(PartType.ALL, true),
        PROPICK(PartType.ALL, metal -> new PropickItem(metal.toolTier(), ItemType.tool(metal, 0.5f, -2.8f))),
        PROPICK_HEAD(PartType.ALL, true),
        AXE(PartType.ALL, metal -> new AxeItem((Tier)metal.toolTier(), ItemType.tool(metal, 1.5f, -3.1f))),
        AXE_HEAD(PartType.ALL, true),
        SHOVEL(PartType.ALL, metal -> new ShovelItem((Tier)metal.toolTier(), ItemType.tool(metal, 0.875f, -3.0f))),
        SHOVEL_HEAD(PartType.ALL, true),
        HOE(PartType.ALL, metal -> new TFCHoeItem(metal.toolTier(), ItemType.tool(metal, 0.5f, -2.0f))),
        HOE_HEAD(PartType.ALL, true),
        CHISEL(PartType.ALL, metal -> new ChiselItem(metal.toolTier(), ItemType.tool(metal, 0.27f, 1.5f))),
        CHISEL_HEAD(PartType.ALL, true),
        HAMMER(PartType.ALL, metal -> new HammerItem(metal.toolTier(), ItemType.tool(metal, 1.0f, -3.0f))),
        HAMMER_HEAD(PartType.ALL, true),
        SAW(PartType.ALL, metal -> new AxeItem((Tier)metal.toolTier(), ItemType.tool(metal, 0.5f, -3.0f))),
        SAW_BLADE(PartType.ALL, true),
        JAVELIN(PartType.ALL, metal -> new JavelinItem(metal.toolTier(), ItemType.tool(metal, 0.7f, -2.6f))),
        JAVELIN_HEAD(PartType.ALL, true),
        SWORD(PartType.ALL, metal -> new SwordItem((Tier)metal.toolTier(), ItemType.tool(metal, 1.0f, -2.4f))),
        SWORD_BLADE(PartType.ALL, true),
        MACE(PartType.ALL, metal -> new TFCMaceItem(ItemType.tool(metal, 1.3f, -3.4f).durability(metal.toolTier().getUses()))),
        MACE_HEAD(PartType.ALL, true),
        KNIFE(PartType.ALL, metal -> new ToolItem(metal.toolTier(), TFCTags.Blocks.MINEABLE_WITH_KNIFE, ItemType.tool(metal, 0.6f, -2.0f))),
        KNIFE_BLADE(PartType.ALL, true),
        SCYTHE(PartType.ALL, metal -> new ScytheItem(metal.toolTier(), ItemType.tool(metal, 0.7f, -3.2f))),
        SCYTHE_BLADE(PartType.ALL, true),
        SHEARS(PartType.ALL, metal -> new ShearsItem(ItemType.base(metal).durability(metal.toolTier().getUses()))),
        UNFINISHED_HELMET(PartType.ALL, false),
        HELMET(PartType.ALL, ItemType.armor(ArmorItem.Type.HELMET)),
        UNFINISHED_CHESTPLATE(PartType.ALL, false),
        CHESTPLATE(PartType.ALL, ItemType.armor(ArmorItem.Type.CHESTPLATE)),
        UNFINISHED_GREAVES(PartType.ALL, false),
        GREAVES(PartType.ALL, ItemType.armor(ArmorItem.Type.LEGGINGS)),
        UNFINISHED_BOOTS(PartType.ALL, false),
        BOOTS(PartType.ALL, ItemType.armor(ArmorItem.Type.BOOTS)),
        HORSE_ARMOR(PartType.ALL, metal -> new AnimalArmorItem(metal.armorMaterial(), AnimalArmorItem.BodyType.EQUESTRIAN, false, ItemType.base(metal).durability(metal.armorDurability(ArmorItem.Type.BODY)))),
        SHIELD(PartType.ALL, metal -> new TFCShieldItem(metal.toolTier(), ItemType.base(metal)));

        private final Function<RegistryMetal, Item> itemFactory;
        private final PartType type;
        private final boolean mold;

        private static Item.Properties base(RegistryMetal metal) {
            return new Item.Properties().rarity(metal.rarity());
        }

        private static Item.Properties tool(RegistryMetal metal, float attackDamageFactor, float attackSpeed) {
            return ItemType.base(metal).attributes(ToolItem.productAttributes(metal.toolTier(), attackDamageFactor, attackSpeed));
        }

        private static Function<RegistryMetal, Item> armor(ArmorItem.Type type) {
            return metal -> new ArmorItem(metal.armorMaterial(), type, ItemType.base(metal).durability(metal.armorDurability(type)));
        }

        private ItemType(PartType type, boolean mold) {
            this(type, mold, metal -> new Item(ItemType.base(metal)));
        }

        private ItemType(PartType type, Function<RegistryMetal, Item> itemFactory) {
            this(type, false, itemFactory);
        }

        private ItemType(PartType type, boolean mold, Function<RegistryMetal, Item> itemFactory) {
            this.type = type;
            this.mold = mold;
            this.itemFactory = itemFactory;
        }

        public Item create(RegistryMetal metal) {
            return this.itemFactory.apply(metal);
        }

        public boolean has(Metal metal) {
            return this.type.hasMetal(metal.partType);
        }

        public boolean hasMold() {
            return this.mold;
        }

        public boolean isCommonTagPart() {
            return this.type == PartType.INGOT || this.type == PartType.DEFAULT;
        }
    }

    public static enum BlockType {
        BLOCK(PartType.DEFAULT, BlockType.block(IWeatheringBlock.Age.NONE)),
        EXPOSED_BLOCK(PartType.WEATHERED, BlockType.block(IWeatheringBlock.Age.EXPOSED)),
        WEATHERED_BLOCK(PartType.WEATHERED, BlockType.block(IWeatheringBlock.Age.WEATHERED)),
        OXIDIZED_BLOCK(PartType.WEATHERED, BlockType.block(IWeatheringBlock.Age.OXIDIZED)),
        BLOCK_SLAB(PartType.DEFAULT, BlockType.slab(IWeatheringBlock.Age.NONE)),
        EXPOSED_BLOCK_SLAB(PartType.WEATHERED, BlockType.slab(IWeatheringBlock.Age.EXPOSED)),
        WEATHERED_BLOCK_SLAB(PartType.WEATHERED, BlockType.slab(IWeatheringBlock.Age.WEATHERED)),
        OXIDIZED_BLOCK_SLAB(PartType.WEATHERED, BlockType.slab(IWeatheringBlock.Age.OXIDIZED)),
        BLOCK_STAIRS(PartType.DEFAULT, BlockType.stairs(BLOCK, IWeatheringBlock.Age.NONE)),
        EXPOSED_BLOCK_STAIRS(PartType.WEATHERED, BlockType.stairs(EXPOSED_BLOCK, IWeatheringBlock.Age.EXPOSED)),
        WEATHERED_BLOCK_STAIRS(PartType.WEATHERED, BlockType.stairs(WEATHERED_BLOCK, IWeatheringBlock.Age.WEATHERED)),
        OXIDIZED_BLOCK_STAIRS(PartType.WEATHERED, BlockType.stairs(OXIDIZED_BLOCK, IWeatheringBlock.Age.OXIDIZED)),
        GRATE(PartType.ALL, BlockType.grate(IWeatheringBlock.Age.NONE)),
        EXPOSED_GRATE(PartType.ALL_WEATHERED, BlockType.grate(IWeatheringBlock.Age.EXPOSED)),
        WEATHERED_GRATE(PartType.ALL_WEATHERED, BlockType.grate(IWeatheringBlock.Age.WEATHERED)),
        OXIDIZED_GRATE(PartType.ALL_WEATHERED, BlockType.grate(IWeatheringBlock.Age.OXIDIZED)),
        ANVIL(PartType.ALL, metal -> new AnvilBlock(ExtendedProperties.of().mapColor(metal.mapColor()).noOcclusion().sound(SoundType.ANVIL).strength(10.0f, 10.0f).requiresCorrectToolForDrops().blockEntity(TFCBlockEntities.ANVIL), metal.toolTier().level())),
        BARS(PartType.ALL, metal -> new IronBarsBlock(BlockBehaviour.Properties.of().mapColor(metal.mapColor()).requiresCorrectToolForDrops().strength(6.0f, 7.0f).sound(SoundType.METAL).noOcclusion())),
        CHAIN(PartType.ALL, metal -> new TFCChainBlock(BlockBehaviour.Properties.of().mapColor(metal.mapColor()).requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundType.CHAIN).lightLevel(TFCBlocks.lavaLoggedBlockEmission()))),
        LAMP(PartType.ALL, metal -> new LampBlock(ExtendedProperties.of().mapColor(metal.mapColor()).noOcclusion().sound(SoundType.LANTERN).strength(4.0f, 10.0f).randomTicks().pushReaction(PushReaction.DESTROY).lightLevel(state -> (Boolean)state.getValue((Property)LampBlock.LIT) != false ? 15 : 0).blockEntity(TFCBlockEntities.LAMP)), (block, properties) -> new LampBlockItem((Block)block, properties.stacksTo(1))),
        TRAPDOOR(PartType.ALL, metal -> new TrapDoorBlock(BlockSetType.IRON, BlockBehaviour.Properties.of().mapColor(metal.mapColor()).requiresCorrectToolForDrops().strength(5.0f).sound(SoundType.METAL).noOcclusion().isValidSpawn(TFCBlocks::neverEntity)));

        private final Function<RegistryMetal, Block> blockFactory;
        private final BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory;
        private final PartType type;
        private final String serializedName;

        private static Function<RegistryMetal, Block> grate(IWeatheringBlock.Age age) {
            return metal -> {
                BlockBehaviour.Properties prop = BlockType.blockProperties(metal).noOcclusion().sound(SoundType.COPPER_GRATE).noOcclusion().isValidSpawn(TFCBlocks::neverEntity).isRedstoneConductor(TFCBlocks::never).isSuffocating(TFCBlocks::never).isViewBlocking(TFCBlocks::never).lightLevel(TFCBlocks.lavaLoggedBlockEmission());
                return metal.weatheredParts() ? new WeatheringGrateBlock(prop, age, metal.weatheringResistance()) : new GrateBlock(prop);
            };
        }

        private static Function<RegistryMetal, Block> block(IWeatheringBlock.Age age) {
            return metal -> metal.weatheredParts() ? new WeatheringBlock(BlockType.blockProperties(metal), age, metal.weatheringResistance()) : new Block(BlockType.blockProperties(metal));
        }

        private static Function<RegistryMetal, Block> slab(IWeatheringBlock.Age age) {
            return metal -> metal.weatheredParts() ? new WeatheringSlabBlock(BlockType.blockProperties(metal), age, metal.weatheringResistance()) : new SlabBlock(BlockType.blockProperties(metal));
        }

        private static Function<RegistryMetal, Block> stairs(BlockType block, IWeatheringBlock.Age age) {
            return metal -> metal.weatheredParts() ? new WeatheringStairBlock(metal.getBlock(block).defaultBlockState(), BlockType.blockProperties(metal), age, metal.weatheringResistance()) : new StairBlock(metal.getBlock(block).defaultBlockState(), BlockType.blockProperties(metal));
        }

        private static BlockBehaviour.Properties blockProperties(RegistryMetal metal) {
            return BlockBehaviour.Properties.of().mapColor(metal.mapColor()).instrument(NoteBlockInstrument.IRON_XYLOPHONE).requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundType.METAL);
        }

        private BlockType(PartType type, Function<RegistryMetal, Block> blockFactory, BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory) {
            this.type = type;
            this.blockFactory = blockFactory;
            this.blockItemFactory = blockItemFactory;
            this.serializedName = this.name().toLowerCase(Locale.ROOT);
        }

        private BlockType(PartType type, Function<RegistryMetal, Block> blockFactory) {
            this(type, blockFactory, BlockItem::new);
        }

        public Supplier<Block> create(RegistryMetal metal) {
            return () -> this.blockFactory.apply(metal);
        }

        public Function<Block, BlockItem> createBlockItem(Item.Properties properties) {
            return block -> this.blockItemFactory.apply((Block)block, properties);
        }

        public boolean has(Metal metal) {
            return this.type.hasMetal(metal.partType);
        }

        public String createName(RegistryMetal metal) {
            String slab = "_slab";
            if (this.serializedName.contains(slab)) {
                return "metal/" + this.serializedName.split(slab)[0] + "/" + metal.getSerializedName() + slab;
            }
            String stairs = "_stairs";
            if (this.serializedName.contains(stairs)) {
                return "metal/" + this.serializedName.split(stairs)[0] + "/" + metal.getSerializedName() + stairs;
            }
            return "metal/" + this.serializedName + "/" + metal.getSerializedName();
        }
    }
}

