/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import org.slf4j.Logger;

public record MetalItem(String name, ResourceLocation textureId, ResourceLocation softTextureId) {
    private static final MetalPartCache CACHE = IndirectHashCollection.create(new MetalPartCache(new IdentityHashMap<Item, MetalItem>()));
    private static final MetalItem UNKNOWN = new MetalItem("unknown");
    private static final Logger LOGGER = LogUtils.getLogger();

    public MetalItem(String name) {
        this(name, Helpers.identifier(name).withPrefix("block/metal/block/"), Helpers.identifier(name).withPrefix("block/metal/smooth/"));
    }

    public static void init() {
    }

    public static MetalItem unknown() {
        return UNKNOWN;
    }

    public static MetalItem getOrUnknown(ItemStack stack) {
        return MetalItem.CACHE.values.getOrDefault(stack.getItem(), UNKNOWN);
    }

    record MetalPartCache(Map<Item, MetalItem> values) implements IndirectHashCollection.Cache
    {
        @Override
        public void clear() {
            this.values.clear();
        }

        @Override
        public void reload(RecipeManager manager) {
            HashMap instances = new HashMap();
            Set excludedTags = Set.copyOf((Collection)TFCConfig.SERVER.excludedMetalTagNames.get());
            this.values.clear();
            BuiltInRegistries.ITEM.getTags().forEach(pair -> {
                String[] path;
                ResourceLocation id = ((TagKey)pair.getFirst()).location();
                if (id.getNamespace().equals("c") && (path = id.getPath().split("/")).length == 2 && (path[0].equals("ingots") || path[0].equals("double_ingots")) && !path[1].contains("/") && !excludedTags.contains(id.getPath())) {
                    String metalName = path[1];
                    MetalItem metal = instances.computeIfAbsent(metalName, key -> new MetalItem(metalName));
                    ((HolderSet.Named)pair.getSecond()).forEach(holder -> this.values.compute((Item)holder.value(), (key, old) -> {
                        if (old != null) {
                            LOGGER.warn("Item {} was inferred to match multiple metals {} and {}, using former", new Object[]{key, old.name, metalName});
                            return old;
                        }
                        return metal;
                    }));
                }
            });
        }
    }
}

