/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.calendar;

import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.calendar.CalendarTransaction;
import net.dries007.tfc.util.calendar.ICalendar;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import org.slf4j.Logger;

public class Calendar
implements ICalendar {
    public static final int DEFAULT_MONTH_LENGTH = 8;
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final StreamCodec<ByteBuf, Calendar> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, c -> c.daysInMonth, (StreamCodec)ByteBufCodecs.VAR_LONG, c -> c.playerTicks, (StreamCodec)ByteBufCodecs.VAR_LONG, c -> c.calendarTicks, (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.calendarTickRate), (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.calendarPartialTick), (StreamCodec)ByteBufCodecs.BOOL, c -> c.arePlayersLoggedOn, Calendar::new);
    protected long playerTicks;
    protected long calendarTicks;
    protected int daysInMonth;
    protected float calendarTickRate;
    protected float calendarPartialTick;
    protected boolean arePlayersLoggedOn;

    public Calendar() {
        this.resetToDefault();
    }

    private Calendar(int daysInMonth, long playerTicks, long calendarTicks, float calendarTickRate, float calendarPartialTick, boolean arePlayersLoggedOn) {
        this.daysInMonth = daysInMonth;
        this.playerTicks = playerTicks;
        this.calendarTicks = calendarTicks;
        this.calendarTickRate = calendarTickRate;
        this.calendarPartialTick = calendarPartialTick;
        this.arePlayersLoggedOn = arePlayersLoggedOn;
    }

    @Override
    public CalendarTransaction transaction() {
        return new Transaction();
    }

    @Override
    public long getTicks() {
        return this.playerTicks;
    }

    @Override
    public long getCalendarTicks() {
        return this.calendarTicks;
    }

    @Override
    public int getCalendarDaysInMonth() {
        return this.daysInMonth;
    }

    @Override
    public long getCalendarTickFromOffset(long offsetTick) {
        return this.calendarTicks + (long)((double)this.calendarPartialTick + (double)this.calendarTickRate * (double)offsetTick);
    }

    @Override
    public long getFixedCalendarTicksFromTick(long playerTick) {
        return (long)((double)this.calendarTickRate * (double)playerTick);
    }

    public CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt("daysInMonth", this.daysInMonth);
        nbt.putLong("playerTime", this.playerTicks);
        nbt.putLong("calendarTime", this.calendarTicks);
        nbt.putFloat("calendarTickRate", this.calendarTickRate);
        nbt.putFloat("calendarPartialTick", this.calendarPartialTick);
        nbt.putBoolean("arePlayersLoggedOn", this.arePlayersLoggedOn);
        return nbt;
    }

    public void read(CompoundTag nbt) {
        this.daysInMonth = nbt.getInt("daysInMonth");
        this.playerTicks = nbt.getLong("playerTime");
        this.calendarTicks = nbt.getLong("calendarTime");
        this.calendarTickRate = nbt.getFloat("calendarTickRate");
        this.calendarPartialTick = nbt.getFloat("calendarPartialTick");
        this.arePlayersLoggedOn = nbt.getBoolean("arePlayersLoggedOn");
    }

    public void resetTo(Calendar other) {
        this.daysInMonth = other.daysInMonth;
        this.playerTicks = other.playerTicks;
        this.calendarTicks = other.calendarTicks;
        this.calendarTickRate = other.calendarTickRate;
        this.calendarPartialTick = other.calendarPartialTick;
        this.arePlayersLoggedOn = other.arePlayersLoggedOn;
    }

    public void resetToDefault() {
        this.daysInMonth = TFCConfig.COMMON.defaultMonthLength.get();
        this.playerTicks = 0L;
        this.calendarTicks = (long)TFCConfig.COMMON.defaultCalendarStartDay.get().intValue() * 24000L + 6000L;
        this.calendarTickRate = 20.0f / (float)TFCConfig.COMMON.defaultCalendarDayLength.get().intValue();
        this.calendarPartialTick = 0.0f;
        this.arePlayersLoggedOn = false;
    }

    protected final void advanceCalendarTick() {
        this.calendarPartialTick += this.calendarTickRate;
        this.calendarTicks += (long)Mth.floor((float)this.calendarPartialTick);
        this.calendarPartialTick = Mth.frac((float)this.calendarPartialTick);
    }

    final class Transaction
    implements CalendarTransaction {
        private final long originalPlayerTicks;

        Transaction() {
            this.originalPlayerTicks = Calendar.this.playerTicks;
        }

        @Override
        public void add(long ticks) {
            Calendar.this.playerTicks += ticks;
        }

        @Override
        public long ticks() {
            return Calendar.this.playerTicks - this.originalPlayerTicks;
        }

        @Override
        public void close() {
            Calendar.this.playerTicks = this.originalPlayerTicks;
        }
    }
}

