/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.calendar;

import com.mojang.serialization.Codec;
import java.util.Locale;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Season;
import net.minecraft.util.StringRepresentable;

public enum Month implements StringRepresentable
{
    JANUARY(-1.0f, Season.WINTER),
    FEBRUARY(-0.866f, Season.WINTER),
    MARCH(-0.5f, Season.SPRING),
    APRIL(0.0f, Season.SPRING),
    MAY(0.5f, Season.SPRING),
    JUNE(0.866f, Season.SUMMER),
    JULY(1.0f, Season.SUMMER),
    AUGUST(0.866f, Season.SUMMER),
    SEPTEMBER(0.5f, Season.FALL),
    OCTOBER(0.0f, Season.FALL),
    NOVEMBER(-0.5f, Season.FALL),
    DECEMBER(-0.866f, Season.WINTER);

    public static final Codec<Month> CODEC;
    private static final Month[] VALUES;
    private final float temperatureModifier;
    private final Season season;
    private final String serializedName;

    public static Month valueOf(int id) {
        return id >= 0 && id < VALUES.length ? VALUES[id] : JANUARY;
    }

    private Month(float temperatureModifier, Season season) {
        this.temperatureModifier = temperatureModifier;
        this.season = season;
        this.serializedName = this.name().toLowerCase(Locale.ROOT);
    }

    public float getTemperatureModifier() {
        return this.temperatureModifier;
    }

    public Month next() {
        return this == DECEMBER ? JANUARY : VALUES[this.ordinal() + 1];
    }

    public Month opposite() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> JULY;
            case 1 -> AUGUST;
            case 2 -> SEPTEMBER;
            case 3 -> OCTOBER;
            case 4 -> NOVEMBER;
            case 5 -> DECEMBER;
            case 6 -> JANUARY;
            case 7 -> FEBRUARY;
            case 8 -> MARCH;
            case 9 -> APRIL;
            case 10 -> MAY;
            case 11 -> JUNE;
        };
    }

    public String getTranslationKey(Style style) {
        return switch (style.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Helpers.getEnumTranslationKey(this);
            case 1 -> Helpers.getEnumTranslationKey(this, "season");
        };
    }

    public Season getSeason() {
        return this.season;
    }

    public String getSerializedName() {
        return this.serializedName;
    }

    static {
        CODEC = StringRepresentable.fromEnum(Month::values);
        VALUES = Month.values();
    }

    public static enum Style {
        LONG_MONTH,
        SEASON;

    }
}

