/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.climate;

import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.dries007.tfc.util.climate.ClimateModel;
import net.dries007.tfc.util.events.SelectClimateModelEvent;
import net.dries007.tfc.util.tracker.WorldTracker;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public final class Climate {
    public static ClimateModel get(Level level) {
        return WorldTracker.get(level).getClimateModel();
    }

    public static void chooseModelForWorld(ServerLevel level) {
        SelectClimateModelEvent event = new SelectClimateModelEvent(level);
        NeoForge.EVENT_BUS.post((Event)event);
        WorldTracker.get((Level)level).setClimateModel(event.getModel());
    }

    public static float getTemperature(Level level, BlockPos pos, long calendarTick, int daysInMonth) {
        return Climate.get(level).getTemperature((LevelReader)level, pos, calendarTick, daysInMonth);
    }

    public static float getTemperature(Level level, BlockPos pos, ICalendar calendar, long calendarTick) {
        return Climate.get(level).getTemperature((LevelReader)level, pos, calendarTick, calendar.getCalendarDaysInMonth());
    }

    public static float getTemperature(Level level, BlockPos pos, ICalendar calendar) {
        return Climate.get(level).getTemperature((LevelReader)level, pos, calendar.getCalendarTicks(), calendar.getCalendarDaysInMonth());
    }

    public static float getTemperature(Level level, BlockPos pos) {
        return Climate.getTemperature(level, pos, Calendars.get((LevelReader)level));
    }

    public static float getAverageTemperature(Level level, BlockPos pos) {
        return Climate.get(level).getAverageTemperature((LevelReader)level, pos);
    }

    public static float getRainfall(Level level, BlockPos pos) {
        return Climate.get(level).getAverageRainfall((LevelReader)level, pos);
    }

    public static float getRainfallVariance(Level level, BlockPos pos) {
        return Climate.get(level).getRainfallVariance((LevelReader)level, pos);
    }

    public static float getGroundwater(Level level, BlockPos pos) {
        return Climate.get(level).getAverageGroundwater((LevelReader)level, pos);
    }

    public static float fromVanilla(float vanillaTemperature) {
        return (vanillaTemperature - 0.15f) / 0.0217f;
    }
}

