/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.climate;

import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.dries007.tfc.util.climate.ClimateModelType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec2;

public interface ClimateModel {
    public static final float MIN_RAINFALL = 0.0f;
    public static final float MAX_RAINFALL = 500.0f;
    public static final int NUM_SAMPLES_FOR_DELTAS = 4;
    public static final float MAX_CROP_RAINFALL = 600.0f;
    public static final float MAX_INSTANTANEOUS_RAINFALL = 1000.0f;

    public ClimateModelType<?> type();

    default public float hemisphereScale() {
        return 20000.0f;
    }

    public float getAverageTemperature(LevelReader var1, BlockPos var2);

    default public float getTemperature(LevelReader level, BlockPos pos) {
        ICalendar calendar = Calendars.get(level);
        return this.getTemperature(level, pos, calendar.getCalendarTicks(), calendar.getCalendarDaysInMonth());
    }

    default public float getTemperature(LevelReader level, BlockPos pos, long calendarTicks, int daysInMonth) {
        return this.getAverageTemperature(level, pos);
    }

    default public float getTimeAverageTemperature(LevelReader level, BlockPos pos, long fromTick, long toTick, int daysInMonth) {
        long deltaTicks = toTick - fromTick;
        float temperatureSum = 0.0f;
        for (int i = 0; i < 4; ++i) {
            long sampleTick = fromTick + deltaTicks * (long)i / 3L;
            temperatureSum += this.getTemperature(level, pos, sampleTick, daysInMonth);
        }
        return temperatureSum / 4.0f;
    }

    public float getAverageRainfall(LevelReader var1, BlockPos var2);

    default public float getRainfallVariance(LevelReader level, BlockPos pos) {
        return 0.0f;
    }

    default public float getRainfall(LevelReader level, BlockPos pos) {
        ICalendar calendar = Calendars.get(level);
        return this.getRainfall(level, pos, calendar.getCalendarTicks(), calendar.getCalendarDaysInMonth());
    }

    default public float getRainfall(LevelReader level, BlockPos pos, long calendarTicks, int daysInMonth) {
        return this.getAverageRainfall(level, pos);
    }

    default public float getTimeAverageRainfall(LevelReader level, BlockPos pos, long fromTick, long toTick, int daysInMonth) {
        long deltaTicks = toTick - fromTick;
        float rainfallSum = 0.0f;
        for (int i = 0; i < 4; ++i) {
            long sampleTick = fromTick + deltaTicks * (long)i / 3L;
            rainfallSum += this.getRainfall(level, pos, sampleTick, daysInMonth);
        }
        return rainfallSum / 4.0f;
    }

    default public float getBaseGroundwater(LevelReader level, BlockPos pos) {
        return 0.0f;
    }

    default public float getAverageGroundwater(LevelReader level, BlockPos pos) {
        return this.getAverageRainfall(level, pos);
    }

    default public float getGroundwater(LevelReader level, BlockPos pos) {
        ICalendar calendar = Calendars.get(level);
        return this.getGroundwater(level, pos, calendar.getCalendarTicks(), calendar.getCalendarDaysInMonth());
    }

    default public float getGroundwater(LevelReader level, BlockPos pos, long calendarTicks, int daysInMonth) {
        return this.getRainfall(level, pos, calendarTicks, daysInMonth);
    }

    default public float getTimeAverageGroundwater(LevelReader level, BlockPos pos, long fromTick, long toTick, int daysInMonth) {
        long deltaTicks = toTick - fromTick;
        float groundWaterSum = 0.0f;
        for (int i = 0; i < 4; ++i) {
            long sampleTick = fromTick + deltaTicks * (long)i / 3L;
            groundWaterSum += this.getGroundwater(level, pos, sampleTick, daysInMonth);
        }
        return groundWaterSum / 4.0f;
    }

    default public float getRain(long calendarTicks) {
        return -1.0f;
    }

    default public boolean getThunder(long calendarTicks) {
        return false;
    }

    default public boolean supportsRain() {
        return false;
    }

    default public Vec2 getWind(Level level, BlockPos pos) {
        ICalendar calendar = Calendars.get((LevelReader)level);
        return this.getWind(level, pos, calendar.getCalendarTicks(), calendar.getCalendarDaysInMonth());
    }

    default public Vec2 getWind(Level level, BlockPos pos, long calendarTicks, int daysInMonth) {
        return Vec2.ZERO;
    }

    default public float getFog(LevelReader level, BlockPos pos) {
        return 0.0f;
    }
}

