/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.climate;

import java.util.Locale;
import java.util.Map;
import net.dries007.tfc.common.blocks.crop.Crop;
import net.dries007.tfc.common.blocks.plant.fruit.FruitBlocks;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.ClimateRange;
import net.dries007.tfc.util.data.DataManager;

public final class ClimateRanges {
    public static final DataManager.Reference<ClimateRange> BANANA_PLANT = ClimateRanges.register("plant/banana_tree");
    public static final DataManager.Reference<ClimateRange> CRANBERRY_BUSH = ClimateRanges.register("plant/cranberry_bush");
    public static final Map<FruitBlocks.StationaryBush, DataManager.Reference<ClimateRange>> STATIONARY_BUSHES = Helpers.mapOf(FruitBlocks.StationaryBush.class, bush -> ClimateRanges.register("plant/" + bush.name() + "_bush"));
    public static final Map<FruitBlocks.SpreadingBush, DataManager.Reference<ClimateRange>> SPREADING_BUSHES = Helpers.mapOf(FruitBlocks.SpreadingBush.class, bush -> ClimateRanges.register("plant/" + bush.name() + "_bush"));
    public static final Map<FruitBlocks.Tree, DataManager.Reference<ClimateRange>> FRUIT_TREES = Helpers.mapOf(FruitBlocks.Tree.class, tree -> ClimateRanges.register("plant/" + tree.name() + "_tree"));
    public static final Map<Crop, DataManager.Reference<ClimateRange>> CROPS = Helpers.mapOf(Crop.class, crop -> ClimateRanges.register("crop/" + crop.getSerializedName()));

    private static DataManager.Reference<ClimateRange> register(String name) {
        return ClimateRange.MANAGER.getReference(Helpers.identifier(name.toLowerCase(Locale.ROOT)));
    }
}

