/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.collections;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;

public class IndirectHashCollection<K, R> {
    private static final List<Cache> CACHES = new ArrayList<Cache>();
    private final Map<K, Collection<R>> indirectResultMap;
    private final Function<R, Iterable<? extends K>> keyExtractor;

    public static <K, R> IndirectHashCollection<K, R> create(Function<R, Iterable<? extends K>> keyExtractor, Supplier<Collection<R>> values) {
        IndirectHashCollection<? extends K, R> cache = new IndirectHashCollection<K, R>(keyExtractor);
        IndirectHashCollection.create(new DirectCache<K, R>(cache, values));
        return cache;
    }

    public static <K, R extends Recipe<?>> IndirectHashCollection<K, R> createForRecipe(Function<R, Iterable<? extends K>> keyExtractor, Supplier<RecipeType<R>> recipeType) {
        IndirectHashCollection<? extends K, R> cache = new IndirectHashCollection<K, R>(keyExtractor);
        IndirectHashCollection.create(new RecipeCache<K, R>(cache, recipeType));
        return cache;
    }

    public static <R extends Recipe<?>> BiMap<ResourceLocation, R> createForRecipeId(Supplier<RecipeType<R>> recipeType) {
        HashBiMap cache = HashBiMap.create();
        IndirectHashCollection.create(new RecipeIdCache<R>(cache, recipeType));
        return cache;
    }

    public static synchronized <T extends Cache> T create(T cache) {
        CACHES.add(cache);
        return cache;
    }

    public static void reloadAllCaches(RecipeManager manager) {
        CACHES.forEach(c -> c.reload(manager));
    }

    public static void clearAllCaches() {
        CACHES.forEach(Cache::clear);
    }

    public IndirectHashCollection(Function<R, Iterable<? extends K>> keyExtractor) {
        this.keyExtractor = keyExtractor;
        this.indirectResultMap = new HashMap<K, Collection<R>>();
    }

    public Collection<R> getAll(K key) {
        return this.indirectResultMap.getOrDefault(key, List.of());
    }

    public void reload(Collection<R> values) {
        this.indirectResultMap.clear();
        values.forEach(result -> {
            for (K directKey : this.keyExtractor.apply(result)) {
                this.indirectResultMap.computeIfAbsent(directKey, k -> new ArrayList()).add(result);
            }
        });
    }

    public void clear() {
        this.indirectResultMap.clear();
    }

    record DirectCache<K, R>(IndirectHashCollection<K, R> cache, Supplier<Collection<R>> values) implements Cache
    {
        @Override
        public void clear() {
            this.cache.clear();
        }

        @Override
        public void reload(RecipeManager manager) {
            this.cache.reload(this.values.get());
        }
    }

    public static interface Cache {
        public void clear();

        public void reload(RecipeManager var1);
    }

    record RecipeCache<K, R extends Recipe<?>>(IndirectHashCollection<K, R> cache, Supplier<RecipeType<R>> recipeType) implements Cache
    {
        @Override
        public void clear() {
            this.cache.clear();
        }

        @Override
        public void reload(RecipeManager manager) {
            this.cache.reload(RecipeHelpers.getRecipes(manager, this.recipeType).stream().map(RecipeHolder::value).toList());
        }
    }

    record RecipeIdCache<R extends Recipe<?>>(BiMap<ResourceLocation, R> cache, Supplier<RecipeType<R>> recipeType) implements Cache
    {
        @Override
        public void clear() {
            this.cache.clear();
        }

        @Override
        public void reload(RecipeManager manager) {
            this.cache.clear();
            RecipeHelpers.getRecipes(manager, this.recipeType).forEach(holder -> this.cache.put((Object)holder.id(), (Object)holder.value()));
        }
    }
}

