/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.dries007.tfc.common.blockentities.FarmlandBlockEntity;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.dries007.tfc.util.data.DataManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public record Fertilizer(Ingredient ingredient, float nitrogen, float phosphorus, float potassium) {
    public static final Codec<Fertilizer> CODEC = RecordCodecBuilder.create(i -> i.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(c -> c.ingredient), (App)Codec.FLOAT.optionalFieldOf("nitrogen", (Object)Float.valueOf(0.0f)).forGetter(c -> Float.valueOf(c.nitrogen)), (App)Codec.FLOAT.optionalFieldOf("phosphorus", (Object)Float.valueOf(0.0f)).forGetter(c -> Float.valueOf(c.phosphorus)), (App)Codec.FLOAT.optionalFieldOf("potassium", (Object)Float.valueOf(0.0f)).forGetter(c -> Float.valueOf(c.potassium))).apply((Applicative)i, Fertilizer::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Fertilizer> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, c -> c.ingredient, (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.nitrogen), (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.phosphorus), (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.potassium), Fertilizer::new);
    public static final DataManager<Fertilizer> MANAGER = new DataManager<Fertilizer>(Helpers.identifier("fertilizer"), CODEC, STREAM_CODEC);
    public static final IndirectHashCollection<Item, Fertilizer> CACHE = IndirectHashCollection.create(c -> RecipeHelpers.itemKeys(c.ingredient), MANAGER::getValues);

    @Nullable
    public static Fertilizer get(ItemStack stack) {
        for (Fertilizer def : CACHE.getAll(stack.getItem())) {
            if (!def.ingredient.test(stack)) continue;
            return def;
        }
        return null;
    }

    public float getNutrient(FarmlandBlockEntity.NutrientType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case FarmlandBlockEntity.NutrientType.NITROGEN -> this.nitrogen;
            case FarmlandBlockEntity.NutrientType.PHOSPHOROUS -> this.phosphorus;
            case FarmlandBlockEntity.NutrientType.POTASSIUM -> this.potassium;
        };
    }
}

