/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.dries007.tfc.common.recipes.IRecipePredicate;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.dries007.tfc.util.data.DataManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public record Fuel(Ingredient ingredient, int duration, float temperature, float purity) implements IRecipePredicate<ItemStack>
{
    public static final Codec<Fuel> CODEC = RecordCodecBuilder.create(i -> i.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(c -> c.ingredient), (App)Codec.INT.fieldOf("duration").forGetter(c -> c.duration), (App)Codec.FLOAT.fieldOf("temperature").forGetter(c -> Float.valueOf(c.temperature)), (App)Codec.FLOAT.optionalFieldOf("purity", (Object)Float.valueOf(1.0f)).forGetter(c -> Float.valueOf(c.purity))).apply((Applicative)i, Fuel::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Fuel> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, c -> c.ingredient, (StreamCodec)ByteBufCodecs.VAR_INT, c -> c.duration, (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.temperature), (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.purity), Fuel::new);
    public static final DataManager<Fuel> MANAGER = new DataManager<Fuel>(Helpers.identifier("fuel"), CODEC, STREAM_CODEC);
    public static final IndirectHashCollection<Item, Fuel> CACHE = IndirectHashCollection.create(r -> RecipeHelpers.itemKeys(r.ingredient), MANAGER::getValues);

    @Nullable
    public static Fuel get(ItemStack stack) {
        return RecipeHelpers.getRecipe(CACHE, stack, stack.getItem());
    }

    @Override
    public boolean matches(ItemStack input) {
        return this.ingredient.test(input);
    }
}

