/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.dries007.tfc.common.recipes.IRecipePredicate;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.PhysicalDamage;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.dries007.tfc.util.data.DataManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public record ItemDamageResistance(Ingredient ingredient, PhysicalDamage damages) implements IRecipePredicate<ItemStack>
{
    public static final Codec<ItemDamageResistance> CODEC = RecordCodecBuilder.create(i -> i.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(c -> c.ingredient), (App)PhysicalDamage.CODEC.forGetter(c -> c.damages)).apply((Applicative)i, ItemDamageResistance::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemDamageResistance> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, c -> c.ingredient, PhysicalDamage.STREAM_CODEC, c -> c.damages, ItemDamageResistance::new);
    public static final DataManager<ItemDamageResistance> MANAGER = new DataManager<ItemDamageResistance>(Helpers.identifier("item_damage_resistance"), CODEC, STREAM_CODEC);
    public static final IndirectHashCollection<Item, ItemDamageResistance> CACHE = IndirectHashCollection.create(c -> RecipeHelpers.itemKeys(c.ingredient), MANAGER::getValues);

    @Nullable
    public static ItemDamageResistance get(ItemStack stack) {
        return RecipeHelpers.getRecipe(CACHE, stack, stack.getItem());
    }

    @Override
    public boolean matches(ItemStack input) {
        return this.ingredient.test(input);
    }
}

