/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public final class KnappingPattern {
    public static final int MAX_WIDTH = 5;
    public static final int MAX_HEIGHT = 5;
    public static final MapCodec<KnappingPattern> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.listOf(1, 5).fieldOf("pattern").forGetter(c -> c.pattern), (App)Codec.BOOL.optionalFieldOf("default_on").forGetter(c -> c.defaultOn)).apply((Applicative)i, Prototype::new)).flatXmap(KnappingPattern::readPattern, KnappingPattern::writePattern);
    public static final StreamCodec<ByteBuf, KnappingPattern> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, c -> c.width, (StreamCodec)ByteBufCodecs.VAR_INT, c -> c.height, (StreamCodec)ByteBufCodecs.INT, c -> c.data, (StreamCodec)ByteBufCodecs.BOOL, c -> c.defaultOn, KnappingPattern::new);
    private final int width;
    private final int height;
    private final boolean defaultOn;
    private int data;

    public static KnappingPattern from(boolean defaultOn, String ... pattern) {
        return (KnappingPattern)KnappingPattern.readPattern(new Prototype(List.of(pattern), Optional.of(defaultOn))).getOrThrow();
    }

    private static DataResult<KnappingPattern> readPattern(Prototype proto) {
        int height = proto.pattern.size();
        if (height == 0 || height > 5) {
            return DataResult.error(() -> "Invalid pattern: must have [1, 5] rows");
        }
        int width = proto.pattern.getFirst().length();
        if (width == 0 || width > 5) {
            return DataResult.error(() -> "Invalid pattern: must have [1, 5] columns");
        }
        if ((height != 5 || width != 5) && proto.defaultOn.isEmpty()) {
            return DataResult.error(() -> "default_on is required if the pattern is not 5x5");
        }
        KnappingPattern pattern = new KnappingPattern(width, height, proto.defaultOn.orElse(false));
        for (int r = 0; r < height; ++r) {
            String row = proto.pattern.get(r);
            if (r > 0 && width != row.length()) {
                return DataResult.error(() -> "Invalid pattern: each row must be the same width");
            }
            for (int c = 0; c < width; ++c) {
                pattern.set(r * width + c, row.charAt(c) != ' ');
            }
        }
        return DataResult.success((Object)pattern);
    }

    private static DataResult<Prototype> writePattern(KnappingPattern pattern) {
        ArrayList<String> array = new ArrayList<String>();
        for (int r = 0; r < pattern.height; ++r) {
            StringBuilder row = new StringBuilder();
            for (int c = 0; c < pattern.width; ++c) {
                row.append(pattern.get(r * pattern.width + c) ? (char)'#' : ' ');
            }
            array.add(row.toString());
        }
        return DataResult.success((Object)new Prototype(array, pattern.height == 5 && pattern.width == 5 ? Optional.empty() : Optional.of(pattern.defaultOn)));
    }

    public KnappingPattern() {
        this(5, 5, false);
    }

    public KnappingPattern(int width, int height, boolean defaultOn) {
        this(width, height, (1 << width * height) - 1, defaultOn);
    }

    private KnappingPattern(int width, int height, int data, boolean defaultOn) {
        this.width = width;
        this.height = height;
        this.data = data;
        this.defaultOn = defaultOn;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean defaultIsOn() {
        return this.defaultOn;
    }

    public void setAll(boolean value) {
        this.data = value ? (1 << this.width * this.height) - 1 : 0;
    }

    public void set(int x, int y, boolean value) {
        this.set(x + y * this.width, value);
    }

    public void set(int index, boolean value) {
        assert (index >= 0 && index < 32);
        this.data = value ? (this.data |= 1 << index) : (this.data &= ~(1 << index));
    }

    public boolean get(int x, int y) {
        return this.get(x + y * this.width);
    }

    public boolean get(int index) {
        assert (index >= 0 && index < 32);
        return (this.data >> index & 1) == 1;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof KnappingPattern) {
            KnappingPattern p = (KnappingPattern)other;
            int mask = (1 << this.width * this.height) - 1;
            return this.width == p.width && this.height == p.height && this.defaultOn == p.defaultOn && (this.data & mask) == (p.data & mask);
        }
        return false;
    }

    public boolean matches(KnappingPattern other) {
        for (int dx = 0; dx <= this.width - other.width; ++dx) {
            for (int dy = 0; dy <= this.height - other.height; ++dy) {
                if (!this.matches(other, dx, dy, false) && !this.matches(other, dx, dy, true)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(KnappingPattern other, int startX, int startY, boolean mirror) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                int patternIdx = y * this.width + x;
                if (x < startX || y < startY || x - startX >= other.width || y - startY >= other.height) {
                    if (this.get(patternIdx) == other.defaultOn) continue;
                    return false;
                }
                int otherIdx = mirror ? (y - startY) * other.width + (other.width - 1 - (x - startX)) : (y - startY) * other.width + (x - startX);
                if (this.get(patternIdx) == other.get(otherIdx)) continue;
                return false;
            }
        }
        return true;
    }

    record Prototype(List<String> pattern, Optional<Boolean> defaultOn) {
    }
}

