/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.loot.TFCLoot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.Nullable;

public class CopyFluidFunction
extends LootItemConditionalFunction {
    public static final MapCodec<CopyFluidFunction> CODEC = RecordCodecBuilder.mapCodec(i -> CopyFluidFunction.commonFields((RecordCodecBuilder.Instance)i).apply((Applicative)i, CopyFluidFunction::new));

    public static ItemStack copyToItem(ItemStack stack, @Nullable BlockEntity entity) {
        if (entity != null && !stack.isEmpty()) {
            IFluidHandlerItem itemHandler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
            IFluidHandler blockHandler = (IFluidHandler)Helpers.getCapability(Capabilities.FluidHandler.BLOCK, entity);
            if (itemHandler != null && blockHandler != null) {
                itemHandler.fill(blockHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE);
                return itemHandler.getContainer();
            }
        }
        return stack;
    }

    public static void copyFromItem(ItemStack stack, @Nullable BlockEntity entity) {
        if (entity != null && !stack.isEmpty()) {
            IFluidHandlerItem itemHandler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
            IFluidHandler blockHandler = (IFluidHandler)Helpers.getCapability(Capabilities.FluidHandler.BLOCK, entity);
            if (itemHandler != null && blockHandler != null) {
                blockHandler.fill(itemHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    public CopyFluidFunction(List<LootItemCondition> conditions) {
        super(conditions);
    }

    public LootItemFunctionType<CopyFluidFunction> getType() {
        return (LootItemFunctionType)TFCLoot.COPY_FLUID.get();
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        if (context.hasParam(LootContextParams.BLOCK_ENTITY)) {
            return CopyFluidFunction.copyToItem(stack, (BlockEntity)context.getParam(LootContextParams.BLOCK_ENTITY));
        }
        return stack;
    }
}

