/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.tooltip;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.dries007.tfc.client.ClimateRenderCache;
import net.dries007.tfc.common.blockentities.AbstractFirepitBlockEntity;
import net.dries007.tfc.common.blockentities.AnemometerBlockEntity;
import net.dries007.tfc.common.blockentities.BarrelBlockEntity;
import net.dries007.tfc.common.blockentities.BellowsBlockEntity;
import net.dries007.tfc.common.blockentities.BlastFurnaceBlockEntity;
import net.dries007.tfc.common.blockentities.BloomBlockEntity;
import net.dries007.tfc.common.blockentities.BloomeryBlockEntity;
import net.dries007.tfc.common.blockentities.CalendarClockBlockEntity;
import net.dries007.tfc.common.blockentities.CharcoalForgeBlockEntity;
import net.dries007.tfc.common.blockentities.ComposterBlockEntity;
import net.dries007.tfc.common.blockentities.CropBlockEntity;
import net.dries007.tfc.common.blockentities.CrucibleBlockEntity;
import net.dries007.tfc.common.blockentities.DecayingBlockEntity;
import net.dries007.tfc.common.blockentities.FireboxBlockEntity;
import net.dries007.tfc.common.blockentities.IHeatable;
import net.dries007.tfc.common.blockentities.IngotPileBlockEntity;
import net.dries007.tfc.common.blockentities.LampBlockEntity;
import net.dries007.tfc.common.blockentities.LoomBlockEntity;
import net.dries007.tfc.common.blockentities.MoldTableBlockEntity;
import net.dries007.tfc.common.blockentities.NestBoxBlockEntity;
import net.dries007.tfc.common.blockentities.PitKilnBlockEntity;
import net.dries007.tfc.common.blockentities.PlacedItemBlockEntity;
import net.dries007.tfc.common.blockentities.PotBlockEntity;
import net.dries007.tfc.common.blockentities.PowderkegBlockEntity;
import net.dries007.tfc.common.blockentities.ThermometerBlockEntity;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.common.blockentities.TickingPlantBlockEntity;
import net.dries007.tfc.common.blockentities.VaneBlockEntity;
import net.dries007.tfc.common.blockentities.rotation.RotatingBlockEntity;
import net.dries007.tfc.common.blockentities.rotation.WaterWheelBlockEntity;
import net.dries007.tfc.common.blockentities.rotation.WindmillBlockEntity;
import net.dries007.tfc.common.blocks.BloomBlock;
import net.dries007.tfc.common.blocks.FireboxBlock;
import net.dries007.tfc.common.blocks.HotPouredGlassBlock;
import net.dries007.tfc.common.blocks.ShelfBlock;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCCandleBlock;
import net.dries007.tfc.common.blocks.TFCCandleCakeBlock;
import net.dries007.tfc.common.blocks.TFCTorchBlock;
import net.dries007.tfc.common.blocks.TFCWallTorchBlock;
import net.dries007.tfc.common.blocks.crop.CropBlock;
import net.dries007.tfc.common.blocks.crop.DecayingBlock;
import net.dries007.tfc.common.blocks.crop.DoubleCropBlock;
import net.dries007.tfc.common.blocks.devices.AnemometerBlock;
import net.dries007.tfc.common.blocks.devices.BarrelBlock;
import net.dries007.tfc.common.blocks.devices.BellowsBlock;
import net.dries007.tfc.common.blocks.devices.BlastFurnaceBlock;
import net.dries007.tfc.common.blocks.devices.BloomeryBlock;
import net.dries007.tfc.common.blocks.devices.CalendarClockBlock;
import net.dries007.tfc.common.blocks.devices.CharcoalForgeBlock;
import net.dries007.tfc.common.blocks.devices.CrucibleBlock;
import net.dries007.tfc.common.blocks.devices.DryingBricksBlock;
import net.dries007.tfc.common.blocks.devices.FirepitBlock;
import net.dries007.tfc.common.blocks.devices.IngotPileBlock;
import net.dries007.tfc.common.blocks.devices.JackOLanternBlock;
import net.dries007.tfc.common.blocks.devices.LampBlock;
import net.dries007.tfc.common.blocks.devices.MoldTableBlock;
import net.dries007.tfc.common.blocks.devices.NestBoxBlock;
import net.dries007.tfc.common.blocks.devices.PitKilnBlock;
import net.dries007.tfc.common.blocks.devices.PlacedItemBlock;
import net.dries007.tfc.common.blocks.devices.PowderkegBlock;
import net.dries007.tfc.common.blocks.devices.QuernBlock;
import net.dries007.tfc.common.blocks.devices.TFCComposterBlock;
import net.dries007.tfc.common.blocks.devices.ThermometerBlock;
import net.dries007.tfc.common.blocks.devices.VaneBlock;
import net.dries007.tfc.common.blocks.plant.fruit.FruitTreeSaplingBlock;
import net.dries007.tfc.common.blocks.rotation.AbstractShaftAxleBlock;
import net.dries007.tfc.common.blocks.rotation.ClutchBlock;
import net.dries007.tfc.common.blocks.rotation.CrankshaftBlock;
import net.dries007.tfc.common.blocks.rotation.CreativeRotationBlock;
import net.dries007.tfc.common.blocks.rotation.EncasedAxleBlock;
import net.dries007.tfc.common.blocks.rotation.GearBoxBlock;
import net.dries007.tfc.common.blocks.rotation.WaterWheelBlock;
import net.dries007.tfc.common.blocks.rotation.WindmillBlock;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.common.blocks.wood.TFCLoomBlock;
import net.dries007.tfc.common.blocks.wood.TFCSaplingBlock;
import net.dries007.tfc.common.component.EggComponent;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.component.heat.IHeatView;
import net.dries007.tfc.common.items.Powder;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.common.recipes.BloomeryRecipe;
import net.dries007.tfc.common.recipes.LoomRecipe;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.config.TemperatureDisplayStyle;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.data.LampFuel;
import net.dries007.tfc.util.rotation.Rotation;
import net.dries007.tfc.util.tooltip.BlockEntityTooltip;
import net.dries007.tfc.util.tooltip.RegisterCallback;
import net.dries007.tfc.util.tracker.WeatherHelpers;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public final class BlockEntityTooltips {
    public static final BlockEntityTooltip HOT_POURED_GLASS = (level, state, pos, entity, tooltip) -> {
        if (state.getBlock() instanceof HotPouredGlassBlock && !((Boolean)state.getValue((Property)HotPouredGlassBlock.FLAT)).booleanValue()) {
            tooltip.accept(Component.translatable((String)"tfc.tooltip.glass.flatten_me"));
        }
    };
    public static final BlockEntityTooltip ROTATING = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof RotatingBlockEntity) {
            RotatingBlockEntity rotating = (RotatingBlockEntity)entity;
            BlockEntityTooltips.getRotationComponent(rotating).ifPresent(tooltip);
        }
    };
    public static final BlockEntityTooltip ROTATIONAL_SOURCE = (level, state, pos, entity, tooltip) -> {
        WaterWheelBlockEntity wheel;
        if (entity instanceof RotatingBlockEntity) {
            RotatingBlockEntity rotating = (RotatingBlockEntity)entity;
            BlockEntityTooltips.getRotationComponent(rotating).ifPresent(tooltip);
        }
        if (entity instanceof WindmillBlockEntity) {
            WindmillBlockEntity windmill = (WindmillBlockEntity)entity;
            if ((Integer)level.getBlockState(pos).getValue((Property)WindmillBlock.COUNT) == 1) {
                tooltip.accept(Component.translatable((String)"tfc.tooltip.rotation.cannot_rotate.too_few_blades"));
            }
            if (windmill.isObstructed()) {
                tooltip.accept(Component.translatable((String)"tfc.tooltip.rotation.cannot_rotate.obstructed"));
            }
        }
        if (entity instanceof WaterWheelBlockEntity && (wheel = (WaterWheelBlockEntity)entity).isObstructed()) {
            tooltip.accept(Component.translatable((String)"tfc.tooltip.rotation.cannot_rotate.obstructed"));
        }
    };
    public static final BlockEntityTooltip INGOT_PILE = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof IngotPileBlockEntity) {
            IngotPileBlockEntity pile = (IngotPileBlockEntity)entity;
            pile.fillTooltip(tooltip);
        }
    };
    public static final BlockEntityTooltip CALENDAR_CLOCK = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof CalendarClockBlockEntity) {
            CalendarClockBlockEntity clock = (CalendarClockBlockEntity)entity;
            if (((CalendarClockBlock.Mode)((Object)((Object)clock.getBlockState().getValue(CalendarClockBlock.MODE)))).equals((Object)CalendarClockBlock.Mode.HOUR)) {
                tooltip.accept(Component.translatable((String)"tfc.tooltip.calendar_clock_hour_mode"));
            } else if (((CalendarClockBlock.Mode)((Object)((Object)clock.getBlockState().getValue(CalendarClockBlock.MODE)))).equals((Object)CalendarClockBlock.Mode.MONTH)) {
                tooltip.accept(Component.translatable((String)"tfc.tooltip.calendar_clock_month_mode"));
            } else {
                tooltip.accept(Component.translatable((String)"tfc.tooltip.calendar_clock_timer_mode"));
            }
            tooltip.accept(Calendars.CLIENT.getTimeAndDate());
        }
    };
    public static final BlockEntityTooltip THERMOMETER = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof ThermometerBlockEntity) {
            ThermometerBlockEntity thermometer = (ThermometerBlockEntity)entity;
            if (((Boolean)thermometer.getBlockState().getValue((Property)TFCBlockStateProperties.THERMOMETER_ATTACHED)).booleanValue()) {
                tooltip.accept(Component.translatable((String)"tfc.tooltip.thermometer_device_mode"));
                Direction direction = ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite();
                float temperature = 0.0f;
                BlockEntity patt0$temp = level.getBlockEntity(pos.relative(direction));
                if (patt0$temp instanceof IHeatable) {
                    IHeatable heatable = (IHeatable)patt0$temp;
                    temperature = heatable.getTemperature();
                }
                TemperatureDisplayStyle style = TFCConfig.CLIENT.climateTooltipStyle.get();
                Component temperatureComponent = (Component)Objects.requireNonNull(style.formatRange(temperature));
                tooltip.accept(temperatureComponent);
            } else {
                tooltip.accept(Component.translatable((String)"tfc.tooltip.thermometer_ambient_mode"));
                TemperatureDisplayStyle style = TFCConfig.CLIENT.climateTooltipStyle.get();
                Component temperatureComponent = (Component)Objects.requireNonNull(style.formatRange(ClimateRenderCache.INSTANCE.getTemperature()));
                tooltip.accept(temperatureComponent);
            }
        }
    };
    public static final BlockEntityTooltip ANEMOMETER = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof AnemometerBlockEntity) {
            AnemometerBlockEntity anemometer = (AnemometerBlockEntity)entity;
            float speed = WeatherHelpers.windKMH(ClimateRenderCache.INSTANCE.getWind());
            tooltip.accept(Component.translatable((String)"tfc.tooltip.anemometer_speed", (Object[])new Object[]{String.format("%.0f", Float.valueOf(speed))}));
        }
    };
    public static final BlockEntityTooltip VANE = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof VaneBlockEntity) {
            VaneBlockEntity vane = (VaneBlockEntity)entity;
            tooltip.accept(Component.translatable((String)"tfc.tooltip.vane_direction", (Object[])new Object[]{WeatherHelpers.windGranularCardinal(ClimateRenderCache.INSTANCE.getWind())}));
        }
    };
    public static final BlockEntityTooltip BARREL = (level, state, pos, entity, tooltip) -> {
        if (state.getBlock() instanceof BarrelBlock && entity instanceof BarrelBlockEntity) {
            Component recipe;
            long tickLeft;
            BarrelBlockEntity barrel = (BarrelBlockEntity)entity;
            if (((Boolean)state.getValue((Property)BarrelBlock.SEALED)).booleanValue() && (tickLeft = barrel.getRemainingTicks()) > 0L && (recipe = barrel.getRecipeTooltip()) != null) {
                tooltip.accept(recipe);
                tooltip.accept(Component.translatable((String)"tfc.jade.sealed_date", (Object[])new Object[]{Calendars.get((LevelReader)level).getExactTimeAndDate(barrel.getSealedTick())}));
                BlockEntityTooltips.timeLeft(level, tooltip, tickLeft);
            }
        }
    };
    public static final BlockEntityTooltip BELLOWS = (level, state, pos, entity, tooltip) -> {
        BellowsBlockEntity bellows;
        int step;
        if (entity instanceof BellowsBlockEntity && (step = Mth.clamp((int)((int)Mth.map((float)(bellows = (BellowsBlockEntity)entity).getExtensionLength(0.0f), (float)0.125f, (float)0.625f, (float)0.0f, (float)10.0f)), (int)0, (int)10)) > 0) {
            tooltip.accept(Component.translatable((String)("tfc.jade.bellows_" + step)));
        }
    };
    public static final BlockEntityTooltip BLAST_FURNACE = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof BlastFurnaceBlockEntity) {
            BlastFurnaceBlockEntity furnace = (BlastFurnaceBlockEntity)entity;
            BlockEntityTooltips.heat(tooltip, furnace.getTemperature());
            tooltip.accept(Component.translatable((String)"tfc.jade.input_stacks", (Object[])new Object[]{furnace.getInputCount()}));
            tooltip.accept(Component.translatable((String)"tfc.jade.catalyst_stacks", (Object[])new Object[]{furnace.getCatalystCount()}));
            tooltip.accept(Component.translatable((String)"tfc.jade.fuel_stacks", (Object[])new Object[]{furnace.getFuelCount()}));
        }
    };
    public static final BlockEntityTooltip BLOOMERY = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof BloomeryBlockEntity) {
            BloomeryBlockEntity bloomery = (BloomeryBlockEntity)entity;
            if (state.getBlock() instanceof BloomeryBlock) {
                BloomeryRecipe recipe;
                long ticksLeft;
                tooltip.accept(Component.translatable((String)"tfc.jade.input_stacks", (Object[])new Object[]{bloomery.getInputCount()}));
                if (((Boolean)state.getValue((Property)BloomeryBlock.LIT)).booleanValue() && (ticksLeft = bloomery.getRemainingTicks()) > 0L && (recipe = bloomery.getCachedRecipe()) != null) {
                    BlockEntityTooltips.timeLeft(level, tooltip, ticksLeft);
                    tooltip.accept(Component.translatable((String)"tfc.jade.creating", (Object[])new Object[]{recipe.getResultItem((HolderLookup.Provider)level.registryAccess()).getHoverName()}));
                }
                if (TFCConfig.CLIENT.enableDebug.get().booleanValue()) {
                    Object2IntOpenHashMap items = new Object2IntOpenHashMap();
                    for (ItemStack stack : bloomery.getInputStacks()) {
                        items.mergeInt((Object)stack.getItem(), 1, Integer::sum);
                    }
                    for (Map.Entry entry : items.object2IntEntrySet()) {
                        BlockEntityTooltips.itemWithCount(tooltip, new ItemStack((ItemLike)entry.getKey(), ((Integer)entry.getValue()).intValue()));
                    }
                }
            }
        }
    };
    public static final BlockEntityTooltip BLOOM = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof BloomBlockEntity) {
            BloomBlockEntity bloom = (BloomBlockEntity)entity;
            ItemStack item = bloom.getItem();
            ItemStack displayItem = item.copy();
            displayItem.setCount(bloom.getCount());
            BlockEntityTooltips.itemWithCount(tooltip, displayItem);
            @Nullable IHeatView heat = HeatCapability.view(item);
            if (heat != null) {
                heat.addTooltipInfo(item, tooltip);
            }
        }
    };
    public static final BlockEntityTooltip CHARCOAL_FORGE = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof CharcoalForgeBlockEntity) {
            CharcoalForgeBlockEntity forge = (CharcoalForgeBlockEntity)entity;
            BlockEntityTooltips.heat(tooltip, forge.getTemperature());
        }
    };
    public static final BlockEntityTooltip COMPOSTER = (level, state, pos, entity, tooltip) -> {
        if (state.getBlock() instanceof TFCComposterBlock && entity instanceof ComposterBlockEntity) {
            ComposterBlockEntity composter = (ComposterBlockEntity)entity;
            if (composter.isRotten()) {
                tooltip.accept(Component.translatable((String)"tfc.composter.rotten"));
            } else if (!composter.isReady() && (Integer)state.getValue((Property)TFCComposterBlock.STAGE) == 8) {
                BlockEntityTooltips.timeLeft(level, tooltip, composter.getReadyTicks() - composter.getTicksSinceUpdate());
            }
        }
    };
    public static final BlockEntityTooltip CROP = (level, state, pos, entity, tooltip) -> {
        if (state.getBlock() instanceof CropBlock) {
            if (state.getBlock() instanceof DoubleCropBlock && state.getValue(DoubleCropBlock.PART) == DoubleCropBlock.Part.TOP) {
                entity = level.getBlockEntity(pos.below());
            }
            if (entity != null && entity instanceof CropBlockEntity) {
                CropBlockEntity crop = (CropBlockEntity)entity;
                tooltip.accept(Component.translatable((String)"tfc.jade.yield", (Object[])new Object[]{String.format("%.0f", Float.valueOf(crop.getYield() * 100.0f))}));
            }
        }
    };
    public static final BlockEntityTooltip CRUCIBLE = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof CrucibleBlockEntity) {
            CrucibleBlockEntity crucible = (CrucibleBlockEntity)entity;
            BlockEntityTooltips.heat(tooltip, crucible.getTemperature());
        }
    };
    public static final BlockEntityTooltip FIREPIT = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof AbstractFirepitBlockEntity) {
            AbstractFirepitBlockEntity firepit = (AbstractFirepitBlockEntity)entity;
            BlockEntityTooltips.heat(tooltip, firepit.getTemperature());
            if (state.hasProperty((Property)FirepitBlock.SMOKE_LEVEL)) {
                tooltip.accept(Component.translatable((String)"tfc.jade.smoke_level", (Object[])new Object[]{state.getValue((Property)FirepitBlock.SMOKE_LEVEL)}));
            }
            if (firepit.getAsh() > 0) {
                BlockEntityTooltips.itemWithCount(tooltip, new ItemStack((ItemLike)TFCItems.POWDERS.get((Object)Powder.WOOD_ASH).get(), firepit.getAsh()));
            }
            if (firepit instanceof PotBlockEntity) {
                PotBlockEntity pot = (PotBlockEntity)firepit;
                if (pot.shouldRenderAsBoiling()) {
                    tooltip.accept(Component.translatable((String)"tfc.tooltip.pot_boiling"));
                } else if (pot.getOutput() != null && !pot.getOutput().isEmpty()) {
                    tooltip.accept(Component.translatable((String)"tfc.tooltip.pot_finished"));
                    BlockEntityTooltip tt = pot.getOutput().getTooltip();
                    if (tt != null) {
                        tt.display(level, state, pos, entity, tooltip);
                    }
                }
            }
        }
    };
    public static final BlockEntityTooltip FRUIT_TREE_SAPLING = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof TickingPlantBlockEntity) {
            TickingPlantBlockEntity counter = (TickingPlantBlockEntity)entity;
            Block patt0$temp = state.getBlock();
            if (patt0$temp instanceof FruitTreeSaplingBlock) {
                FruitTreeSaplingBlock sapling = (FruitTreeSaplingBlock)patt0$temp;
                BlockEntityTooltips.timeLeft(level, tooltip, sapling.getTicksToGrow() - counter.getTicksSinceUpdate(), (Component)Component.translatable((String)"tfc.jade.ready_to_grow"));
            }
        }
    };
    public static final BlockEntityTooltip HOE_OVERLAY = (level, state, pos, entity, tooltip) -> {
        Block patt0$temp = state.getBlock();
        if (patt0$temp instanceof HoeOverlayBlock) {
            HoeOverlayBlock overlay = (HoeOverlayBlock)patt0$temp;
            if (TFCConfig.CLIENT.showHoeOverlaysInInfoMods.get().booleanValue() && entity != null) {
                BlockPos pos1 = entity.getBlockPos();
                overlay.addHoeOverlayInfo(level, pos1, level.getBlockState(pos1), tooltip, false);
            }
        }
    };
    public static final BlockEntityTooltip LAMP = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof LampBlockEntity) {
            LampFuel fuel;
            LampBlockEntity lamp = (LampBlockEntity)entity;
            if (state.getBlock() instanceof LampBlock && (fuel = lamp.getFuel()) != null) {
                if (fuel.burnRate() != -1) {
                    tooltip.accept(Component.translatable((String)"tfc.jade.burn_rate", (Object[])new Object[]{fuel.burnRate()}));
                }
                if (((Boolean)state.getValue((Property)LampBlock.LIT)).booleanValue()) {
                    if (fuel.burnRate() == -1) {
                        tooltip.accept(Component.translatable((String)"tfc.jade.burn_forever"));
                    } else {
                        int fluid;
                        IFluidHandler fluidHandler = (IFluidHandler)Helpers.getCapability(Capabilities.FluidHandler.BLOCK, lamp);
                        if (fluidHandler != null && (fluid = fluidHandler.getFluidInTank(0).getAmount()) > 0) {
                            BlockEntityTooltips.timeLeft(level, tooltip, (long)fluid * (long)fuel.burnRate());
                        }
                    }
                }
            }
        }
    };
    public static final BlockEntityTooltip NEST_BOX = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof NestBoxBlockEntity) {
            NestBoxBlockEntity nest = (NestBoxBlockEntity)entity;
            for (int i = 0; i < ((ItemStackHandler)nest.getInventory()).getSlots(); ++i) {
                ItemStack stack = ((ItemStackHandler)nest.getInventory()).getStackInSlot(i);
                @Nullable EggComponent egg = (EggComponent)stack.get(TFCComponents.EGG);
                if (egg == null) continue;
                tooltip.accept(stack.getHoverName());
                egg.addTooltipInfo(tooltip);
            }
        }
    };
    public static final BlockEntityTooltip PIT_KILN_INTERNAL = (level, state, pos, entity, tooltip) -> BlockEntityTooltips.pitKiln(level, pos, tooltip);
    public static final BlockEntityTooltip PIT_KILN_ABOVE = (level, state, pos, entity, tooltip) -> BlockEntityTooltips.pitKiln(level, pos.below(), tooltip);
    public static final BlockEntityTooltip POWDER_KEG = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof PowderkegBlockEntity) {
            PowderkegBlockEntity keg = (PowderkegBlockEntity)entity;
            tooltip.accept(Component.translatable((String)"tfc.jade.explosion_strength", (Object[])new Object[]{PowderkegBlockEntity.getStrength(keg)}));
        }
    };
    public static final BlockEntityTooltip SAPLING = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof TickCounterBlockEntity) {
            TickCounterBlockEntity counter = (TickCounterBlockEntity)entity;
            Block patt0$temp = state.getBlock();
            if (patt0$temp instanceof TFCSaplingBlock) {
                TFCSaplingBlock sapling = (TFCSaplingBlock)patt0$temp;
                BlockEntityTooltips.timeLeft(level, tooltip, sapling.getTicksToGrow() - counter.getTicksSinceUpdate(), (Component)Component.translatable((String)"tfc.jade.ready_to_grow"));
            }
        }
    };
    public static final BlockEntityTooltip TORCH = BlockEntityTooltips.tickCounter(TFCConfig.SERVER.torchTicks);
    public static final BlockEntityTooltip CANDLE = BlockEntityTooltips.tickCounter(TFCConfig.SERVER.candleTicks);
    public static final BlockEntityTooltip JACK_O_LANTERN = BlockEntityTooltips.tickCounter(TFCConfig.SERVER.jackOLanternTicks);
    public static final BlockEntityTooltip MUD_BRICKS = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof TickCounterBlockEntity) {
            TickCounterBlockEntity counter = (TickCounterBlockEntity)entity;
            if (state.getBlock() instanceof DryingBricksBlock) {
                if (((Boolean)state.getValue((Property)DryingBricksBlock.DRIED)).booleanValue()) {
                    tooltip.accept(Component.translatable((String)"tfc.jade.dried_mud_bricks"));
                } else if (level.isRainingAt(entity.getBlockPos().above())) {
                    tooltip.accept(Component.translatable((String)"tfc.jade.raining_mud_bricks").withStyle(ChatFormatting.BLUE));
                } else {
                    BlockEntityTooltips.timeLeft(level, tooltip, (long)TFCConfig.SERVER.mudBricksTicks.get().intValue() - counter.getTicksSinceUpdate(), (Component)Component.translatable((String)"tfc.jade.mud_bricks_nearly_done"));
                }
            }
        }
    };
    public static final BlockEntityTooltip DECAYING = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof DecayingBlockEntity) {
            DecayingBlockEntity decaying = (DecayingBlockEntity)entity;
            ItemStack stack = decaying.getStack();
            tooltip.accept(stack.getHoverName());
            FoodCapability.addTooltipInfo(stack, tooltip);
        }
    };
    public static final BlockEntityTooltip LOOM = (level, state, pos, entity, tooltip) -> {
        LoomBlockEntity loom;
        LoomRecipe recipe;
        if (entity instanceof LoomBlockEntity && (recipe = (loom = (LoomBlockEntity)entity).getRecipe()) != null) {
            tooltip.accept(Component.translatable((String)"tfc.jade.loom_progress", (Object[])new Object[]{loom.getProgress(), recipe.getStepCount(), recipe.getResultItem((HolderLookup.Provider)level.registryAccess()).getDisplayName()}));
        }
    };
    public static final BlockEntityTooltip MOLD_TABLE = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof MoldTableBlockEntity) {
            MoldTableBlockEntity mold = (MoldTableBlockEntity)entity;
            BlockEntityTooltips.heat(tooltip, ((MoldTableBlockEntity.MoldBlockInventory)mold.getInventory()).getTemperature());
        }
    };
    public static final BlockEntityTooltip FIREBOX = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof FireboxBlockEntity) {
            FireboxBlockEntity firebox = (FireboxBlockEntity)entity;
            BlockEntityTooltips.heat(tooltip, firebox.getTemperature());
        }
    };
    public static final BlockEntityTooltip PLACED_ITEM = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof PlacedItemBlockEntity) {
            PlacedItemBlockEntity placedItem = (PlacedItemBlockEntity)entity;
            for (ItemStack stack : Helpers.iterate(placedItem.getInventory())) {
                if (stack.isEmpty()) continue;
                tooltip.accept(stack.getHoverName());
            }
        }
    };

    public static void register(RegisterCallback<BlockEntityTooltip, Block> callback) {
        callback.register("barrel", BARREL, BarrelBlock.class);
        callback.register("bellows", BELLOWS, BellowsBlock.class);
        callback.register("sapling", SAPLING, TFCSaplingBlock.class);
        callback.register("blast_furnace", BLAST_FURNACE, BlastFurnaceBlock.class);
        callback.register("bloomery", BLOOMERY, BloomeryBlock.class);
        callback.register("bloom", BLOOM, BloomBlock.class);
        callback.register("charcoal_forge", CHARCOAL_FORGE, CharcoalForgeBlock.class);
        callback.register("composter", COMPOSTER, TFCComposterBlock.class);
        callback.register("crop", CROP, CropBlock.class);
        callback.register("crucible", CRUCIBLE, CrucibleBlock.class);
        callback.register("firebox", FIREBOX, FireboxBlock.class);
        callback.register("firepit", FIREPIT, FirepitBlock.class);
        callback.register("fruit_tree_sapling", FRUIT_TREE_SAPLING, FruitTreeSaplingBlock.class);
        callback.register("hoe_overlay", HOE_OVERLAY, Block.class);
        callback.register("lamp", LAMP, LampBlock.class);
        callback.register("nest_box", NEST_BOX, NestBoxBlock.class);
        callback.register("pit_kiln_internal", PIT_KILN_INTERNAL, PitKilnBlock.class);
        callback.register("pit_kiln_above", PIT_KILN_ABOVE, FireBlock.class);
        callback.register("powder_keg", POWDER_KEG, PowderkegBlock.class);
        callback.register("torch", TORCH, TFCTorchBlock.class);
        callback.register("wall_torch", TORCH, TFCWallTorchBlock.class);
        callback.register("candle", CANDLE, TFCCandleBlock.class);
        callback.register("candle_cake", CANDLE, TFCCandleCakeBlock.class);
        callback.register("jack_o_lantern", JACK_O_LANTERN, JackOLanternBlock.class);
        callback.register("mud_bricks", MUD_BRICKS, DryingBricksBlock.class);
        callback.register("decaying", DECAYING, DecayingBlock.class);
        callback.register("loom", LOOM, TFCLoomBlock.class);
        callback.register("ingot_pile", INGOT_PILE, IngotPileBlock.class);
        callback.register("axle", ROTATING, AbstractShaftAxleBlock.class);
        callback.register("encased_axle", ROTATING, EncasedAxleBlock.class);
        callback.register("clutch", ROTATING, ClutchBlock.class);
        callback.register("gearbox", ROTATING, GearBoxBlock.class);
        callback.register("crankshaft", ROTATING, CrankshaftBlock.class);
        callback.register("quern", ROTATING, QuernBlock.class);
        callback.register("creative_motor", ROTATIONAL_SOURCE, CreativeRotationBlock.class);
        callback.register("water_wheel", ROTATIONAL_SOURCE, WaterWheelBlock.class);
        callback.register("windmill", ROTATIONAL_SOURCE, WindmillBlock.class);
        callback.register("hot_poured_glass", HOT_POURED_GLASS, HotPouredGlassBlock.class);
        callback.register("mold_table", MOLD_TABLE, MoldTableBlock.class);
        callback.register("placed_item", PLACED_ITEM, PlacedItemBlock.class);
        callback.register("shelf", PLACED_ITEM, ShelfBlock.class);
        callback.register("calendar_clock", CALENDAR_CLOCK, CalendarClockBlock.class);
        callback.register("thermometer", THERMOMETER, ThermometerBlock.class);
        callback.register("anemometer", ANEMOMETER, AnemometerBlock.class);
        callback.register("vane", VANE, VaneBlock.class);
    }

    public static Optional<Component> getRotationComponent(RotatingBlockEntity rotating) {
        Rotation rotation = rotating.getRotationNode().rotation();
        if (rotation != null && rotation.speed() != 0.0f) {
            float speed = Math.abs(rotation.positiveSpeed());
            switch (TFCConfig.CLIENT.rotationDisplayStyle.get()) {
                case RADIANS_PER_SECOND: {
                    return Optional.of(Component.translatable((String)"tfc.tooltip.rotation.angular_velocity.radians_per_second", (Object[])new Object[]{String.format("%.2f", Float.valueOf(speed *= 20.0f))}));
                }
                case DEGREES_PER_SECOND: {
                    speed = speed / ((float)Math.PI * 2) * 360.0f * 20.0f;
                    return Optional.of(Component.translatable((String)"tfc.tooltip.rotation.angular_velocity.degrees_per_second", (Object[])new Object[]{String.format("%.2f", Float.valueOf(speed))}));
                }
                case REVOLUTIONS_PER_SECOND: {
                    return Optional.of(Component.translatable((String)"tfc.tooltip.rotation.angular_velocity.revolutions_per_second", (Object[])new Object[]{String.format("%.4f", Float.valueOf(speed /= 125.66371f))}));
                }
                case REVOLUTIONS_PER_MINUTE: {
                    speed = speed / ((float)Math.PI * 2) * 20.0f * 60.0f;
                    return Optional.of(Component.translatable((String)"tfc.tooltip.rotation.angular_velocity.revolutions_per_minute", (Object[])new Object[]{String.format("%.1f", Float.valueOf(speed))}));
                }
            }
        }
        return Optional.empty();
    }

    private static void pitKiln(Level level, BlockPos pos, Consumer<Component> tooltip) {
        BlockState state = level.getBlockState(pos);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PitKilnBlockEntity) {
            PitKilnBlockEntity kiln = (PitKilnBlockEntity)blockEntity;
            if (state.getBlock() instanceof PitKilnBlock) {
                if ((Integer)state.getValue((Property)PitKilnBlock.STAGE) == 16) {
                    BlockEntityTooltips.timeLeft(level, tooltip, kiln.getTicksLeft());
                } else {
                    tooltip.accept((Component)Component.translatable((String)"tfc.jade.straws", (Object[])new Object[]{kiln.getStraws().stream().filter(s1 -> !s1.isEmpty()).mapToInt(s1 -> PitKilnBlock.strawValue(s1)).sum()}));
                    tooltip.accept((Component)Component.translatable((String)"tfc.jade.logs", (Object[])new Object[]{kiln.getLogs().stream().filter(s -> !s.isEmpty()).toList().size()}));
                }
            }
        }
    }

    public static void itemWithCount(Consumer<Component> tooltip, ItemStack stack) {
        tooltip.accept((Component)Component.literal((String)String.valueOf(stack.getCount())).append("x ").append(stack.getHoverName()));
    }

    public static void heat(Consumer<Component> tooltip, float temperature) {
        MutableComponent heat = TFCConfig.CLIENT.heatTooltipStyle.get().formatColored(temperature);
        if (heat != null) {
            tooltip.accept((Component)heat);
        }
    }

    public static void timeLeft(Level level, Consumer<Component> tooltip, long ticks) {
        BlockEntityTooltips.timeLeft(level, tooltip, ticks, null);
    }

    public static void timeLeft(Level level, Consumer<Component> tooltip, long ticks, @Nullable Component ifNegative) {
        if (ticks > 0L) {
            tooltip.accept((Component)Component.translatable((String)"tfc.jade.time_left", (Object[])new Object[]{Calendars.get((LevelReader)level).getTimeDelta(ticks)}));
        } else if (ifNegative != null) {
            tooltip.accept(ifNegative);
        }
    }

    public static BlockEntityTooltip tickCounter(Supplier<Integer> totalTicks) {
        return (level, state, pos, entity, tooltip) -> {
            if (entity instanceof TickCounterBlockEntity) {
                TickCounterBlockEntity counter = (TickCounterBlockEntity)entity;
                BlockEntityTooltips.timeLeft(level, tooltip, (long)((Integer)totalTicks.get()).intValue() - counter.getTicksSinceUpdate());
            }
        };
    }
}

