/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world;

import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.Arrays;
import java.util.Map;
import net.dries007.tfc.world.BiomeNoiseSampler;
import net.dries007.tfc.world.ChunkBiomeSampler;
import net.dries007.tfc.world.biome.BiomeBlendType;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.biome.BiomeSourceExtension;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.region.RegionPartition;
import net.dries007.tfc.world.region.RiverEdge;
import net.dries007.tfc.world.region.Units;
import net.dries007.tfc.world.river.Flow;
import net.dries007.tfc.world.river.MidpointFractal;
import net.dries007.tfc.world.river.RiverBlendType;
import net.dries007.tfc.world.river.RiverInfo;
import net.dries007.tfc.world.river.RiverNoiseSampler;
import net.dries007.tfc.world.shore.ShoreBlendType;
import net.dries007.tfc.world.shore.ShoreNoiseSampler;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class ChunkHeightFiller {
    protected static final int RIVER_TYPE_NONE = RiverBlendType.NONE.ordinal();
    protected static final int RIVER_TYPE_CAVE = RiverBlendType.CAVE.ordinal();
    protected final Map<BiomeExtension, BiomeNoiseSampler> biomeNoiseSamplers;
    protected final Object2DoubleMap<BiomeNoiseSampler> columnBiomeNoiseSamplers;
    protected final Object2DoubleMap<BiomeExtension>[] sampledBiomeWeights;
    protected final Object2DoubleMap<BiomeExtension> biomeWeights1;
    protected final BiomeSourceExtension biomeSource;
    protected final Map<RiverBlendType, RiverNoiseSampler> riverNoiseSamplers;
    protected final double[] riverBlendWeights;
    protected final Map<ShoreBlendType, ShoreNoiseSampler> shoreNoiseSamplers;
    protected final double[] shoreBlendWeights;
    protected final int seaLevel;
    protected final Noise2D tideHeightNoise;
    protected int blockX;
    protected int blockZ;
    protected int localX;
    protected int localZ;

    public ChunkHeightFiller(Object2DoubleMap<BiomeExtension>[] sampledBiomeWeights, BiomeSourceExtension biomeSource, Map<BiomeExtension, BiomeNoiseSampler> biomeNoiseSamplers, Map<RiverBlendType, RiverNoiseSampler> riverNoiseSamplers, Map<ShoreBlendType, ShoreNoiseSampler> shoreNoiseSamplers, int seaLevel, Noise2D tideHeightNoise) {
        this.biomeNoiseSamplers = biomeNoiseSamplers;
        this.columnBiomeNoiseSamplers = new Object2DoubleOpenHashMap();
        this.sampledBiomeWeights = sampledBiomeWeights;
        this.biomeWeights1 = new Object2DoubleOpenHashMap();
        this.biomeSource = biomeSource;
        this.riverNoiseSamplers = riverNoiseSamplers;
        this.riverBlendWeights = new double[RiverBlendType.SIZE];
        this.shoreNoiseSamplers = shoreNoiseSamplers;
        this.shoreBlendWeights = new double[ShoreBlendType.SIZE];
        this.seaLevel = seaLevel;
        this.tideHeightNoise = tideHeightNoise;
    }

    public double sampleHeight(int blockX, int blockZ) {
        this.setupColumn(blockX, blockZ);
        this.prepareColumnBiomeWeights();
        return this.sampleColumnHeightAndBiome(this.biomeWeights1, false);
    }

    protected final void prepareColumnBiomeWeights() {
        ChunkBiomeSampler.sampleBiomesColumn(this.biomeWeights1, this.sampledBiomeWeights, this.localX, this.localZ);
    }

    protected final double sampleColumnHeightAndBiome(Object2DoubleMap<BiomeExtension> biomeWeights, boolean useCache) {
        this.columnBiomeNoiseSamplers.clear();
        double height = 0.0;
        double normalHeight = 0.0;
        double shoreHeight = 0.0;
        double shoreBaseHeight = 0.0;
        double oceanHeight = 0.0;
        double shoreWeight = 0.0;
        double oceanWeight = 0.0;
        BiomeExtension biomeAt = null;
        BiomeExtension normalBiomeAt = null;
        BiomeExtension shoreBiomeAt = null;
        BiomeExtension oceanBiomeAt = null;
        double maxNormalWeight = 0.0;
        double maxShoreWeight = 0.0;
        double maxOceanWeight = 0.0;
        boolean anySaltyBiomesNearby = false;
        for (Object2DoubleMap.Entry entry : biomeWeights.object2DoubleEntrySet()) {
            double biomeWeight = entry.getDoubleValue();
            BiomeExtension biome = (BiomeExtension)entry.getKey();
            BiomeNoiseSampler sampler = this.biomeNoiseSamplers.get(biome);
            if (biome.isSalty()) {
                anySaltyBiomesNearby = true;
            }
            assert (sampler != null) : "Non-existent sampler for biome: " + String.valueOf(biome.key());
            if (this.columnBiomeNoiseSamplers.containsKey((Object)sampler)) {
                this.columnBiomeNoiseSamplers.mergeDouble((Object)sampler, biomeWeight, Double::sum);
            } else {
                sampler.setColumn(this.blockX, this.blockZ);
                this.columnBiomeNoiseSamplers.put((Object)sampler, biomeWeight);
            }
            double biomeHeight = biomeWeight * sampler.height();
            height += biomeHeight;
            if (biome.isShore()) {
                shoreHeight += biomeHeight;
                shoreWeight += biomeWeight;
                shoreBaseHeight += biomeWeight * (double)biome.getShoreBaseHeight();
                if (!(maxShoreWeight < biomeWeight)) continue;
                shoreBiomeAt = biome;
                maxShoreWeight = biomeWeight;
                continue;
            }
            if (biome.biomeBlendType() == BiomeBlendType.OCEAN) {
                oceanHeight += biomeHeight;
                oceanWeight += biomeWeight;
                if (!(maxOceanWeight < biomeWeight)) continue;
                oceanBiomeAt = biome;
                maxOceanWeight = biomeWeight;
                continue;
            }
            normalHeight += biomeHeight;
            if (!(maxNormalWeight < biomeWeight)) continue;
            normalBiomeAt = biome;
            maxNormalWeight = biomeWeight;
        }
        biomeAt = normalBiomeAt;
        this.computeInitialShoreWeights(biomeWeights);
        double landWeight = 1.0 - oceanWeight - shoreWeight;
        if (shoreWeight > 0.0 && shoreBiomeAt != null) {
            height = this.adjustHeightForShoreContributions(height, oceanWeight, landWeight, shoreWeight, maxShoreWeight, shoreBiomeAt, shoreHeight, normalHeight);
            if (shoreWeight > 0.5) {
                biomeAt = shoreBiomeAt;
            }
        }
        if (biomeAt == null) {
            biomeAt = oceanBiomeAt;
        }
        if (oceanWeight >= 0.25) {
            double tideAdjustedSeaEdgeHeight = this.tideHeightNoise.noise(this.blockX, this.blockZ) - 4.0;
            height = Mth.clampedMap((double)landWeight, (double)0.32, (double)0.36, (double)Math.min(height, tideAdjustedSeaEdgeHeight), (double)height);
        }
        assert (biomeAt != null);
        this.computeInitialRiverWeights(biomeWeights);
        double initialCaveWeight = this.adjustWeightsForRiverCaves();
        RiverInfo info = this.sampleRiverInfo(useCache);
        height = this.adjustHeightForRiverContributions(height, info, initialCaveWeight);
        if (useCache) {
            this.updateLocalCaches(biomeWeights, biomeAt, info, height, anySaltyBiomesNearby);
        }
        return height;
    }

    protected void setupColumn(int x, int z) {
        this.blockX = x;
        this.blockZ = z;
        this.localX = x & 0xF;
        this.localZ = z & 0xF;
    }

    private void computeInitialShoreWeights(Object2DoubleMap<BiomeExtension> biomeWeights) {
        Arrays.fill(this.shoreBlendWeights, 0.0);
        for (Object2DoubleMap.Entry entry : biomeWeights.object2DoubleEntrySet()) {
            int n = ((BiomeExtension)entry.getKey()).shoreBlendType().ordinal();
            this.shoreBlendWeights[n] = this.shoreBlendWeights[n] + entry.getDoubleValue();
        }
    }

    private double adjustHeightForShoreContributions(double height, double oceanWeight, double landWeight, double shoreWeight, double thisWeight, BiomeExtension biome, double shoreHeight, double normalHeight) {
        double shoreBlendHeight = 0.0;
        for (ShoreBlendType type : ShoreBlendType.ALL) {
            double weight = this.shoreBlendWeights[type.ordinal()];
            ShoreNoiseSampler sampler = this.shoreNoiseSamplers.get((Object)type);
            if (type == ShoreBlendType.NONE) {
                shoreBlendHeight += weight * height;
                continue;
            }
            if (!(weight > 0.0)) continue;
            double newShoreHeight = sampler.setColumnAndSampleHeight(height, this.blockX, this.blockZ, oceanWeight, landWeight, shoreWeight, thisWeight, biome, shoreHeight, normalHeight);
            shoreBlendHeight += weight * newShoreHeight;
        }
        return shoreBlendHeight;
    }

    private void computeInitialRiverWeights(Object2DoubleMap<BiomeExtension> biomeWeights) {
        Arrays.fill(this.riverBlendWeights, 0.0);
        for (Object2DoubleMap.Entry entry : biomeWeights.object2DoubleEntrySet()) {
            int n = ((BiomeExtension)entry.getKey()).riverBlendType().ordinal();
            this.riverBlendWeights[n] = this.riverBlendWeights[n] + entry.getDoubleValue();
        }
    }

    private double adjustWeightsForRiverCaves() {
        double initialCaveWeight = this.riverBlendWeights[RIVER_TYPE_CAVE];
        if (initialCaveWeight > 0.0) {
            double totalWeight = 1.0 - this.riverBlendWeights[RIVER_TYPE_NONE];
            double adjustedCaveWeight = initialCaveWeight < 0.25 ? Mth.map((double)initialCaveWeight, (double)0.0, (double)0.25, (double)0.0, (double)(0.1 * totalWeight)) : totalWeight;
            for (RiverBlendType type : RiverBlendType.ALL) {
                double weight = this.riverBlendWeights[type.ordinal()];
                this.riverBlendWeights[type.ordinal()] = weight * (1.0 - adjustedCaveWeight) / (1.0 - initialCaveWeight);
            }
            this.riverBlendWeights[ChunkHeightFiller.RIVER_TYPE_CAVE] = adjustedCaveWeight;
        }
        return initialCaveWeight;
    }

    private double adjustHeightForRiverContributions(double height, @Nullable RiverInfo info, double initialCaveWeight) {
        if (info != null) {
            double riverBlendHeight = 0.0;
            for (RiverBlendType type : RiverBlendType.ALL) {
                double weight = this.riverBlendWeights[type.ordinal()];
                RiverNoiseSampler sampler = this.riverNoiseSamplers.get((Object)type);
                if (type == RiverBlendType.NONE) {
                    riverBlendHeight += weight * height;
                    continue;
                }
                if (!(weight > 0.0)) continue;
                double riverHeight = sampler.setColumnAndSampleHeight(info, this.blockX, this.blockZ, height, initialCaveWeight, weight);
                riverBlendHeight += weight * riverHeight;
            }
            return riverBlendHeight;
        }
        Arrays.fill(this.riverBlendWeights, 0.0);
        this.riverBlendWeights[ChunkHeightFiller.RIVER_TYPE_NONE] = 1.0;
        return height;
    }

    protected void updateLocalCaches(Object2DoubleMap<BiomeExtension> biomeWeights, BiomeExtension biomeAt, @Nullable RiverInfo info, double height, boolean couldBeSalty) {
    }

    @Nullable
    protected RiverInfo sampleRiverInfo(boolean useCache) {
        return this.sampleRiverEdge(this.biomeSource.getPartition(this.blockX, this.blockZ));
    }

    @Nullable
    protected final RiverInfo sampleRiverEdge(RegionPartition.Point point) {
        float limitDistInGridSq = 0.15258789f;
        double minDist = 0.152587890625;
        double minDistAdjusted = 3.4028234663852886E38;
        RiverEdge minEdge = null;
        double exactGridX = Units.blockToGridExact(this.blockX);
        double exactGridZ = Units.blockToGridExact(this.blockZ);
        for (RiverEdge edge : point.rivers()) {
            double distAdjusted;
            double dist;
            MidpointFractal fractal = edge.fractal();
            if (!fractal.maybeIntersect(exactGridX, exactGridZ, minDist) || !((dist = fractal.intersectDistance(exactGridX, exactGridZ)) < 0.152587890625) || !((distAdjusted = dist / (double)edge.widthSq()) < minDistAdjusted)) continue;
            minDist = dist;
            minDistAdjusted = distAdjusted;
            minEdge = edge;
        }
        if (minEdge != null) {
            double realWidth = minEdge.widthSq(exactGridX, exactGridZ);
            Flow flow = minEdge.fractal().calculateFlow(exactGridX, exactGridZ);
            return new RiverInfo(minEdge, flow, minDist *= 16384.0, realWidth);
        }
        return null;
    }
}

