/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import net.dries007.tfc.util.collections.IWeighted;
import net.dries007.tfc.util.collections.Weighted;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.DelegatingOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.material.Fluid;

public final class Codecs
extends ExtraCodecs {
    public static final Codec<Float> UNIT_FLOAT = Codec.floatRange((float)0.0f, (float)1.0f);
    public static final Codec<Block> BLOCK = Codecs.nonDefaultedRegistryCodec(BuiltInRegistries.BLOCK);
    public static final Codec<Fluid> FLUID = Codecs.nonDefaultedRegistryCodec(BuiltInRegistries.FLUID);
    public static final Codec<BlockState> BLOCK_STATE = Codec.either((Codec)BLOCK.xmap(Block::defaultBlockState, BlockBehaviour.BlockStateBase::getBlock), (Codec)BlockState.CODEC).xmap(e -> (BlockState)e.map(e1 -> e1, e1 -> e1), e -> e == e.getBlock().defaultBlockState() ? Either.left((Object)e) : Either.right((Object)e));
    public static final Codec<Map<Block, IWeighted<BlockState>>> BLOCK_TO_WEIGHTED_BLOCKSTATE = Codecs.mapKeyListCodec(Codec.mapPair((MapCodec)BLOCK.listOf().fieldOf("replace"), (MapCodec)Codecs.weightedCodec(BLOCK_STATE, "block").fieldOf("with")).codec());
    public static final Codec<BlockStateConfiguration> BLOCK_STATE_CONFIG = BLOCK_STATE.fieldOf("state").xmap(BlockStateConfiguration::new, c -> c.state).codec();

    public static <R> Codec<R> nonDefaultedRegistryCodec(DefaultedRegistry<R> registry) {
        return ResourceLocation.CODEC.flatXmap(id -> registry.containsKey(id) ? DataResult.success((Object)registry.get(id)) : DataResult.error(() -> "No such key: " + String.valueOf(id)), value -> registry.containsValue(value) ? DataResult.success((Object)registry.getKey(value)) : DataResult.error(() -> "No such value: " + String.valueOf(value)));
    }

    public static <F, S> Codec<Pair<F, S>> recordPairCodec(Codec<F> first, String firstKey, Codec<S> second, String secondKey) {
        return Codec.mapPair((MapCodec)first.fieldOf(firstKey), (MapCodec)second.fieldOf(secondKey)).codec();
    }

    public static <E> Codec<IWeighted<E>> weightedCodec(Codec<E> elementCodec, String elementKey) {
        return Codec.mapPair((MapCodec)elementCodec.fieldOf(elementKey), (MapCodec)Codec.DOUBLE.optionalFieldOf("weight", (Object)1.0)).codec().listOf().xmap(list -> {
            if (list.isEmpty()) {
                return IWeighted.empty();
            }
            if (list.size() == 1) {
                return IWeighted.singleton(((Pair)list.get(0)).getFirst());
            }
            return new Weighted(list);
        }, IWeighted::weightedValues);
    }

    public static <K, V> Codec<Map<K, V>> mapKeyListCodec(Codec<Pair<List<K>, V>> codec) {
        return codec.listOf().xmap(list -> {
            HashMap map = new HashMap();
            for (Pair pair : list) {
                for (Object key : (List)pair.getFirst()) {
                    map.put(key, pair.getSecond());
                }
            }
            return map;
        }, map -> {
            HashMap<Object, List> inverseMap = new HashMap<Object, List>();
            for (Map.Entry entry : map.entrySet()) {
                inverseMap.computeIfAbsent(entry.getValue(), v -> new ArrayList()).add(entry.getKey());
            }
            return inverseMap.entrySet().stream().map(e -> Pair.of((Object)((List)e.getValue()), e.getKey())).toList();
        });
    }

    public static <K, V> Codec<Map<K, V>> mapListCodec(Codec<Pair<K, V>> codec) {
        return codec.listOf().xmap(list -> list.stream().collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)), map -> map.entrySet().stream().map(e -> Pair.of(e.getKey(), e.getValue())).toList());
    }

    public static <K, V> Codec<Map<K, V>> orderPreservingUnboundedMapCodec(Codec<K> keyCodec, Codec<V> elementCodec) {
        UnboundedMapCodec baseMapCodec = Codec.unboundedMap(keyCodec, elementCodec);
        Codec asList = Codecs.recordPairCodec(keyCodec, "key", elementCodec, "value").listOf();
        return Codec.of(Codecs.orderedEncoder(baseMapCodec, asList), Codecs.orderedDecoder(Codec.either((Codec)baseMapCodec, (Codec)asList)), (String)("OrderPreservingUnboundMapCodec[" + String.valueOf(keyCodec) + " -> " + String.valueOf(elementCodec) + "]"));
    }

    private static <K, V> Encoder<Map<K, V>> orderedEncoder(final Codec<Map<K, V>> map, final Codec<List<Pair<K, V>>> list) {
        return new Encoder<Map<K, V>>(){

            public <T> DataResult<T> encode(Map<K, V> input, DynamicOps<T> ops, T prefix) {
                block3: {
                    block2: {
                        if (ops == NbtOps.INSTANCE) break block2;
                        if (!(ops instanceof DelegatingOps)) break block3;
                        DelegatingOps del = (DelegatingOps)ops;
                        if (del.delegate != NbtOps.INSTANCE) break block3;
                    }
                    return list.encode(input.entrySet().stream().map(e -> Pair.of(e.getKey(), e.getValue())).toList(), ops, prefix);
                }
                return map.encode(input, ops, prefix);
            }
        };
    }

    private static <K, V> Decoder<Map<K, V>> orderedDecoder(final Codec<Either<Map<K, V>, List<Pair<K, V>>>> eitherCodec) {
        return new Decoder<Map<K, V>>(){

            public <T> DataResult<Pair<Map<K, V>, T>> decode(DynamicOps<T> ops, T input) {
                return eitherCodec.decode(ops, input).map(pair -> pair.mapFirst(either -> (Map)either.map(Function.identity(), list -> list.stream().collect(Collector.of(LinkedHashMap::new, (map, p) -> map.put(p.getFirst(), p.getSecond()), (m1, m2) -> {
                    m1.putAll(m2);
                    return m1;
                }, new Collector.Characteristics[0])))));
            }
        };
    }
}

