/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world;

import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import org.jetbrains.annotations.Nullable;

public final class Seed {
    private final long seed;
    @Nullable
    private final XoroshiroRandomSource next;

    public static Seed of(long levelSeed) {
        return new Seed(levelSeed, new XoroshiroRandomSource(levelSeed));
    }

    public static Seed unsafeOf(long levelSeed) {
        return new Seed(levelSeed, null);
    }

    private Seed(long seed, @Nullable XoroshiroRandomSource next) {
        this.seed = seed;
        this.next = next;
    }

    public long seed() {
        return this.seed;
    }

    public long next() {
        assert (this.next != null) : "Unsafe to use next() in this context";
        return this.next.nextLong();
    }

    public RandomSource fork() {
        return new XoroshiroRandomSource(this.next(), this.next());
    }

    public Seed forkStable() {
        return Seed.of(this.seed);
    }
}

