/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.dries007.tfc.mixin.accessor.ChunkAccessAccessor;
import net.dries007.tfc.mixin.accessor.ChunkGeneratorAccessor;
import net.dries007.tfc.mixin.accessor.ChunkMapAccessor;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.BiomeNoiseSampler;
import net.dries007.tfc.world.ChunkBaseBlockSource;
import net.dries007.tfc.world.ChunkBiomeSampler;
import net.dries007.tfc.world.ChunkGeneratorExtension;
import net.dries007.tfc.world.ChunkHeightFiller;
import net.dries007.tfc.world.ChunkMapBridge;
import net.dries007.tfc.world.ChunkNoiseFiller;
import net.dries007.tfc.world.FastConcurrentCache;
import net.dries007.tfc.world.NoopClimateSampler;
import net.dries007.tfc.world.RandomStateExtension;
import net.dries007.tfc.world.Seed;
import net.dries007.tfc.world.TFCAquifer;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.biome.BiomeNoise;
import net.dries007.tfc.world.biome.BiomeSourceExtension;
import net.dries007.tfc.world.biome.TFCBiomes;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.ChunkDataGenerator;
import net.dries007.tfc.world.chunkdata.RockData;
import net.dries007.tfc.world.layer.TFCLayers;
import net.dries007.tfc.world.layer.framework.AreaFactory;
import net.dries007.tfc.world.layer.framework.ConcurrentArea;
import net.dries007.tfc.world.noise.ChunkNoiseSamplingSettings;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.noise.NoiseSampler;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.river.RiverBlendType;
import net.dries007.tfc.world.river.RiverNoiseSampler;
import net.dries007.tfc.world.settings.Settings;
import net.dries007.tfc.world.shore.ShoreBlendType;
import net.dries007.tfc.world.shore.ShoreNoiseSampler;
import net.dries007.tfc.world.surface.SurfaceManager;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.jetbrains.annotations.Nullable;

public class TFCChunkGenerator
extends ChunkGenerator
implements ChunkGeneratorExtension {
    public static final MapCodec<TFCChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BiomeSource.CODEC.comapFlatMap(TFCChunkGenerator::guardBiomeSource, BiomeSourceExtension::self).fieldOf("biome_source").forGetter(c -> c.customBiomeSource), (App)NoiseGeneratorSettings.CODEC.fieldOf("settings").forGetter(c -> c.noiseSettings), (App)Settings.CODEC.fieldOf("tfc_settings").forGetter(c -> c.settings)).apply((Applicative)instance, TFCChunkGenerator::new));
    public static final int DECORATION_STEPS = GenerationStep.Decoration.values().length;
    public static final int SEA_LEVEL_Y = 63;
    private final BiomeSourceExtension customBiomeSource;
    private final Holder<NoiseGeneratorSettings> noiseSettings;
    private Settings settings;
    private final NoiseBasedChunkGenerator stupidMojangChunkGenerator;
    private final FastConcurrentCache<TFCAquifer> aquiferCache;
    private Seed seed;
    private ChunkDataGenerator chunkDataGenerator;
    private SurfaceManager surfaceManager;
    private NoiseSampler noiseSampler;
    private Noise2D tideHeightNoise;

    private static DataResult<BiomeSourceExtension> guardBiomeSource(BiomeSource source) {
        DataResult dataResult;
        if (source instanceof BiomeSourceExtension) {
            BiomeSourceExtension s = (BiomeSourceExtension)source;
            dataResult = DataResult.success((Object)s);
        } else {
            dataResult = DataResult.error(() -> "Must be a " + BiomeSourceExtension.class.getSimpleName());
        }
        return dataResult;
    }

    public TFCChunkGenerator(BiomeSourceExtension biomeSource, Holder<NoiseGeneratorSettings> noiseSettings, Settings settings) {
        super(biomeSource.self());
        this.noiseSettings = noiseSettings;
        this.customBiomeSource = biomeSource;
        this.settings = settings;
        this.stupidMojangChunkGenerator = new NoiseBasedChunkGenerator(biomeSource.self(), noiseSettings);
        this.aquiferCache = new FastConcurrentCache(256);
    }

    @Override
    public Settings settings() {
        return this.settings;
    }

    @Override
    public void applySettings(UnaryOperator<Settings> settings) {
        this.settings = (Settings)settings.apply(this.settings);
    }

    @Override
    public ChunkDataGenerator chunkDataGenerator() {
        return this.chunkDataGenerator;
    }

    @Override
    public Aquifer getOrCreateAquifer(ChunkAccess chunk) {
        ChunkNoiseSamplingSettings settings = this.createNoiseSamplingSettingsForChunk(chunk);
        ChunkBaseBlockSource baseBlockSource = this.createBaseBlockSourceForChunk(chunk);
        return this.getOrCreateAquifer(chunk, settings, baseBlockSource);
    }

    @Override
    public void initRandomState(ChunkMap chunkMap, ServerLevel level) {
        if (this.chunkDataGenerator != null) {
            TFCChunkGenerator copy = this.copy();
            ((ChunkMapBridge)chunkMap).tfc$updateGenerator(copy);
            copy.initRandomState(chunkMap, level);
            return;
        }
        Seed seed = Seed.of(level.getSeed());
        RegionGenerator regionGenerator = new RegionGenerator(this.settings, seed);
        AreaFactory factory = TFCLayers.createRegionBiomeLayer(regionGenerator, seed);
        ConcurrentArea<BiomeExtension> biomeLayer = new ConcurrentArea<BiomeExtension>(factory, TFCLayers::getFromLayerId);
        this.seed = seed;
        this.noiseSampler = new NoiseSampler(seed.next(), (HolderGetter<NormalNoise.NoiseParameters>)level.registryAccess().lookupOrThrow(Registries.NOISE), (HolderGetter<DensityFunction>)level.registryAccess().lookupOrThrow(Registries.DENSITY_FUNCTION));
        this.chunkDataGenerator = regionGenerator.chunkDataGenerator();
        this.surfaceManager = new SurfaceManager(seed);
        this.tideHeightNoise = BiomeNoise.shoreTideLevelNoise(seed);
        this.customBiomeSource.initRandomState(regionGenerator, biomeLayer);
        ((RandomStateExtension)((ChunkMapAccessor)chunkMap).accessor$getRandomState()).tfc$setChunkGeneratorExtension(this);
    }

    public ChunkHeightFiller createHeightFillerForChunk(ChunkPos pos) {
        Object2DoubleMap<BiomeExtension>[] biomeWeights = ChunkBiomeSampler.sampleBiomes(pos, this::sampleBiomeNoRiver, BiomeExtension::biomeBlendType);
        return new ChunkHeightFiller(biomeWeights, this.customBiomeSource, this.createBiomeSamplersForChunk(null), this.createRiverSamplersForChunk(), this.createShoreSamplersForChunk(), this.getSeaLevel(), this.tideHeightNoise);
    }

    protected MapCodec<TFCChunkGenerator> codec() {
        return CODEC;
    }

    public CompletableFuture<ChunkAccess> createBiomes(RandomState randomState, Blender blender, StructureManager structureManager, ChunkAccess chunk) {
        return CompletableFuture.supplyAsync(() -> {
            this.chunkDataGenerator.generate(chunk);
            chunk.fillBiomesFromNoise((quartX, quartY, quartZ, sampler) -> this.customBiomeSource.getBiome(quartX, quartZ), NoopClimateSampler.INSTANCE);
            return chunk;
        }, Util.backgroundExecutor());
    }

    public void applyCarvers(WorldGenRegion level, long seed, RandomState state, BiomeManager biomeManager, StructureManager structureFeatureManager, ChunkAccess chunk, GenerationStep.Carving step) {
        if (step != GenerationStep.Carving.AIR) {
            return;
        }
        BiomeManager customBiomeManager = biomeManager.withDifferentSource((x, y, z) -> this.customBiomeSource.getBiome(x, z));
        PositionalRandomFactory fork = new XoroshiroRandomSource(seed).forkPositional();
        ChunkPos chunkPos = chunk.getPos();
        ChunkNoiseSamplingSettings settings = this.createNoiseSamplingSettingsForChunk(chunk);
        ChunkBaseBlockSource baseBlockSource = this.createBaseBlockSourceForChunk(chunk);
        TFCAquifer aquifer = this.getOrCreateAquifer(chunk, settings, baseBlockSource);
        CarvingContext context = new CarvingContext(this.stupidMojangChunkGenerator, null, chunk.getHeightAccessorForGeneration(), null, state, ((NoiseGeneratorSettings)this.noiseSettings.value()).surfaceRule());
        CarvingMask carvingMask = ((ProtoChunk)chunk).getOrCreateCarvingMask(step);
        for (int offsetX = -8; offsetX <= 8; ++offsetX) {
            for (int offsetZ = -8; offsetZ <= 8; ++offsetZ) {
                ChunkPos offsetChunkPos = new ChunkPos(chunkPos.x + offsetX, chunkPos.z + offsetZ);
                ChunkAccess offsetChunk = level.getChunk(offsetChunkPos.x, offsetChunkPos.z);
                Iterable iterable = offsetChunk.carverBiome(() -> ((Biome)this.customBiomeSource.getBiome(QuartPos.fromBlock((int)offsetChunkPos.getMinBlockX()), QuartPos.fromBlock((int)offsetChunkPos.getMinBlockZ())).value()).getGenerationSettings()).getCarvers(step);
                int i = 1;
                for (Holder holder : iterable) {
                    RandomSource chunkRandom = fork.at(offsetChunkPos.x, i, offsetChunkPos.z);
                    ConfiguredWorldCarver carver = (ConfiguredWorldCarver)holder.value();
                    if (carver.isStartChunk(chunkRandom)) {
                        carver.carve(context, chunk, arg_0 -> ((BiomeManager)customBiomeManager).getBiome(arg_0), chunkRandom, (Aquifer)aquifer, offsetChunkPos, carvingMask);
                    }
                    ++i;
                }
            }
        }
    }

    public void applyBiomeDecoration(WorldGenLevel level, ChunkAccess chunk, StructureManager structureFeatureManager) {
        ChunkPos chunkPos = chunk.getPos();
        SectionPos sectionPos = SectionPos.of((ChunkPos)chunkPos, (int)level.getMinSection());
        BlockPos originPos = sectionPos.origin();
        Registry structureFeatures = level.registryAccess().registryOrThrow(Registries.STRUCTURE);
        Map<Integer, List<Structure>> structureFeaturesByStep = structureFeatures.stream().collect(Collectors.groupingBy(feature -> feature.step().ordinal()));
        List<FeatureSorter.StepFeatureData> orderedFeatures = ((ChunkGeneratorAccessor)((Object)this)).accessor$getFeaturesPerStep().get();
        WorldgenRandom random = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(RandomSupport.generateUniqueSeed()));
        long baseSeed = Helpers.hash(128739412341L, originPos);
        ObjectArraySet allAdjacentBiomes = new ObjectArraySet();
        ChunkPos.rangeClosed((ChunkPos)sectionPos.chunk(), (int)1).forEach(arg_0 -> TFCChunkGenerator.lambda$applyBiomeDecoration$11(level, (Set)allAdjacentBiomes, arg_0));
        for (int decorationIndex = 0; decorationIndex < Math.max(DECORATION_STEPS, orderedFeatures.size()); ++decorationIndex) {
            if (structureFeatureManager.shouldGenerateStructures()) {
                int featureIndex = 0;
                for (Structure feature2 : structureFeaturesByStep.getOrDefault(decorationIndex, Collections.emptyList())) {
                    Helpers.seedLargeFeatures((RandomSource)random, baseSeed, featureIndex, decorationIndex);
                    structureFeatureManager.startsForStructure(sectionPos, feature2).forEach(start -> start.placeInChunk(level, structureFeatureManager, (ChunkGenerator)this, (RandomSource)random, this.getBoundingBoxForStructure(chunk), chunkPos));
                    ++featureIndex;
                }
            }
            if (decorationIndex >= orderedFeatures.size()) continue;
            IntArraySet featureIndices = new IntArraySet();
            for (Biome biome : allAdjacentBiomes) {
                List<HolderSet<PlacedFeature>> featuresPerBiome = TFCBiomes.getExtensionOrThrow((LevelAccessor)level, biome).getFlattenedFeatures(biome);
                if (decorationIndex >= featuresPerBiome.size()) continue;
                HolderSet<PlacedFeature> featuresPerBiomeAtStep = featuresPerBiome.get(decorationIndex);
                FeatureSorter.StepFeatureData stepIndex = orderedFeatures.get(decorationIndex);
                for (Holder holder : featuresPerBiomeAtStep) {
                    featureIndices.add(stepIndex.indexMapping().applyAsInt((PlacedFeature)holder.value()));
                }
            }
            int[] sortedIndices = featureIndices.toIntArray();
            FeatureSorter.StepFeatureData step = orderedFeatures.get(decorationIndex);
            Arrays.sort(sortedIndices);
            for (int featureIndex : sortedIndices) {
                Helpers.seedLargeFeatures((RandomSource)random, baseSeed, featureIndex, decorationIndex);
                ((PlacedFeature)step.features().get(featureIndex)).placeWithBiomeCheck(level, (ChunkGenerator)this, (RandomSource)random, originPos);
            }
        }
        level.setCurrentlyGenerating(null);
    }

    public void buildSurface(WorldGenRegion level, StructureManager structureFeatureManager, RandomState state, ChunkAccess chunk) {
        this.makeBedrock(chunk);
    }

    public void spawnOriginalMobs(WorldGenRegion level) {
        if (!((NoiseGeneratorSettings)this.noiseSettings.value()).disableMobGeneration()) {
            ChunkPos pos = level.getCenter();
            Holder biome = level.getBiome(pos.getWorldPosition().atY(level.getMaxBuildHeight() - 1));
            WorldgenRandom random = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(RandomSupport.generateUniqueSeed()));
            random.setDecorationSeed(level.getSeed(), pos.getMinBlockX(), pos.getMinBlockZ());
            NaturalSpawner.spawnMobsForChunkGeneration((ServerLevelAccessor)level, (Holder)biome, (ChunkPos)pos, (RandomSource)random);
        }
    }

    public BiomeSource getBiomeSource() {
        return this.customBiomeSource.self();
    }

    public int getGenDepth() {
        return ((NoiseGeneratorSettings)this.noiseSettings.value()).noiseSettings().height();
    }

    public void createStructures(RegistryAccess dynamicRegistry, ChunkGeneratorStructureState structureState, StructureManager structureFeatureManager, ChunkAccess chunk, StructureTemplateManager templateManager) {
        this.chunkDataGenerator.generate(chunk);
        super.createStructures(dynamicRegistry, structureState, structureFeatureManager, chunk, templateManager);
    }

    public void createReferences(WorldGenLevel level, StructureManager structureFeatureManager, ChunkAccess chunk) {
        super.createReferences(level, structureFeatureManager, chunk);
    }

    public CompletableFuture<ChunkAccess> fillFromNoise(Blender blender, RandomState randomState, StructureManager structureManager, ChunkAccess chunk) {
        ChunkNoiseSamplingSettings settings = this.createNoiseSamplingSettingsForChunk(chunk);
        LevelAccessor actualLevel = (LevelAccessor)((ChunkAccessAccessor)chunk).accessor$getLevelHeightAccessor();
        ChunkPos chunkPos = chunk.getPos();
        XoroshiroRandomSource random = new XoroshiroRandomSource((long)chunkPos.x * 1842639486192314L, (long)chunkPos.z * 579238196380231L);
        ChunkData chunkData = this.chunkDataGenerator.generate(chunk);
        HashSet<LevelChunkSection> sections = new HashSet<LevelChunkSection>();
        for (LevelChunkSection section : chunk.getSections()) {
            section.acquire();
            sections.add(section);
        }
        Object2DoubleMap<BiomeExtension>[] biomeWeights = ChunkBiomeSampler.sampleBiomes(chunkPos, this::sampleBiomeNoRiver, BiomeExtension::biomeBlendType);
        ChunkBaseBlockSource baseBlockSource = this.createBaseBlockSourceForChunk(chunk);
        ChunkNoiseFiller filler = new ChunkNoiseFiller((ProtoChunk)chunk, biomeWeights, this.customBiomeSource, this.createBiomeSamplersForChunk(chunk), this.createRiverSamplersForChunk(), this.createShoreSamplersForChunk(), this.noiseSampler, baseBlockSource, settings, this.getSeaLevel(), this.tideHeightNoise, Beardifier.forStructuresInChunk((StructureManager)structureManager, (ChunkPos)chunkPos));
        return CompletableFuture.supplyAsync(() -> this.lambda$fillFromNoise$13(filler, chunkData, chunkPos, sections, actualLevel, chunk, (RandomSource)random, settings), Util.backgroundExecutor());
    }

    public int getSeaLevel() {
        return 63;
    }

    public int getMinY() {
        return ((NoiseGeneratorSettings)this.noiseSettings.value()).noiseSettings().minY();
    }

    public int getBaseHeight(int x, int z, Heightmap.Types type, LevelHeightAccessor level, RandomState state) {
        ChunkPos pos = new ChunkPos(SectionPos.blockToSectionCoord((int)x), SectionPos.blockToSectionCoord((int)z));
        return (int)this.createHeightFillerForChunk(pos).sampleHeight(x, z);
    }

    public NoiseColumn getBaseColumn(int x, int z, LevelHeightAccessor level, RandomState state) {
        return new NoiseColumn(0, new BlockState[0]);
    }

    public void addDebugScreenInfo(List<String> list, RandomState state, BlockPos pos) {
    }

    private void makeBedrock(ChunkAccess chunk) {
        ChunkPos chunkPos = chunk.getPos();
        XoroshiroRandomSource random = new XoroshiroRandomSource((long)chunkPos.x * 2369412341L, (long)chunkPos.z * 8192836412341L);
        LevelChunkSection bottomSection = chunk.getSection(0);
        BlockState bedrock = Blocks.BEDROCK.defaultBlockState();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (this.settings.flatBedrock()) {
                    bottomSection.setBlockState(x, 0, z, bedrock, false);
                    continue;
                }
                for (int y = 0; y < 6; ++y) {
                    if (random.nextInt(6) >= 6 - y) continue;
                    bottomSection.setBlockState(x, y, z, bedrock, false);
                }
            }
        }
    }

    private BoundingBox getBoundingBoxForStructure(ChunkAccess chunk) {
        ChunkPos pos = chunk.getPos();
        int blockX = pos.getMinBlockX();
        int blockZ = pos.getMinBlockZ();
        LevelHeightAccessor level = chunk.getHeightAccessorForGeneration();
        return new BoundingBox(blockX, level.getMinBuildHeight() + 1, blockZ, blockX + 15, level.getMaxBuildHeight() - 1, blockZ + 15);
    }

    private BiomeExtension sampleBiomeNoRiver(int blockX, int blockZ) {
        return this.customBiomeSource.getBiomeExtensionNoRiver(QuartPos.fromBlock((int)blockX), QuartPos.fromBlock((int)blockZ));
    }

    private ChunkBaseBlockSource createBaseBlockSourceForChunk(ChunkAccess chunk) {
        RockData rockData = ChunkData.get(chunk).getRockData();
        return new ChunkBaseBlockSource(rockData, this::sampleBiomeNoRiver);
    }

    private ChunkNoiseSamplingSettings createNoiseSamplingSettingsForChunk(ChunkAccess chunk) {
        return this.createNoiseSamplingSettingsForChunk(chunk.getPos(), chunk.getHeightAccessorForGeneration());
    }

    private ChunkNoiseSamplingSettings createNoiseSamplingSettingsForChunk(ChunkPos pos, LevelHeightAccessor level) {
        NoiseSettings noiseSettings = ((NoiseGeneratorSettings)this.noiseSettings.value()).noiseSettings();
        int cellWidth = noiseSettings.getCellWidth();
        int cellHeight = noiseSettings.getCellHeight();
        int minY = Math.max(noiseSettings.minY(), level.getMinBuildHeight());
        int maxY = Math.min(noiseSettings.minY() + noiseSettings.height(), level.getMaxBuildHeight());
        int cellCountY = Math.floorDiv(maxY - minY, noiseSettings.getCellHeight());
        int firstCellX = Math.floorDiv(pos.getMinBlockX(), cellWidth);
        int firstCellY = Math.floorDiv(minY, cellHeight);
        int firstCellZ = Math.floorDiv(pos.getMinBlockZ(), cellWidth);
        return new ChunkNoiseSamplingSettings(minY, 16 / cellWidth, cellCountY, cellWidth, cellHeight, firstCellX, firstCellY, firstCellZ);
    }

    private TFCAquifer getOrCreateAquifer(ChunkAccess chunk, ChunkNoiseSamplingSettings settings, ChunkBaseBlockSource baseBlockSource) {
        ChunkPos chunkPos = chunk.getPos();
        TFCAquifer aquifer = this.aquiferCache.getIfPresent(chunkPos.x, chunkPos.z);
        if (aquifer == null) {
            ChunkData chunkData = ChunkData.get(chunk);
            aquifer = new TFCAquifer(chunkPos, settings, baseBlockSource, this.getSeaLevel(), this.noiseSampler.positionalRandomFactory, this.noiseSampler.barrierNoise);
            aquifer.setSurfaceHeights(chunkData.getAquiferSurfaceHeight());
            this.aquiferCache.set(chunkPos.x, chunkPos.z, aquifer);
        }
        return aquifer;
    }

    private Map<BiomeExtension, BiomeNoiseSampler> createBiomeSamplersForChunk(@Nullable ChunkAccess chunk) {
        Seed noiseSamplerSeed = this.seed.forkStable();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BiomeExtension extension : TFCBiomes.REGISTRY) {
            BiomeNoiseSampler sampler = extension.createNoiseSampler(noiseSamplerSeed);
            if (sampler == null) continue;
            sampler.prepare(this, chunk);
            builder.put((Object)extension, (Object)sampler);
        }
        return builder.build();
    }

    private Map<RiverBlendType, RiverNoiseSampler> createRiverSamplersForChunk() {
        Seed noiseSamplerSeed = this.seed.forkStable();
        EnumMap<RiverBlendType, RiverNoiseSampler> builder = new EnumMap<RiverBlendType, RiverNoiseSampler>(RiverBlendType.class);
        for (RiverBlendType blendType : RiverBlendType.ALL) {
            builder.put(blendType, blendType.createNoiseSampler(noiseSamplerSeed));
        }
        return builder;
    }

    private Map<ShoreBlendType, ShoreNoiseSampler> createShoreSamplersForChunk() {
        Seed noiseSamplerSeed = this.seed.forkStable();
        EnumMap<ShoreBlendType, ShoreNoiseSampler> builder = new EnumMap<ShoreBlendType, ShoreNoiseSampler>(ShoreBlendType.class);
        for (ShoreBlendType blendType : ShoreBlendType.ALL) {
            builder.put(blendType, blendType.createNoiseSampler(noiseSamplerSeed));
        }
        return builder;
    }

    private TFCChunkGenerator copy() {
        return new TFCChunkGenerator(this.customBiomeSource.copy(), this.noiseSettings, this.settings);
    }

    private /* synthetic */ ChunkAccess lambda$fillFromNoise$13(ChunkNoiseFiller filler, ChunkData chunkData, ChunkPos chunkPos, Set sections, LevelAccessor actualLevel, ChunkAccess chunk, RandomSource random, ChunkNoiseSamplingSettings settings) {
        filler.sampleAquiferSurfaceHeight(this::sampleBiomeNoRiver);
        chunkData.generateFull(filler.surfaceHeight(), filler.aquifer().surfaceHeights());
        chunkData.getRockData().useCache(chunkPos);
        filler.fillFromNoise();
        chunkData.modifyBaseGroundwater(filler.surfaceHeight());
        this.aquiferCache.set(chunkPos.x, chunkPos.z, filler.aquifer());
        sections.forEach(LevelChunkSection::release);
        this.surfaceManager.buildSurface(actualLevel, chunk, this.rockLayerSettings(), chunkData, filler.localBiomes(), filler.localBiomesNoRivers(), filler.localBiomeWeights(), filler.createSlopeMap(), random, this.getSeaLevel(), settings.minY());
        return chunk;
    }

    private static /* synthetic */ void lambda$applyBiomeDecoration$11(WorldGenLevel level, Set allAdjacentBiomes, ChunkPos chunkPos1_) {
        ChunkAccess adjChunk = level.getChunk(chunkPos1_.x, chunkPos1_.z);
        for (LevelChunkSection adjSection : adjChunk.getSections()) {
            adjSection.getBiomes().getAll(biome -> allAdjacentBiomes.add((Biome)biome.value()));
        }
    }
}

