/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.biome.BiomeSourceExtension;
import net.dries007.tfc.world.biome.TFCBiomes;
import net.dries007.tfc.world.layer.framework.ConcurrentArea;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.RegionPartition;
import net.dries007.tfc.world.region.Units;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import org.jetbrains.annotations.Nullable;

public class RegionBiomeSource
extends BiomeSource
implements BiomeSourceExtension {
    public static final MapCodec<RegionBiomeSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryOps.retrieveGetter((ResourceKey)Registries.BIOME)).apply((Applicative)instance, RegionBiomeSource::new));
    private final HolderGetter<Biome> biomeRegistry;
    private RegionGenerator regionGenerator;
    private ConcurrentArea<BiomeExtension> biomeLayer;

    public RegionBiomeSource(HolderGetter<Biome> biomeRegistry) {
        this.biomeRegistry = biomeRegistry;
    }

    @Override
    public BiomeExtension getBiomeExtensionNoRiver(int quartX, int quartZ) {
        return this.biomeLayer.get(quartX, quartZ);
    }

    @Override
    public Holder<Biome> getBiomeFromExtension(BiomeExtension extension) {
        return this.biomeRegistry.getOrThrow(extension.key());
    }

    @Override
    public RegionPartition.Point getPartition(int blockX, int blockZ) {
        return this.regionGenerator.getOrCreatePartitionPoint(Units.blockToGrid(blockX), Units.blockToGrid(blockZ));
    }

    @Override
    public void initRandomState(RegionGenerator regionGenerator, ConcurrentArea<BiomeExtension> biomeLayer) {
        this.regionGenerator = regionGenerator;
        this.biomeLayer = biomeLayer;
    }

    @Override
    public BiomeSourceExtension copy() {
        return new RegionBiomeSource(this.biomeRegistry);
    }

    protected MapCodec<? extends BiomeSource> codec() {
        return CODEC;
    }

    protected Stream<Holder<Biome>> collectPossibleBiomes() {
        return TFCBiomes.REGISTRY.stream().map(e -> this.biomeRegistry.getOrThrow(e.key()));
    }

    public Holder<Biome> getNoiseBiome(int quartX, int quartY, int quartZ, @Nullable Climate.Sampler sampler) {
        return this.getBiome(quartX, quartZ);
    }
}

