/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.biome;

import java.util.Objects;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.biome.BiomeBlendType;
import net.dries007.tfc.world.biome.BiomeBridge;
import net.dries007.tfc.world.biome.BiomeBuilder;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.biome.BiomeNoise;
import net.dries007.tfc.world.river.RiverBlendType;
import net.dries007.tfc.world.shore.ShoreBlendType;
import net.dries007.tfc.world.surface.builder.BadlandsSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.BurrenSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.DuneSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.FlatsSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.GrassyDunesSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.IceSheetShieldVolcanoSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.IceSheetSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.LowlandsSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.NormalSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.PatternedGroundSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.RiverSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.RockyPlateauSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.ShieldVolcanoSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.ShilinSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.ShoreAndOceanSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SimpleSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.StoneCirclesSurfaceBuilder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class TFCBiomes {
    public static final ResourceKey<Registry<BiomeExtension>> KEY = ResourceKey.createRegistryKey((ResourceLocation)Helpers.identifier("biome_extension"));
    public static final Registry<BiomeExtension> REGISTRY = new RegistryBuilder(KEY).create();
    public static final DeferredRegister<BiomeExtension> EXTENSIONS = DeferredRegister.create(KEY, (String)"tfc");
    public static final BiomeExtension OCEAN = TFCBiomes.register("ocean", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.ocean(seed, -26, -12)).surface(ShoreAndOceanSurfaceBuilder.OCEAN).aquiferHeightOffset(-24.0).salty().type(BiomeBlendType.OCEAN).noRivers());
    public static final BiomeExtension OCEAN_REEF = TFCBiomes.register("ocean_reef", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.ocean(seed, -16, -8)).surface(ShoreAndOceanSurfaceBuilder.OCEAN).aquiferHeightOffset(-24.0).salty().type(BiomeBlendType.OCEAN).noRivers());
    public static final BiomeExtension DEEP_OCEAN = TFCBiomes.register("deep_ocean", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.ocean(seed, -30, -16)).surface(ShoreAndOceanSurfaceBuilder.OCEAN).aquiferHeightOffset(-24.0).type(BiomeBlendType.OCEAN).salty().noRivers());
    public static final BiomeExtension DEEP_OCEAN_TRENCH = TFCBiomes.register("deep_ocean_trench", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.oceanRidge(seed, -30, -16)).surface(ShoreAndOceanSurfaceBuilder.OCEAN).aquiferHeightOffset(-24.0).type(BiomeBlendType.OCEAN).salty().noRivers());
    public static final BiomeExtension PLAINS = TFCBiomes.register("plains", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.hills(seed, 4, 10)).surface(NormalSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.FLOODPLAIN));
    public static final BiomeExtension HILLS = TFCBiomes.register("hills", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.hills(seed, -5, 16)).surface(NormalSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.FLOODPLAIN));
    public static final BiomeExtension LOWLANDS = TFCBiomes.register("lowlands", BiomeBuilder.builder().heightmap(BiomeNoise::lowlands).surface(LowlandsSurfaceBuilder.INSTANCE).aquiferHeightOffset(-16.0).spawnable().type(RiverBlendType.BANKED).noSandyRiverShores());
    public static final BiomeExtension SALT_MARSH = TFCBiomes.register("salt_marsh", BiomeBuilder.builder().heightmap(BiomeNoise::lowlands).surface(LowlandsSurfaceBuilder.INSTANCE).aquiferHeightOffset(-16.0).spawnable().salty().type(RiverBlendType.BANKED).noSandyRiverShores());
    public static final BiomeExtension LOW_CANYONS = TFCBiomes.register("low_canyons", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.canyons(seed, -8, 21)).surface(NormalSurfaceBuilder.INSTANCE).aquiferHeightOffset(-16.0).spawnable().type(RiverBlendType.WIDE).noSandyRiverShores());
    public static final BiomeExtension ROLLING_HILLS = TFCBiomes.register("rolling_hills", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.hills(seed, -5, 28)).surface(NormalSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.CANYON));
    public static final BiomeExtension HIGHLANDS = TFCBiomes.register("highlands", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.sharpHills(seed, -3.0f, 28.0f)).surface(NormalSurfaceBuilder.ROCKY).spawnable().type(RiverBlendType.CANYON));
    public static final BiomeExtension BADLANDS = TFCBiomes.register("badlands", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.badlands(seed, 22, 19.5f)).surface(BadlandsSurfaceBuilder.NORMAL).spawnable().type(RiverBlendType.CANYON));
    public static final BiomeExtension PLATEAU = TFCBiomes.register("plateau", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.hills(seed, 20, 30)).surface(NormalSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.TALL_CANYON).noSandyRiverShores());
    public static final BiomeExtension PLATEAU_WIDE = TFCBiomes.register("plateau_wide", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.hills(seed, 20, 30)).surface(NormalSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.TALUS).noSandyRiverShores());
    public static final BiomeExtension CANYONS = TFCBiomes.register("canyons", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.canyons(seed, -2, 40)).surface(SimpleSurfaceBuilder.VOLCANIC_SOIL).volcanoes(6, 14, 30, 28).spawnable().type(RiverBlendType.CANYON).noSandyRiverShores());
    public static final BiomeExtension MOUNTAINS = TFCBiomes.register("mountains", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.mountains(seed, 10, 70)).surface(NormalSurfaceBuilder.ROCKY).spawnable().type(RiverBlendType.CAVE));
    public static final BiomeExtension OLD_MOUNTAINS = TFCBiomes.register("old_mountains", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.mountains(seed, 16, 40)).surface(NormalSurfaceBuilder.ROCKY).spawnable().type(RiverBlendType.CAVE));
    public static final BiomeExtension OCEANIC_MOUNTAINS = TFCBiomes.register("oceanic_mountains", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.mountains(seed, -16, 60)).surface(ShoreAndOceanSurfaceBuilder.MOUNTAINS).aquiferHeightOffset(-8.0).salty().spawnable().type(RiverBlendType.CAVE));
    public static final BiomeExtension VOLCANIC_MOUNTAINS = TFCBiomes.register("volcanic_mountains", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.mountains(seed, 10, 60)).surface(SimpleSurfaceBuilder.ROCKY_VOLCANIC_SOIL).volcanoes(4, 25, 50, 40).type(RiverBlendType.CAVE));
    public static final BiomeExtension VOLCANIC_OCEANIC_MOUNTAINS = TFCBiomes.register("volcanic_oceanic_mountains", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.mountains(seed, -24, 50)).surface(ShoreAndOceanSurfaceBuilder.VOLCANIC_MOUNTAINS).aquiferHeightOffset(-8.0).salty().volcanoes(2, -12, 50, 20).type(RiverBlendType.CAVE));
    public static final BiomeExtension GUANO_ISLAND = TFCBiomes.register("guano_island", BiomeBuilder.builder().heightmap(BiomeNoise::rockyIslands).surface(ShoreAndOceanSurfaceBuilder.ROCKY_SHORE).spawnable().type(RiverBlendType.CAVE).noSandyRiverShores().salty());
    public static final BiomeExtension SHORE = TFCBiomes.register("shore", BiomeBuilder.builder().heightmap(BiomeNoise::shore).surface(ShoreAndOceanSurfaceBuilder.SANDY).aquiferHeightOffset(-16.0).type(BiomeBlendType.LAND).salty().shore().type(RiverBlendType.WIDE).noRivers().noSandyRiverShores().type(ShoreBlendType.SANDY).setShoreBaseHeight(-4));
    public static final BiomeExtension TIDAL_FLATS = TFCBiomes.register("tidal_flats", BiomeBuilder.builder().heightmap(BiomeNoise::shore).surface(ShoreAndOceanSurfaceBuilder.SANDY).aquiferHeightOffset(-16.0).type(BiomeBlendType.OCEAN).salty().shore().type(RiverBlendType.WIDE).noRivers().noSandyRiverShores().type(ShoreBlendType.SANDY).setShoreBaseHeight(-4));
    public static final BiomeExtension SEA_STACKS = TFCBiomes.register("sea_stacks", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.hills(seed, 10, 30)).surface(ShoreAndOceanSurfaceBuilder.SEA_CLIFFS).aquiferHeightOffset(-40.0).type(BiomeBlendType.LAND).salty().shore().type(RiverBlendType.TALL_CANYON).noRivers().noSandyRiverShores().type(ShoreBlendType.SEA_STACKS).setShoreBaseHeight(-6));
    public static final BiomeExtension TERRACE_UPPER = TFCBiomes.register("terrace_upper", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.constant(0)).surface(ShoreAndOceanSurfaceBuilder.SEA_CLIFFS).aquiferHeightOffset(-40.0).type(BiomeBlendType.LAND).salty().shore().type(RiverBlendType.TALL_CANYON).noRivers().noSandyRiverShores().type(ShoreBlendType.UPPER_TERRACE));
    public static final BiomeExtension TERRACE_LOWER = TFCBiomes.register("terrace_lower", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.constant(0)).surface(ShoreAndOceanSurfaceBuilder.SEA_CLIFFS).aquiferHeightOffset(-40.0).type(BiomeBlendType.LAND).salty().shore().type(RiverBlendType.TALL_CANYON).noRivers().noSandyRiverShores().type(ShoreBlendType.LOWER_TERRACE));
    public static final BiomeExtension SETBACK_CLIFFS = TFCBiomes.register("setback_cliffs", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.hills(seed, 20, 30)).surface(ShoreAndOceanSurfaceBuilder.SANDY).aquiferHeightOffset(-40.0).type(BiomeBlendType.LAND).salty().shore().type(RiverBlendType.CANYON).noRivers().noSandyRiverShores().type(ShoreBlendType.SETBACK_CLIFFS));
    public static final BiomeExtension COASTAL_DUNES = TFCBiomes.register("coastal_dunes", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.constant(0)).surface(ShoreAndOceanSurfaceBuilder.SANDY).aquiferHeightOffset(-40.0).type(BiomeBlendType.LAND).salty().shore().type(RiverBlendType.WIDE_DEEP).noRivers().noSandyRiverShores().type(ShoreBlendType.DUNES));
    public static final BiomeExtension ROCKY_SHORES = TFCBiomes.register("rocky_shores", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.constant(-15)).surface(ShoreAndOceanSurfaceBuilder.ROCKY_SHORE).aquiferHeightOffset(-40.0).type(BiomeBlendType.LAND).salty().shore().type(RiverBlendType.CANYON).noRivers().noSandyRiverShores().type(ShoreBlendType.ROCKY_SHORES));
    public static final BiomeExtension EMBAYMENTS = TFCBiomes.register("embayments", BiomeBuilder.builder().heightmap(BiomeNoise::shore).surface(ShoreAndOceanSurfaceBuilder.SEA_CLIFFS).aquiferHeightOffset(-40.0).type(BiomeBlendType.LAND).salty().shore().type(RiverBlendType.CANYON).noRivers().noSandyRiverShores().type(ShoreBlendType.EMBAYMENTS));
    public static final BiomeExtension LAKE = TFCBiomes.register("lake", BiomeBuilder.builder().heightmap(BiomeNoise::lake).surface(NormalSurfaceBuilder.INSTANCE).aquiferHeightOffset(-16.0).type(BiomeBlendType.LAKE).type(RiverBlendType.WIDE).noRivers());
    public static final BiomeExtension RIVER = TFCBiomes.register("river", BiomeBuilder.builder().surface(RiverSurfaceBuilder.INSTANCE));
    public static final BiomeExtension MOUNTAIN_LAKE = TFCBiomes.register("mountain_lake", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.mountains(seed, 10, 70)).surface(NormalSurfaceBuilder.ROCKY).carving(BiomeNoise::undergroundLakes).type(BiomeBlendType.LAKE).noRivers());
    public static final BiomeExtension OLD_MOUNTAIN_LAKE = TFCBiomes.register("old_mountain_lake", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.mountains(seed, -16, 60)).surface(NormalSurfaceBuilder.ROCKY).carving(BiomeNoise::undergroundLakes).type(BiomeBlendType.LAKE).noRivers());
    public static final BiomeExtension OCEANIC_MOUNTAIN_LAKE = TFCBiomes.register("oceanic_mountain_lake", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.mountains(seed, -16, 60)).surface(ShoreAndOceanSurfaceBuilder.MOUNTAINS).carving(BiomeNoise::undergroundLakes).salty().type(BiomeBlendType.LAKE).noRivers());
    public static final BiomeExtension VOLCANIC_MOUNTAIN_LAKE = TFCBiomes.register("volcanic_mountain_lake", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.mountains(seed, 10, 60)).surface(SimpleSurfaceBuilder.ROCKY_VOLCANIC_SOIL).volcanoes(4, 25, 50, 40).carving(BiomeNoise::undergroundLakes).type(BiomeBlendType.LAKE).noRivers());
    public static final BiomeExtension VOLCANIC_OCEANIC_MOUNTAIN_LAKE = TFCBiomes.register("volcanic_oceanic_mountain_lake", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.mountains(seed, -24, 50)).surface(ShoreAndOceanSurfaceBuilder.VOLCANIC_MOUNTAINS).volcanoes(2, -12, 50, 20).carving(BiomeNoise::undergroundLakes).salty().type(BiomeBlendType.LAKE).noRivers());
    public static final BiomeExtension PLATEAU_LAKE = TFCBiomes.register("plateau_lake", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.hills(seed, 20, 30)).surface(NormalSurfaceBuilder.INSTANCE).carving(BiomeNoise::undergroundLakes).type(BiomeBlendType.LAKE).noRivers());
    public static final BiomeExtension MUD_FLATS = TFCBiomes.register("mud_flats", BiomeBuilder.builder().heightmap(BiomeNoise::flats).surface(FlatsSurfaceBuilder.MUDDY).aquiferHeightOffset(-16.0).spawnable().type(RiverBlendType.TALL_BANKED).noSandyRiverShores());
    public static final BiomeExtension SALT_FLATS = TFCBiomes.register("salt_flats", BiomeBuilder.builder().heightmap(BiomeNoise::saltFlats).surface(FlatsSurfaceBuilder.SALTY).aquiferHeightOffset(-16.0).salty().spawnable().type(RiverBlendType.TALL_BANKED).noSandyRiverShores());
    public static final BiomeExtension DUNE_SEA = TFCBiomes.register("dune_sea", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.dunes(seed, 2, 16)).surface(DuneSurfaceBuilder.INSTANCE).aquiferHeightOffset(-16.0).spawnable().type(RiverBlendType.WIDE));
    public static final BiomeExtension GRASSY_DUNES = TFCBiomes.register("grassy_dunes", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.dunes(seed, 2, 16)).surface(GrassyDunesSurfaceBuilder.INSTANCE).aquiferHeightOffset(-16.0).spawnable().type(RiverBlendType.WIDE));
    public static final BiomeExtension WHORLED_CANYONS = TFCBiomes.register("whorled_canyons", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.canyons(seed, 8, 60)).surface(BadlandsSurfaceBuilder.WARPED).aquiferHeightOffset(-16.0).spawnable().type(RiverBlendType.TALL_CANYON));
    public static final BiomeExtension STAIR_STEP_CANYONS = TFCBiomes.register("stair_step_canyons", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.stairCanyons(seed)).surface(BadlandsSurfaceBuilder.MESAS).aquiferHeightOffset(-16.0).spawnable().type(RiverBlendType.TERRACES));
    public static final BiomeExtension MESAS = TFCBiomes.register("mesas", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.mesas(seed)).surface(BadlandsSurfaceBuilder.MESAS).aquiferHeightOffset(-16.0).spawnable().type(RiverBlendType.TERRACES));
    public static final BiomeExtension BUTTES = TFCBiomes.register("buttes", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.buttes(seed)).surface(BadlandsSurfaceBuilder.MESAS).aquiferHeightOffset(-16.0).spawnable().type(RiverBlendType.TERRACES));
    public static final BiomeExtension HOODOOS = TFCBiomes.register("hoodoos", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.hoodoos(seed)).surface(BadlandsSurfaceBuilder.HOODOOS).aquiferHeightOffset(-16.0).spawnable().type(RiverBlendType.TERRACES));
    public static final BiomeExtension ROCKY_PLATEAU = TFCBiomes.register("rocky_plateau", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.bowlDolines(seed, BiomeNoise.hills(seed, 22, 32), 16.0).max(BiomeNoise.canyons(seed, 0, 52).spread(1.5))).surface(RockyPlateauSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.TALUS).noSandyRiverShores());
    public static final BiomeExtension TOWER_KARST_PLAINS = TFCBiomes.register("tower_karst_plains", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.fenglin(seed, BiomeNoise.hills(seed, 4, 8), 40.0)).surface(NormalSurfaceBuilder.ROCKY).spawnable().type(RiverBlendType.TALL_CANYON));
    public static final BiomeExtension TOWER_KARST_CANYONS = TFCBiomes.register("tower_karst_canyons", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.fengcong(seed, BiomeNoise.canyons(seed, -2, 30))).surface(NormalSurfaceBuilder.ROCKY).spawnable().type(RiverBlendType.TALL_CANYON).noSandyRiverShores());
    public static final BiomeExtension TOWER_KARST_HILLS = TFCBiomes.register("tower_karst_hills", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.fengcong(seed, BiomeNoise.hills(seed, -5, 22))).surface(NormalSurfaceBuilder.ROCKY).spawnable().type(RiverBlendType.TALL_CANYON));
    public static final BiomeExtension TOWER_KARST_HIGHLANDS = TFCBiomes.register("tower_karst_highlands", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.fengcong(seed, BiomeNoise.sharpHills(seed, 0.0f, 20.0f))).surface(NormalSurfaceBuilder.ROCKY).spawnable().type(RiverBlendType.TALL_CANYON));
    public static final BiomeExtension TOWER_KARST_LAKE = TFCBiomes.register("tower_karst_lake", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.fenglin(seed, BiomeNoise.hills(seed, -12, -4), 50.0)).surface(NormalSurfaceBuilder.ROCKY).aquiferHeightOffset(-16.0).spawnable().type(RiverBlendType.TALL_CANYON).noSandyRiverShores());
    public static final BiomeExtension TOWER_KARST_BAY = TFCBiomes.register("tower_karst_bay", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.fenglin(seed, BiomeNoise.hills(seed, -18, -8), 50.0)).surface(NormalSurfaceBuilder.ROCKY).aquiferHeightOffset(-16.0).spawnable().salty().type(RiverBlendType.TALL_CANYON).noSandyRiverShores());
    public static final BiomeExtension BURREN_PLATEAU = TFCBiomes.register("burren_plateau", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.burren(seed, BiomeNoise.hills(seed, 22, 32), 1.4)).surface(BurrenSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.TALL_CANYON).noSandyRiverShores());
    public static final BiomeExtension BURREN_BADLANDS = TFCBiomes.register("burren_badlands", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.burren(seed, BiomeNoise.badlands(seed, 22, 19.5f), 1.0)).surface(BurrenSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.CANYON).noSandyRiverShores());
    public static final BiomeExtension BURREN_BADLANDS_TALL = TFCBiomes.register("burren_badlands_tall", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.burren(seed, BiomeNoise.badlands(seed, 35, 33.0f), 1.0)).surface(BurrenSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.TALL_CANYON).noSandyRiverShores());
    public static final BiomeExtension BURREN_PLAINS = TFCBiomes.register("burren_plains", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.burren(seed, BiomeNoise.hills(seed, 6, 12), 1.5)).surface(BurrenSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.WIDE).noSandyRiverShores());
    public static final BiomeExtension BURREN_ROCHE_MOUTONEE = TFCBiomes.register("burren_roche_moutonee", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.burren(seed, BiomeNoise.drumlins(seed), 1.5)).surface(BurrenSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.WIDE).noSandyRiverShores());
    public static final BiomeExtension SHILIN_PLAINS = TFCBiomes.register("shilin_plains", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.shilin(seed, BiomeNoise.hills(seed, 4, 10), 28.0)).surface(ShilinSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.WIDE));
    public static final BiomeExtension SHILIN_CANYONS = TFCBiomes.register("shilin_canyons", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.shilin(seed, BiomeNoise.canyons(seed, -2, 30), 26.0)).surface(ShilinSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.WIDE));
    public static final BiomeExtension SHILIN_HILLS = TFCBiomes.register("shilin_hills", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.shilin(seed, BiomeNoise.hills(seed, -2, 16), 26.0)).surface(ShilinSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.WIDE));
    public static final BiomeExtension SHILIN_HIGHLANDS = TFCBiomes.register("shilin_highlands", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.shilin(seed, BiomeNoise.sharpHills(seed, 0.0f, 32.0f), 32.0)).surface(ShilinSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.WIDE));
    public static final BiomeExtension SHILIN_PLATEAU = TFCBiomes.register("shilin_plateau", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.shilin(seed, BiomeNoise.hills(seed, 12, 22), 32.0)).surface(ShilinSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.WIDE));
    public static final BiomeExtension DOLINE_PLAINS = TFCBiomes.register("doline_plains", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.bowlDolines(seed, BiomeNoise.hills(seed, 4, 10), 6.0)).surface(NormalSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.FLOODPLAIN));
    public static final BiomeExtension DOLINE_HILLS = TFCBiomes.register("doline_hills", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.bowlDolines(seed, BiomeNoise.hills(seed, -5, 16), 10.0)).surface(NormalSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.WIDE));
    public static final BiomeExtension DOLINE_ROLLING_HILLS = TFCBiomes.register("doline_rolling_hills", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.bowlDolines(seed, BiomeNoise.hills(seed, -5, 28), 18.0)).surface(NormalSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.CANYON));
    public static final BiomeExtension DOLINE_HIGHLANDS = TFCBiomes.register("doline_highlands", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.bowlDolines(seed, BiomeNoise.sharpHills(seed, -3.0f, 20.0f), 22.0)).surface(NormalSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.CANYON));
    public static final BiomeExtension DOLINE_PLATEAU = TFCBiomes.register("doline_plateau", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.bowlDolines(seed, BiomeNoise.hills(seed, 22, 32), 22.0)).surface(NormalSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.TALL_CANYON).noSandyRiverShores());
    public static final BiomeExtension DOLINE_CANYONS = TFCBiomes.register("doline_canyons", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.bowlDolines(seed, BiomeNoise.canyons(seed, -2, 34), 15.0)).surface(SimpleSurfaceBuilder.VOLCANIC_SOIL).volcanoes(6, 14, 30, 28).spawnable().type(RiverBlendType.CANYON).noSandyRiverShores());
    public static final BiomeExtension CENOTE_PLAINS = TFCBiomes.register("cenote_plains", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.cenotes(seed, BiomeNoise.hills(seed, 4, 10), 11.0, 8.0)).surface(NormalSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.FLOODPLAIN));
    public static final BiomeExtension CENOTE_HILLS = TFCBiomes.register("cenote_hills", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.cenotes(seed, BiomeNoise.hills(seed, -5, 16), 16.0, 10.0)).surface(NormalSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.WIDE));
    public static final BiomeExtension CENOTE_ROLLING_HILLS = TFCBiomes.register("cenote_rolling_hills", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.cenotes(seed, BiomeNoise.hills(seed, -5, 28), 22.0, 14.0)).surface(NormalSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.CANYON));
    public static final BiomeExtension CENOTE_CANYONS = TFCBiomes.register("cenote_canyons", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.cenotes(seed, BiomeNoise.canyons(seed, 2, 28), 18.0, 10.0)).surface(NormalSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.CANYON).noSandyRiverShores());
    public static final BiomeExtension CENOTE_HIGHLANDS = TFCBiomes.register("cenote_highlands", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.cenotes(seed, BiomeNoise.sharpHills(seed, 0.0f, 24.0f), 20.0, 10.0)).surface(NormalSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.TALL_CANYON).noSandyRiverShores());
    public static final BiomeExtension CENOTE_PLATEAU = TFCBiomes.register("cenote_plateau", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.cenotes(seed, BiomeNoise.hills(seed, 20, 30), 22.0, 20.0)).surface(NormalSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.TALL_CANYON).noSandyRiverShores());
    public static final BiomeExtension EXTREME_DOLINE_PLATEAU = TFCBiomes.register("extreme_doline_plateau", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.tiankeng(seed, BiomeNoise.hills(seed, 24, 34))).surface(NormalSurfaceBuilder.ROCKY).spawnable().type(RiverBlendType.TALL_CANYON));
    public static final BiomeExtension EXTREME_DOLINE_MOUNTAINS = TFCBiomes.register("extreme_doline_mountains", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.tiankeng(seed, BiomeNoise.mountains(seed, 16, 40))).surface(NormalSurfaceBuilder.ROCKY).spawnable().type(RiverBlendType.CAVE));
    public static final BiomeExtension ACTIVE_SHIELD_VOLCANO = TFCBiomes.register("active_shield_volcano", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.activeShieldVolcano(seed, BiomeNoise.activeHotSpots(seed))).surface(ShieldVolcanoSurfaceBuilder.ACTIVE).volcanoes(4, 15, 25, 28, true).aquiferHeightOffset(-16.0).spawnable().type(RiverBlendType.CAVE));
    public static final BiomeExtension DORMANT_SHIELD_VOLCANO = TFCBiomes.register("dormant_shield_volcano", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.dormantShieldVolcano(seed, BiomeNoise.dormantHotSpots(seed))).surface(ShieldVolcanoSurfaceBuilder.DORMANT).tuffRings(2, 0, 36).aquiferHeightOffset(-16.0).spawnable().type(RiverBlendType.CAVE));
    public static final BiomeExtension EXTINCT_SHIELD_VOLCANO = TFCBiomes.register("extinct_shield_volcano", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.extinctShieldVolcano(seed, BiomeNoise.extinctHotSpots(seed))).surface(ShieldVolcanoSurfaceBuilder.DORMANT).tuffRings(2, 0, 26).aquiferHeightOffset(-16.0).spawnable().type(RiverBlendType.CAVE));
    public static final BiomeExtension ANCIENT_SHIELD_VOLCANO = TFCBiomes.register("ancient_shield_volcano", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.ancientShieldVolcano(seed, 90.0, 130.0, BiomeNoise.ancientHotSpots(seed))).surface(ShieldVolcanoSurfaceBuilder.DORMANT).tuffRings(3, -16, 30).aquiferHeightOffset(-16.0).spawnable().type(RiverBlendType.CAVE));
    public static final BiomeExtension SUNKEN_SHIELD_VOLCANO = TFCBiomes.register("sunken_shield_volcano", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.sunkenShieldVolcano(seed, BiomeNoise.ancientHotSpots(seed))).surface(ShieldVolcanoSurfaceBuilder.DORMANT).tuffRings(3, -8, 24).aquiferHeightOffset(-16.0).spawnable().salty().type(RiverBlendType.CAVE));
    public static final BiomeExtension SHIELD_VOLCANO_SHORE = TFCBiomes.register("shield_volcano_shore", BiomeBuilder.builder().heightmap(BiomeNoise::shore).surface(ShoreAndOceanSurfaceBuilder.ACTIVE_SHIELD_VOLCANO).spawnable().salty().shore().type(RiverBlendType.TALL_CANYON).type(ShoreBlendType.EMBAYMENTS));
    public static final BiomeExtension OLD_SHIELD_VOLCANO_SHORE = TFCBiomes.register("old_shield_volcano_shore", BiomeBuilder.builder().heightmap(BiomeNoise::shore).surface(ShoreAndOceanSurfaceBuilder.OLD_SHIELD_VOLCANO).tuffRings(3, -8, 26).spawnable().salty().shore().type(RiverBlendType.TALL_CANYON).type(ShoreBlendType.SANDY));
    public static final BiomeExtension ICE_SHEET = TFCBiomes.register("ice_sheet", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.iceSheetSurfaceHeight(seed).add(BiomeNoise.glacialSurfaceTexture(seed))).surface(IceSheetSurfaceBuilder.NORMAL).spawnable().type(RiverBlendType.CAVE).noSandyRiverShores());
    public static final BiomeExtension ICE_SHEET_MOUNTAINS = TFCBiomes.register("ice_sheet_mountains", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.montaneIceSheetSurfaceHeight(seed).add(BiomeNoise.glacialSurfaceTexture(seed)).max(BiomeNoise.glacialCirques(seed).addConstant(39.0)).max(BiomeNoise.glacialCirquesIceSurfaceHeight(seed).addConstant(39.0))).surface(IceSheetSurfaceBuilder.ICE_SHEET_MOUNTAINS).spawnable().type(RiverBlendType.CAVE).noSandyRiverShores());
    public static final BiomeExtension ICE_SHEET_OCEANIC_MOUNTAINS = TFCBiomes.register("ice_sheet_oceanic_mountains", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.oceanicIceSheetSurfaceHeight(seed).add(BiomeNoise.glacialSurfaceTexture(seed)).max(BiomeNoise.glacialCirquesIceSurfaceHeight(seed)).max(BiomeNoise.glacialCirques(seed))).surface(IceSheetSurfaceBuilder.ICE_SHEET_OCEANIC_MOUNTAINS).spawnable().type(RiverBlendType.CAVE).noSandyRiverShores());
    public static final BiomeExtension ICE_SHEET_SHIELD_VOLCANO = TFCBiomes.register("ice_sheet_shield_volcano", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.glaciatedShieldVolcano(seed, BiomeNoise.hotSpotIntensity(seed)).max(BiomeNoise.shieldVolcanoIceSheetSurface(seed, BiomeNoise.hotSpotIntensity(seed)).add(BiomeNoise.glacialSurfaceTexture(seed)))).surface(IceSheetShieldVolcanoSurfaceBuilder.ICE_SHEET).spawnable().type(RiverBlendType.CAVE).noSandyRiverShores());
    public static final BiomeExtension ICE_SHEET_TUYAS = TFCBiomes.register("ice_sheet_tuyas", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.iceSheetSurfaceHeight(seed).add(BiomeNoise.glacialSurfaceTexture(seed))).surface(IceSheetSurfaceBuilder.NORMAL).spawnable().type(RiverBlendType.CAVE).noSandyRiverShores().tuyas(3, 0, 35, 40, true).type(RiverBlendType.CAVE));
    public static final BiomeExtension SUBGLACIAL_LAKE = TFCBiomes.register("subglacial_lake", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.iceSheetSurfaceHeight(seed).add(BiomeNoise.glacialSurfaceTexture(seed))).surface(IceSheetSurfaceBuilder.HIDDEN_LAKE).carving(BiomeNoise::undergroundLakes).type(BiomeBlendType.LAKE).noRivers());
    public static final BiomeExtension ICE_SHEET_EDGE = TFCBiomes.register("ice_sheet_edge", BiomeBuilder.builder().heightmap(BiomeNoise::glacialBase).surface(IceSheetSurfaceBuilder.EDGE).spawnable().type(RiverBlendType.TALL_CANYON).noSandyRiverShores());
    public static final BiomeExtension ICE_SHEET_TUYAS_EDGE = TFCBiomes.register("ice_sheet_tuyas_edge", BiomeBuilder.builder().heightmap(BiomeNoise::glacialBase).surface(IceSheetSurfaceBuilder.EDGE).spawnable().type(RiverBlendType.TALL_CANYON).noSandyRiverShores().tuyas(3, 0, 35, 40, true));
    public static final BiomeExtension ICE_SHEET_MOUNTAINS_EDGE = TFCBiomes.register("ice_sheet_mountains_edge", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.glacialCirques(seed).addConstant(39.0).max(BiomeNoise.glacialCirquesIceSurfaceHeight(seed).addConstant(39.0))).surface(IceSheetSurfaceBuilder.ICE_SHEET_MOUNTAINS).spawnable().type(RiverBlendType.CAVE).noSandyRiverShores());
    public static final BiomeExtension ICE_SHEET_OCEANIC_MOUNTAINS_EDGE = TFCBiomes.register("ice_sheet_oceanic_mountains_edge", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.glacialCirquesIceSurfaceHeight(seed).max(BiomeNoise.glacialCirques(seed))).surface(IceSheetSurfaceBuilder.ICE_SHEET_OCEANIC_MOUNTAINS).aquiferHeightOffset(-24.0).spawnable().type(RiverBlendType.CAVE).noSandyRiverShores().shore().setShoreBaseHeight(-16).salty().type(ShoreBlendType.CLASSIC));
    public static final BiomeExtension MELTWATER_LAKE = TFCBiomes.register("meltwater_lake", BiomeBuilder.builder().heightmap(BiomeNoise::lake).surface(IceSheetSurfaceBuilder.EDGE_LAKE).aquiferHeightOffset(-16.0).type(BiomeBlendType.LAKE).type(RiverBlendType.WIDE).noRivers().shore().setShoreBaseHeight(-16).type(ShoreBlendType.CLASSIC));
    public static final BiomeExtension ICE_SHEET_OCEANIC = TFCBiomes.register("ice_sheet_oceanic", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.oceanicIceSheetSurfaceHeight(seed).add(BiomeNoise.glacialSurfaceTexture(seed))).surface(IceSheetSurfaceBuilder.OCEANIC).spawnable().type(RiverBlendType.CAVE).salty().noSandyRiverShores());
    public static final BiomeExtension ICE_SHEET_SHORE = TFCBiomes.register("ice_sheet_shore", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.ocean(seed, -16, -8)).surface(IceSheetSurfaceBuilder.OCEANIC).aquiferHeightOffset(-24.0).spawnable().type(RiverBlendType.TALL_CANYON).noSandyRiverShores().shore().setShoreBaseHeight(-12).salty().type(ShoreBlendType.CLASSIC));
    public static final BiomeExtension GLACIATED_MOUNTAINS = TFCBiomes.register("glaciated_mountains", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.glacialCirques(seed).addConstant(39.0).max(BiomeNoise.glacialCirquesIceSurfaceHeight(seed).addConstant(39.0))).surface(IceSheetSurfaceBuilder.GLACIATED_MOUNTAINS).spawnable().type(RiverBlendType.CAVE).noSandyRiverShores());
    public static final BiomeExtension GLACIATED_OCEANIC_MOUNTAINS = TFCBiomes.register("glaciated_oceanic_mountains", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.glacialCirques(seed).max(BiomeNoise.glacialCirquesIceSurfaceHeight(seed))).surface(IceSheetSurfaceBuilder.GLACIATED_OCEANIC_MOUNTAINS).aquiferHeightOffset(-24.0).spawnable().type(RiverBlendType.CAVE).noSandyRiverShores().salty());
    public static final BiomeExtension GLACIATED_SHIELD_VOLCANO = TFCBiomes.register("glaciated_shield_volcano", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.glaciatedShieldVolcano(seed, BiomeNoise.hotSpotIntensity(seed)).max(BiomeNoise.shieldVolcanoGlacierSurface(seed, BiomeNoise.hotSpotIntensity(seed)).add(BiomeNoise.glacialSurfaceTexture(seed)))).surface(IceSheetShieldVolcanoSurfaceBuilder.GLACIATED).spawnable().type(RiverBlendType.CAVE).noSandyRiverShores());
    public static final BiomeExtension GLACIALLY_CARVED_MOUNTAINS = TFCBiomes.register("glacially_carved_mountains", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.glacialCirques(seed).addConstant(39.0)).surface(NormalSurfaceBuilder.ROCKY).spawnable().type(RiverBlendType.CAVE).noSandyRiverShores());
    public static final BiomeExtension GLACIALLY_CARVED_OCEANIC_MOUNTAINS = TFCBiomes.register("glacially_carved_oceanic_mountains", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.glacialCirques(seed)).surface(NormalSurfaceBuilder.ROCKY).aquiferHeightOffset(-24.0).spawnable().type(RiverBlendType.CAVE).noSandyRiverShores().salty());
    public static final BiomeExtension DRUMLINS = TFCBiomes.register("drumlins", BiomeBuilder.builder().heightmap(BiomeNoise::drumlins).surface(NormalSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.WIDE));
    public static final BiomeExtension TUYAS = TFCBiomes.register("tuyas", BiomeBuilder.builder().heightmap(BiomeNoise::drumlins).surface(NormalSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.WIDE).tuyas(2, 0, 35, 40, false).type(RiverBlendType.CANYON));
    public static final BiomeExtension KNOB_AND_KETTLE = TFCBiomes.register("knob_and_kettle", BiomeBuilder.builder().heightmap(BiomeNoise::knobAndKettle).surface(NormalSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.WIDE));
    public static final BiomeExtension PATTERNED_GROUND = TFCBiomes.register("patterned_ground", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.hills(seed, -4, 3).add(BiomeNoise.patternedGround(seed))).surface(PatternedGroundSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.WIDE));
    public static final BiomeExtension INVERTED_PATTERNED_GROUND = TFCBiomes.register("inverted_patterned_ground", BiomeBuilder.builder().heightmap(BiomeNoise::invertedPatternedGround).surface(PatternedGroundSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.WIDE));
    public static final BiomeExtension STONE_CIRCLES = TFCBiomes.register("stone_circles", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.hills(seed, -2, 4).add(BiomeNoise.stoneCircles(seed))).surface(StoneCirclesSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.WIDE));

    public static BiomeExtension getExtensionOrThrow(LevelAccessor level, Biome biome) {
        return Objects.requireNonNull(TFCBiomes.getExtension((CommonLevelAccessor)level, biome), () -> "Biome: " + level.registryAccess().registryOrThrow(Registries.BIOME).getId((Object)biome));
    }

    public static boolean hasExtension(CommonLevelAccessor level, Biome biome) {
        return TFCBiomes.getExtension(level, biome) != null;
    }

    @Nullable
    public static BiomeExtension getExtension(CommonLevelAccessor level, Biome biome) {
        return ((BiomeBridge)biome).tfc$getExtension(level);
    }

    @Nullable
    @ApiStatus.Internal
    public static BiomeExtension findExtension(CommonLevelAccessor level, Biome biome) {
        return level.registryAccess().registryOrThrow(Registries.BIOME).getResourceKey((Object)biome).map(key -> (BiomeExtension)REGISTRY.get(ResourceKey.create(KEY, (ResourceLocation)key.location()))).orElse(null);
    }

    private static BiomeExtension register(String name, BiomeBuilder builder) {
        ResourceLocation id = Helpers.identifier(name);
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)id);
        BiomeExtension extension = builder.build((ResourceKey<Biome>)key);
        EXTENSIONS.register(name, () -> extension);
        return extension;
    }
}

