/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.blockpredicate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.world.blockpredicate.TFCBlockPredicates;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;

public record WouldSurviveWithFluidPredicate(Vec3i offset, BlockState state) implements BlockPredicate
{
    public static final MapCodec<WouldSurviveWithFluidPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> {
        Codec codec = Vec3i.offsetCodec((int)16);
        return instance.group((App)codec.optionalFieldOf("offset", (Object)Vec3i.ZERO).forGetter(c -> c.offset), (App)BlockState.CODEC.fieldOf("state").forGetter(c -> c.state)).apply((Applicative)instance, WouldSurviveWithFluidPredicate::new);
    });

    public boolean test(WorldGenLevel level, BlockPos pos) {
        BlockState stateWithFluid = FluidHelpers.fillWithFluid(this.state, level.getFluidState(pos).getType());
        return stateWithFluid != null && stateWithFluid.canSurvive((LevelReader)level, pos.offset(this.offset));
    }

    public BlockPredicateType<?> type() {
        return (BlockPredicateType)TFCBlockPredicates.WOULD_SURVIVE_WITH_FLUID.get();
    }
}

