/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.chunkdata;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Locale;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;

public enum ForestType implements StringRepresentable
{
    GRASSLAND(ForestSubType.NONE, 0, ForestType.zero(), ForestType.zero(), ForestType.zero(), ForestType.zero(), 2, 0.0f, 0),
    CLEARING(ForestSubType.NONE, 0, ForestType.zero(), ForestType.zero(), ForestType.zero(), ForestType.zero(), 2, 0.0f, 0),
    SHRUBLAND(ForestSubType.NONE, 0, ForestType.zero(), ForestType.value(10), ForestType.range(0, 1), ForestType.range(2, 7), 2, 1.0f, 0),
    SPARSE(ForestSubType.NONE, 0, ForestType.value(2), ForestType.value(6), ForestType.zero(), ForestType.range(0, 2), 2, 0.08f, 0),
    SAVANNA_MONOCULTURE(ForestSubType.SAVANNA, 1, ForestType.value(3), ForestType.value(6), ForestType.zero(), ForestType.range(0, 2), 1, 0.55f, 0),
    SAVANNA_DIVERSE(ForestSubType.SAVANNA, 1, ForestType.value(3), ForestType.value(6), ForestType.zero(), ForestType.range(0, 2), 2, 0.65f, 0),
    SAVANNA_ALTERNATE(ForestSubType.SAVANNA, 1, ForestType.value(3), ForestType.value(6), ForestType.zero(), ForestType.range(0, 2), 3, 0.4f, 2),
    SAVANNA_SHRUB_MONOCULTURE(ForestSubType.SAVANNA, 1, ForestType.value(1), ForestType.value(6), ForestType.zero(), ForestType.range(3, 6), 1, 0.9f, 0),
    SAVANNA_SHRUB_DIVERSE(ForestSubType.SAVANNA, 1, ForestType.value(1), ForestType.value(6), ForestType.zero(), ForestType.range(3, 6), 2, 1.0f, 0),
    SAVANNA_SHRUB_ALTERNATE(ForestSubType.SAVANNA, 1, ForestType.value(1), ForestType.value(6), ForestType.zero(), ForestType.range(3, 6), 3, 0.8f, 2),
    PRIMARY_MONOCULTURE(ForestSubType.PRIMARY, 3, ForestType.value(5), ForestType.value(25), ForestType.range(0, 1), ForestType.zero(), 1, 1.0f, 0),
    PRIMARY_DIVERSE(ForestSubType.PRIMARY, 4, ForestType.value(7), ForestType.value(40), ForestType.range(0, 1), ForestType.range(0, 3), 2, 1.0f, 0),
    PRIMARY_ALTERNATE(ForestSubType.PRIMARY, 4, ForestType.value(7), ForestType.value(40), ForestType.range(0, 1), ForestType.range(0, 3), 3, 1.0f, 2),
    SECONDARY_MONOCULTURE(ForestSubType.SECONDARY, 3, ForestType.value(5), ForestType.value(25), ForestType.zero(), ForestType.range(1, 2), 1, 1.0f, 0),
    SECONDARY_MONOCULTURE_TALL(ForestSubType.SECONDARY, 3, ForestType.value(5), ForestType.value(25), ForestType.zero(), ForestType.range(1, 2), 1, 1.0f, 0),
    SECONDARY_DIVERSE(ForestSubType.SECONDARY, 3, ForestType.value(5), ForestType.value(25), ForestType.zero(), ForestType.range(1, 2), 2, 1.0f, 0),
    SECONDARY_BAMBOO(ForestSubType.SECONDARY, 3, ForestType.value(1), ForestType.value(25), ForestType.range(0, 1), ForestType.range(0, 1), 2, 0.3f, 0),
    SECONDARY_DIVERSE_TALL(ForestSubType.SECONDARY, 3, ForestType.value(5), ForestType.value(25), ForestType.zero(), ForestType.range(1, 2), 2, 1.0f, 0),
    SECONDARY_DENSE(ForestSubType.SECONDARY, 4, ForestType.value(7), ForestType.value(40), ForestType.range(0, 1), ForestType.value(3), 2, 1.0f, 0),
    SECONDARY_DENSE_TALL(ForestSubType.SECONDARY, 4, ForestType.value(7), ForestType.value(40), ForestType.range(0, 1), ForestType.value(3), 2, 1.0f, 0),
    SECONDARY_ALTERNATE(ForestSubType.SECONDARY, 3, ForestType.value(5), ForestType.value(25), ForestType.zero(), ForestType.range(1, 2), 3, 1.0f, 2),
    EDGE_MONOCULTURE(ForestSubType.EDGE, 2, ForestType.value(2), ForestType.value(10), ForestType.range(0, 1), ForestType.range(0, 1), 1, 1.0f, 0),
    EDGE_DIVERSE(ForestSubType.EDGE, 2, ForestType.value(2), ForestType.value(10), ForestType.range(0, 1), ForestType.range(0, 1), 2, 1.0f, 0),
    EDGE_ALTERNATE(ForestSubType.EDGE, 2, ForestType.value(2), ForestType.value(10), ForestType.range(0, 1), ForestType.range(0, 1), 3, 1.0f, 2),
    EDGE_BAMBOO(ForestSubType.EDGE, 2, ForestType.value(1), ForestType.value(10), ForestType.range(0, 1), ForestType.range(0, 1), 1, 0.7f, 0),
    DEAD_MONOCULTURE(ForestSubType.DEAD, 2, ForestType.value(5), ForestType.value(25), ForestType.zero(), ForestType.range(2, 4), 1, 1.0f, 0),
    DEAD_DIVERSE(ForestSubType.DEAD, 2, ForestType.value(5), ForestType.value(25), ForestType.zero(), ForestType.range(2, 4), 2, 1.0f, 0),
    DEAD_ALTERNATE(ForestSubType.DEAD, 3, ForestType.value(4), ForestType.value(40), ForestType.range(0, 1), ForestType.range(0, 3), 3, 1.0f, 2),
    DEAD_BAMBOO(ForestSubType.DEAD, 3, ForestType.value(4), ForestType.value(25), ForestType.range(0, 1), ForestType.range(2, 4), 2, 1.0f, 0);

    public static final Codec<ForestType> CODEC;
    public static final StreamCodec<ByteBuf, ForestType> STREAM;
    private static final List<ForestType> EDGE_DENSITY;
    private static final List<ForestType> SECONDARY_FORESTS;
    private static final List<ForestType> PRIMARY_FORESTS;
    private static final List<ForestType> DEAD_FORESTS;
    private static final List<ForestType> SAVANNA_FORESTS;
    private static final ForestType[] VALUES;
    private final ForestSubType subType;
    private final int density;
    private final IntProvider treeCount;
    private final IntProvider groundcoverCount;
    private final IntProvider leafPileCount;
    private final IntProvider bushCount;
    private final int maxTreeTypes;
    private final float perChunkChance;
    private final int alternateSize;

    public static int getEdgeForestType(RandomSource random) {
        return EDGE_DENSITY.get(random.nextInt(EDGE_DENSITY.size())).ordinal();
    }

    public static int getSecondaryForestType(RandomSource random) {
        return SECONDARY_FORESTS.get(random.nextInt(SECONDARY_FORESTS.size())).ordinal();
    }

    public static int getPrimaryForestType(RandomSource random) {
        return PRIMARY_FORESTS.get(random.nextInt(PRIMARY_FORESTS.size())).ordinal();
    }

    public static int getDeadForestType(RandomSource random) {
        return DEAD_FORESTS.get(random.nextInt(DEAD_FORESTS.size())).ordinal();
    }

    public static int getSavannaForestType(RandomSource random) {
        return SAVANNA_FORESTS.get(random.nextInt(SAVANNA_FORESTS.size())).ordinal();
    }

    public static ForestType valueOf(int i) {
        return i >= 0 && i < VALUES.length ? VALUES[i] : GRASSLAND;
    }

    public static ForestType byName(String name) {
        return ForestType.valueOf(name.toUpperCase(Locale.ROOT));
    }

    private static IntProvider zero() {
        return ConstantInt.of((int)0);
    }

    private static IntProvider range(int min, int max) {
        return UniformInt.of((int)min, (int)max);
    }

    private static IntProvider value(int i) {
        return ConstantInt.of((int)i);
    }

    private ForestType(ForestSubType subType, int density, IntProvider treeCount, IntProvider groundcoverCount, IntProvider leafPileCount, IntProvider bushCount, int maxTreeTypes, float perChunkChance, int alternateSize) {
        this.subType = subType;
        this.density = density;
        this.treeCount = treeCount;
        this.groundcoverCount = groundcoverCount;
        this.leafPileCount = leafPileCount;
        this.bushCount = bushCount;
        this.maxTreeTypes = maxTreeTypes;
        this.perChunkChance = perChunkChance;
        this.alternateSize = alternateSize;
    }

    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public ForestType getAlternate() {
        if (this.isSavanna()) {
            return this;
        }
        if (this.isEdge()) {
            return EDGE_ALTERNATE;
        }
        if (this.isSecondary()) {
            return SECONDARY_ALTERNATE;
        }
        if (this.isPrimary()) {
            return PRIMARY_ALTERNATE;
        }
        if (this.isDead()) {
            return DEAD_ALTERNATE;
        }
        return this;
    }

    public boolean isPrimary() {
        return this.subType == ForestSubType.PRIMARY;
    }

    public boolean isEdge() {
        return this.subType == ForestSubType.EDGE;
    }

    public boolean isSecondary() {
        return this.subType == ForestSubType.SECONDARY;
    }

    public boolean isDead() {
        return this.subType == ForestSubType.DEAD;
    }

    public boolean isNone() {
        return this.subType == ForestSubType.NONE;
    }

    public boolean isSavanna() {
        return this.subType == ForestSubType.SAVANNA;
    }

    public int sampleTrees(RandomSource random) {
        return this.treeCount.sample(random);
    }

    public int sampleGroundcover(RandomSource random) {
        return this.groundcoverCount.sample(random);
    }

    public int sampleLeafPiles(RandomSource random) {
        return this.leafPileCount.sample(random);
    }

    public int sampleBushes(RandomSource random) {
        return this.bushCount.sample(random);
    }

    public boolean isAsOrMoreDenseAs(ForestType other) {
        return this.getDensity() >= other.getDensity();
    }

    public int getDensity() {
        return this.density;
    }

    public int getMaxTreeTypes() {
        return this.maxTreeTypes;
    }

    public float getPerChunkChance() {
        return this.perChunkChance;
    }

    public int getAlternateSize() {
        return this.alternateSize;
    }

    static {
        CODEC = StringRepresentable.fromEnum(ForestType::values);
        STREAM = ByteBufCodecs.BYTE.map(ForestType::valueOf, c -> (byte)c.ordinal());
        EDGE_DENSITY = List.of(EDGE_MONOCULTURE, EDGE_DIVERSE, EDGE_ALTERNATE, EDGE_BAMBOO);
        SECONDARY_FORESTS = List.of(SECONDARY_MONOCULTURE, SECONDARY_DENSE, SECONDARY_DIVERSE, SECONDARY_DENSE_TALL, SECONDARY_MONOCULTURE_TALL, SECONDARY_DIVERSE_TALL, SECONDARY_BAMBOO);
        PRIMARY_FORESTS = List.of(PRIMARY_DIVERSE, PRIMARY_MONOCULTURE);
        DEAD_FORESTS = List.of(DEAD_MONOCULTURE, DEAD_DIVERSE, DEAD_ALTERNATE, DEAD_BAMBOO);
        SAVANNA_FORESTS = List.of(SAVANNA_MONOCULTURE, SAVANNA_ALTERNATE, SAVANNA_DIVERSE, SAVANNA_SHRUB_MONOCULTURE, SAVANNA_SHRUB_ALTERNATE, SAVANNA_SHRUB_DIVERSE);
        VALUES = ForestType.values();
    }

    public static enum ForestSubType {
        NONE,
        PRIMARY,
        SECONDARY,
        EDGE,
        DEAD,
        SAVANNA;

    }
}

