/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.density;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.DensityFunction;

public record Spaghetti2D(DensityFunction rarityModulator, DensityFunction thicknessModulator, DensityFunction elevationModulator, DensityFunction.NoiseHolder noise) implements DensityFunction
{
    public static final KeyDispatchDataCodec<Spaghetti2D> CODEC = KeyDispatchDataCodec.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("rarity").forGetter(c -> c.rarityModulator), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("thickness").forGetter(c -> c.thicknessModulator), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("elevation").forGetter(c -> c.elevationModulator), (App)DensityFunction.NoiseHolder.CODEC.fieldOf("noise").forGetter(c -> c.noise)).apply((Applicative)instance, Spaghetti2D::new)));

    public double compute(DensityFunction.FunctionContext context) {
        double rarity = this.getRarity(this.rarityModulator.compute(context));
        double rarityNoise = this.noise.getValue((double)context.blockX() / rarity, (double)context.blockY() / rarity, (double)context.blockZ() / rarity);
        double thickness = this.thicknessModulator.compute(context);
        double elevation = this.elevationModulator.compute(context);
        double left = Math.abs(elevation - (double)context.blockY() / 8.0) - thickness;
        double right = Math.abs(rarity * rarityNoise) - 0.083 * thickness;
        return Mth.clamp((double)Math.max(left * left * left, right), (double)-1.0, (double)1.0);
    }

    public void fillArray(double[] array, DensityFunction.ContextProvider context) {
        context.fillAllDirectly(array, (DensityFunction)this);
    }

    public double minValue() {
        return -1.0;
    }

    public double maxValue() {
        return 1.0;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC;
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new Spaghetti2D(this.rarityModulator.mapAll(visitor), this.thicknessModulator.mapAll(visitor), this.elevationModulator.mapAll(visitor), visitor.visitNoise(this.noise)));
    }

    private double getRarity(double value) {
        if (value < -0.75) {
            return 0.5;
        }
        if (value < -0.5) {
            return 0.75;
        }
        if (value < 0.5) {
            return 1.0;
        }
        return value < 0.75 ? 2.0 : 3.0;
    }
}

