/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature;

import com.mojang.serialization.Codec;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.feature.FissureConfig;
import net.dries007.tfc.world.settings.RockSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import org.jetbrains.annotations.Nullable;

public class FissureFeature
extends Feature<FissureConfig> {
    public static void placeFissure(WorldGenLevel level, BlockPos startPos, BlockPos centerPos, BlockPos.MutableBlockPos mutablePos, RandomSource random, BlockState insideState, BlockState wallState, int minPieces, int maxPieces, int maxPieceLength, int minDepth, int radius, @Nullable FissureConfig.Decoration decoration) {
        int pieces = minPieces + random.nextInt(maxPieces - minPieces);
        BlockPos topPos = startPos.immutable();
        for (int i = 0; i < pieces; ++i) {
            int pieceDepth = 1 + random.nextInt(maxPieceLength);
            for (int dy = 1; dy <= pieceDepth; ++dy) {
                if (level.getBlockState(mutablePos.below(2)).isEmpty()) {
                    return;
                }
                level.setBlock((BlockPos)mutablePos.setWithOffset((Vec3i)topPos, 0, -dy, 0), insideState, 2);
                level.setBlock((BlockPos)mutablePos.setWithOffset((Vec3i)topPos, -1, -dy, 0), wallState, 2);
                level.setBlock((BlockPos)mutablePos.setWithOffset((Vec3i)topPos, 1, -dy, 0), wallState, 2);
                level.setBlock((BlockPos)mutablePos.setWithOffset((Vec3i)topPos, 0, -dy, -1), wallState, 2);
                level.setBlock((BlockPos)mutablePos.setWithOffset((Vec3i)topPos, 0, -dy, 1), wallState, 2);
                if (decoration == null) continue;
                for (int j = 0; j < decoration.count(); ++j) {
                    if (random.nextInt(decoration.rarity()) != 0) continue;
                    mutablePos.setWithOffset((Vec3i)topPos, random.nextInt(decoration.radius()) - random.nextInt(decoration.radius()), random.nextInt(3) - random.nextInt(3) - dy, random.nextInt(decoration.radius()) - random.nextInt(decoration.radius()));
                    BlockState stoneState = level.getBlockState((BlockPos)mutablePos);
                    BlockState decorationState = decoration.getState(stoneState, random);
                    if (decorationState == null) continue;
                    level.setBlock((BlockPos)mutablePos, decorationState, 2);
                }
            }
            Direction branchDirection = FissureFeature.randomBoundedDirection(random, centerPos, topPos, radius);
            topPos = mutablePos.setWithOffset((Vec3i)topPos, 0, -pieceDepth, 0).move(branchDirection).immutable();
            level.setBlock((BlockPos)mutablePos.set((Vec3i)topPos), insideState, 2);
            level.setBlock((BlockPos)mutablePos.setWithOffset((Vec3i)topPos, 0, 1, 0), wallState, 2);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (direction == branchDirection.getOpposite()) continue;
                level.setBlock((BlockPos)mutablePos.setWithOffset((Vec3i)topPos, direction), wallState, 2);
            }
            if (topPos.getY() < minDepth) break;
        }
    }

    private static Direction randomBoundedDirection(RandomSource random, BlockPos center, BlockPos target, int radius) {
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        int distX = target.getX() - center.getX();
        int distZ = target.getZ() - center.getZ();
        switch (direction) {
            case EAST: {
                if (distX > radius) {
                    return Direction.WEST;
                }
                return direction;
            }
            case WEST: {
                if (distX < -radius) {
                    return Direction.EAST;
                }
                return direction;
            }
            case NORTH: {
                if (distZ < -radius) {
                    return Direction.SOUTH;
                }
                return direction;
            }
            case SOUTH: {
                if (distZ > radius) {
                    return Direction.NORTH;
                }
                return direction;
            }
        }
        return direction;
    }

    public FissureFeature(Codec<FissureConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<FissureConfig> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource rand = context.random();
        FissureConfig config = (FissureConfig)context.config();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int placeCount = 1 + rand.nextInt(config.count());
        int minDepth = config.minDepth().resolveY(new WorldGenerationContext(context.chunkGenerator(), (LevelHeightAccessor)level));
        BlockState insideState = config.wallState().orElseGet(() -> {
            ChunkData data = ChunkData.get((LevelReader)context.level(), pos);
            RockSettings rock = data.getRockData().getRock(pos.getX(), context.chunkGenerator().getMinY() + 1, pos.getZ());
            return rock.raw().defaultBlockState();
        });
        for (int i = 0; i < placeCount; ++i) {
            mutablePos.setWithOffset((Vec3i)pos, rand.nextInt(config.radius()) - rand.nextInt(config.radius()), 0, rand.nextInt(config.radius()) - rand.nextInt(config.radius()));
            mutablePos.setY(level.getHeight(Heightmap.Types.WORLD_SURFACE_WG, mutablePos.getX(), mutablePos.getZ()));
            FissureFeature.placeFissure(level, pos, mutablePos.immutable(), mutablePos, rand, config.fluidState(), insideState, config.minPieces(), config.maxPieces(), config.maxPieceLength(), minDepth, config.radius(), config.decoration().orElse(null));
        }
        return true;
    }
}

