/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature;

import com.mojang.serialization.Codec;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.settings.RockSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.jetbrains.annotations.Nullable;

public class LooseRockFeature
extends Feature<NoneFeatureConfiguration> {
    public LooseRockFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        ChunkData data = ChunkData.get((LevelReader)level, pos);
        RockSettings rock = data.getRockData().getRock(pos);
        @Nullable Block looseRock = rock.loose().orElse(null);
        @Nullable Block mossyLooseRock = rock.mossyLoose().orElse(null);
        if (looseRock == null) {
            return false;
        }
        BlockState stateAt = level.getBlockState(pos);
        BlockState rockState = mossyLooseRock != null && data.getRainfall(pos) > 250.0f && random.nextBoolean() && stateAt.getFluidState().isEmpty() ? FluidHelpers.fillWithFluid(mossyLooseRock.defaultBlockState(), stateAt.getFluidState().getType()) : FluidHelpers.fillWithFluid(looseRock.defaultBlockState(), stateAt.getFluidState().getType());
        if (rockState != null && EnvironmentHelpers.isWorldgenReplaceable(stateAt) && rockState.canSurvive((LevelReader)level, pos) && this.canGenerateOn(level.getBlockState(pos.below()))) {
            this.setBlock((LevelWriter)level, pos, (BlockState)rockState.setValue((Property)TFCBlockStateProperties.COUNT_1_3, (Comparable)Integer.valueOf(1 + random.nextInt(2))));
            return true;
        }
        return false;
    }

    private boolean canGenerateOn(BlockState state) {
        return !Helpers.isBlock(state, (TagKey<Block>)BlockTags.ICE);
    }
}

