/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature;

import com.mojang.serialization.Codec;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.ChunkGeneratorExtension;
import net.dries007.tfc.world.settings.RockLayerSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.SpringConfiguration;

public class SpringFeature
extends Feature<SpringConfiguration> {
    public SpringFeature(Codec<SpringConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<SpringConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        SpringConfiguration config = (SpringConfiguration)context.config();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos().set((Vec3i)pos).move(0, 1, 0);
        BlockState stateAbove = level.getBlockState((BlockPos)mutablePos);
        ChunkGeneratorExtension extension = (ChunkGeneratorExtension)context.chunkGenerator();
        RockLayerSettings rockSettings = extension.rockLayerSettings();
        if (config.validBlocks.contains(SpringFeature.getHolder(stateAbove))) {
            BlockState stateAt;
            mutablePos.move(0, -2, 0);
            BlockState stateBelow = level.getBlockState((BlockPos)mutablePos);
            if ((!config.requiresBlockBelow || config.validBlocks.contains(SpringFeature.getHolder(stateBelow))) && ((stateAt = level.getBlockState(pos)).isAir() || config.validBlocks.contains(SpringFeature.getHolder(stateAt)))) {
                int rockCount = 0;
                int holeCount = 0;
                for (Direction direction : Helpers.DIRECTIONS) {
                    mutablePos.set((Vec3i)pos).move(direction);
                    BlockState stateAdjacent = level.getBlockState((BlockPos)mutablePos);
                    if (config.validBlocks.contains(SpringFeature.getHolder(stateAdjacent))) {
                        ++rockCount;
                    }
                    if (!stateAdjacent.isAir()) continue;
                    ++holeCount;
                }
                if (rockCount == config.rockCount && holeCount == config.holeCount) {
                    level.setBlock(pos, config.state.createLegacyBlock(), 2);
                    level.scheduleTick(pos, config.state.getType(), 0);
                    BlockPos posAbove = pos.above();
                    Block hardened = rockSettings.getHardened(level.getBlockState(posAbove).getBlock());
                    if (hardened != null) {
                        level.setBlock(posAbove, hardened.defaultBlockState(), 2);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static Holder<Block> getHolder(BlockState state) {
        return state.getBlock().builtInRegistryHolder();
    }
}

