/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.cave;

import com.mojang.serialization.Codec;
import net.dries007.tfc.common.blocks.GroundcoverBlockType;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.feature.cave.CaveVegetationConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class CaveVegetationFeature
extends Feature<CaveVegetationConfig> {
    public CaveVegetationFeature(Codec<CaveVegetationConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<CaveVegetationConfig> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        CaveVegetationConfig config = (CaveVegetationConfig)context.config();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 128; ++i) {
            if (random.nextFloat() < 0.8f) {
                mutablePos.setWithOffset((Vec3i)pos, random.nextInt(15) - random.nextInt(15), -1 * random.nextInt(2) - 1, random.nextInt(15) - random.nextInt(15));
                if (level.isEmptyBlock((BlockPos)mutablePos)) {
                    BlockState generateState;
                    for (int j = 0; j < 7; ++j) {
                        mutablePos.move(0, -1, 0);
                        if (!level.isEmptyBlock((BlockPos)mutablePos)) break;
                    }
                    if ((generateState = config.getStateToGenerate(level.getBlockState((BlockPos)mutablePos), random)) != null) {
                        this.setBlock((LevelWriter)level, (BlockPos)mutablePos, generateState);
                    }
                    if (random.nextFloat() < 0.06f && mutablePos.getY() < 40) {
                        mutablePos.move(0, 1, 0);
                        if (((Block)TFCBlocks.GROUNDCOVER.get((Object)GroundcoverBlockType.GUANO).get()).defaultBlockState().canSurvive((LevelReader)level, (BlockPos)mutablePos)) {
                            this.setBlock((LevelWriter)level, (BlockPos)mutablePos, ((Block)TFCBlocks.GROUNDCOVER.get((Object)GroundcoverBlockType.GUANO).get()).defaultBlockState());
                        }
                    }
                }
            }
            if (random.nextFloat() < 0.003f) {
                mutablePos.setWithOffset((Vec3i)pos, random.nextInt(15) - random.nextInt(15), 4 + random.nextInt(7), random.nextInt(15) - random.nextInt(15));
                if (level.isEmptyBlock((BlockPos)mutablePos)) {
                    mutablePos.move(0, 1, 0);
                    if (CaveVegetationFeature.isStone(level, (BlockPos)mutablePos)) {
                        this.setBlock((LevelWriter)level, (BlockPos)mutablePos, Fluids.WATER.defaultFluidState().createLegacyBlock());
                        level.scheduleTick((BlockPos)mutablePos, (Fluid)Fluids.WATER, 0);
                    }
                }
            }
            if (!(random.nextFloat() < 0.04f)) continue;
            mutablePos.setWithOffset((Vec3i)pos, random.nextInt(15) - random.nextInt(15), 4 + random.nextInt(7), random.nextInt(15) - random.nextInt(15));
            if (!CaveVegetationFeature.isStone(level, (BlockPos)mutablePos)) continue;
            mutablePos.move(0, -1, 0);
            if (!level.isEmptyBlock((BlockPos)mutablePos)) continue;
            BlockState state = random.nextBoolean() ? Blocks.COBWEB.defaultBlockState() : Blocks.HANGING_ROOTS.defaultBlockState();
            this.setBlock((LevelWriter)level, (BlockPos)mutablePos, state);
        }
        return true;
    }

    private static boolean isStone(WorldGenLevel level, BlockPos pos) {
        return Helpers.isBlock(level.getBlockState(pos), (TagKey<Block>)BlockTags.BASE_STONE_OVERWORLD);
    }
}

