/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.plant;

import com.mojang.serialization.Codec;
import net.dries007.tfc.common.blocks.plant.EpiphytePlantBlock;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.dries007.tfc.world.feature.BlockConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class EpiphytePlantFeature
extends Feature<BlockConfig<EpiphytePlantBlock>> {
    public static final Codec<BlockConfig<EpiphytePlantBlock>> CODEC = BlockConfig.codec(b -> {
        EpiphytePlantBlock t;
        return b instanceof EpiphytePlantBlock ? (t = (EpiphytePlantBlock)b) : null;
    }, "Must be a " + EpiphytePlantBlock.class.getSimpleName());

    public EpiphytePlantFeature(Codec<BlockConfig<EpiphytePlantBlock>> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BlockConfig<EpiphytePlantBlock>> context) {
        BlockPos pos;
        RandomSource random = context.random();
        WorldGenLevel level = context.level();
        if (!EnvironmentHelpers.isWorldgenReplaceable(level, pos = context.origin().offset(0, random.nextInt(12), 0))) {
            return false;
        }
        BlockState state = ((EpiphytePlantBlock)((BlockConfig)context.config()).block()).defaultBlockState();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!(state = (BlockState)state.setValue((Property)EpiphytePlantBlock.FACING, (Comparable)direction)).canSurvive((LevelReader)level, pos)) continue;
            this.setBlock((LevelWriter)level, pos, state);
            return true;
        }
        return false;
    }
}

