/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.plant;

import com.mojang.serialization.Codec;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.plant.fruit.GrowingFruitTreeBranchBlock;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class FruitTreeFeature
extends Feature<BlockStateConfiguration> {
    public FruitTreeFeature(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BlockStateConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        BlockStateConfiguration config = (BlockStateConfiguration)context.config();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        mutablePos.set((Vec3i)pos).move(0, -1, 0);
        if (Helpers.isBlock(level.getBlockState((BlockPos)mutablePos), TFCTags.Blocks.BUSH_PLANTABLE_ON)) {
            mutablePos.move(0, 1, 0);
            for (int j = 1; j <= 10; ++j) {
                if (!EnvironmentHelpers.isWorldgenReplaceable(level, (BlockPos)mutablePos)) {
                    return false;
                }
                mutablePos.move(0, 1, 0);
            }
            mutablePos.set((Vec3i)pos);
            BlockState branch = config.state.getBlock().defaultBlockState();
            branch = Helpers.setProperty(branch, GrowingFruitTreeBranchBlock.NATURAL, true);
            branch = Helpers.setProperty(branch, GrowingFruitTreeBranchBlock.SAPLINGS, Mth.nextInt((RandomSource)random, (int)2, (int)4));
            this.setBlock((LevelWriter)level, (BlockPos)mutablePos, branch);
            level.getBlockEntity((BlockPos)mutablePos, (BlockEntityType)TFCBlockEntities.TICK_COUNTING_PLANT.get()).ifPresent(entity -> entity.increaseCounter(0x6DDD00L));
            level.scheduleTick((BlockPos)mutablePos, branch.getBlock(), 1);
            return true;
        }
        return false;
    }
}

