/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.plant;

import com.mojang.serialization.Codec;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.plant.RotatableWaterPlantBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.dries007.tfc.world.feature.BlockConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Fluid;

public class RotatableWaterPlantFeature
extends Feature<BlockConfig<RotatableWaterPlantBlock>> {
    public static final Codec<BlockConfig<RotatableWaterPlantBlock>> CODEC = BlockConfig.codec(b -> {
        RotatableWaterPlantBlock t;
        return b instanceof RotatableWaterPlantBlock ? (t = (RotatableWaterPlantBlock)b) : null;
    }, "Must be a " + RotatableWaterPlantBlock.class.getSimpleName());

    public RotatableWaterPlantFeature(Codec<BlockConfig<RotatableWaterPlantBlock>> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BlockConfig<RotatableWaterPlantBlock>> context) {
        BlockPos pos;
        RandomSource random = context.random();
        WorldGenLevel level = context.level();
        if (!EnvironmentHelpers.isWorldgenReplaceable(level, pos = context.origin().offset(0, random.nextInt(12), 0))) {
            return false;
        }
        BlockState state = ((RotatableWaterPlantBlock)((BlockConfig)context.config()).block()).defaultBlockState();
        for (Direction direction : Direction.allShuffled((RandomSource)RandomSource.create())) {
            if (!(state = (BlockState)state.setValue((Property)RotatableWaterPlantBlock.FACING, (Comparable)direction)).canSurvive((LevelReader)level, pos)) continue;
            Fluid fluidAt = level.getFluidState(pos).getType();
            boolean isOpen = fluidAt.isSame((Fluid)TFCFluids.SALT_WATER.getSource());
            BlockState waterloggedState = FluidHelpers.fillWithFluid(state, fluidAt);
            if (waterloggedState == null) continue;
            this.setBlock((LevelWriter)level, pos, (BlockState)waterloggedState.setValue((Property)TFCBlockStateProperties.OPEN, (Comparable)Boolean.valueOf(isOpen)));
            return true;
        }
        return false;
    }
}

