/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.plant;

import com.mojang.serialization.Codec;
import net.dries007.tfc.common.blocks.soil.DirtBlock;
import net.dries007.tfc.common.blocks.soil.IGrassBlock;
import net.dries007.tfc.world.feature.plant.TFCBambooConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BambooLeaves;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class TFCBambooFeature
extends Feature<TFCBambooConfig> {
    public TFCBambooFeature(Codec<TFCBambooConfig> codec) {
        super(codec);
    }

    private BlockState trunk(TFCBambooConfig config) {
        return (BlockState)((BlockState)((BlockState)config.state().setValue((Property)BambooStalkBlock.AGE, (Comparable)Integer.valueOf(1))).setValue((Property)BambooStalkBlock.LEAVES, (Comparable)BambooLeaves.NONE)).setValue((Property)BambooStalkBlock.STAGE, (Comparable)Integer.valueOf(0));
    }

    private BlockState finalLarge(TFCBambooConfig config) {
        return (BlockState)((BlockState)this.trunk(config).setValue((Property)BambooStalkBlock.LEAVES, (Comparable)BambooLeaves.LARGE)).setValue((Property)BambooStalkBlock.STAGE, (Comparable)Integer.valueOf(1));
    }

    private BlockState topLarge(TFCBambooConfig config) {
        return (BlockState)this.trunk(config).setValue((Property)BambooStalkBlock.LEAVES, (Comparable)BambooLeaves.LARGE);
    }

    private BlockState topSmall(TFCBambooConfig config) {
        return (BlockState)this.trunk(config).setValue((Property)BambooStalkBlock.LEAVES, (Comparable)BambooLeaves.SMALL);
    }

    public boolean place(FeaturePlaceContext<TFCBambooConfig> context) {
        int placed = 0;
        BlockPos blockpos = context.origin();
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        TFCBambooConfig config = (TFCBambooConfig)context.config();
        BlockPos.MutableBlockPos cursor = blockpos.mutable();
        BlockPos.MutableBlockPos cursor2 = blockpos.mutable();
        BlockState trunk = this.trunk(config);
        BlockState finalLarge = this.finalLarge(config);
        BlockState topLarge = this.topLarge(config);
        BlockState topSmall = this.topSmall(config);
        if (level.isEmptyBlock((BlockPos)cursor)) {
            if (Blocks.BAMBOO.defaultBlockState().canSurvive((LevelReader)level, (BlockPos)cursor)) {
                int trunkSize = random.nextInt(12) + 5;
                if (random.nextFloat() < config.probability()) {
                    int radius = random.nextInt(4) + 1;
                    for (int x = blockpos.getX() - radius; x <= blockpos.getX() + radius; ++x) {
                        for (int z = blockpos.getZ() - radius; z <= blockpos.getZ() + radius; ++z) {
                            IGrassBlock grass;
                            Block block;
                            int dz;
                            int dx = x - blockpos.getX();
                            if (dx * dx + (dz = z - blockpos.getZ()) * dz > radius * radius) continue;
                            cursor2.set(x, level.getHeight(Heightmap.Types.WORLD_SURFACE, x, z) - 1, z);
                            Block under = level.getBlockState((BlockPos)cursor2).getBlock();
                            if (under instanceof IGrassBlock && (block = (grass = (IGrassBlock)under).getDirt().getBlock()) instanceof DirtBlock) {
                                DirtBlock dirt = (DirtBlock)block;
                                level.setBlock((BlockPos)cursor2, dirt.getRooted(), 2);
                                continue;
                            }
                            if (!(under instanceof DirtBlock)) continue;
                            DirtBlock dirt = (DirtBlock)under;
                            level.setBlock((BlockPos)cursor2, dirt.getRooted(), 2);
                        }
                    }
                }
                for (int j = 0; j < trunkSize && level.isEmptyBlock((BlockPos)cursor); ++j) {
                    level.setBlock((BlockPos)cursor, trunk, 2);
                    cursor.move(Direction.UP, 1);
                }
                if (cursor.getY() - blockpos.getY() >= 3) {
                    level.setBlock((BlockPos)cursor, finalLarge, 2);
                    level.setBlock((BlockPos)cursor.move(Direction.DOWN, 1), topLarge, 2);
                    level.setBlock((BlockPos)cursor.move(Direction.DOWN, 1), topSmall, 2);
                }
            }
            ++placed;
        }
        return placed > 0;
    }
}

