/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.plant;

import com.mojang.serialization.Codec;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.feature.plant.ColumnPlantConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class TFCWeepingVinesFeature
extends Feature<ColumnPlantConfig> {
    private static void placeColumn(LevelAccessor level, RandomSource rand, BlockPos.MutableBlockPos mutablePos, int height, int minAge, int maxAge, BlockState bodyState, BlockState headState) {
        for (int i = 0; i <= height; ++i) {
            if (level.isEmptyBlock((BlockPos)mutablePos)) {
                if (i == height || !level.isEmptyBlock(mutablePos.below())) {
                    level.setBlock((BlockPos)mutablePos, (BlockState)headState.setValue((Property)GrowingPlantHeadBlock.AGE, (Comparable)Integer.valueOf(Mth.nextInt((RandomSource)rand, (int)minAge, (int)maxAge))), 2);
                    break;
                }
                level.setBlock((BlockPos)mutablePos, bodyState, 2);
            }
            mutablePos.move(Direction.DOWN);
        }
    }

    public TFCWeepingVinesFeature(Codec<ColumnPlantConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<ColumnPlantConfig> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource rand = context.random();
        ColumnPlantConfig config = (ColumnPlantConfig)context.config();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        boolean placedAny = false;
        int radius = config.radius();
        for (int i = 0; i < config.tries(); ++i) {
            mutablePos.setWithOffset((Vec3i)pos, Helpers.triangle(rand, radius), Helpers.triangle(rand, 4) + 10, Helpers.triangle(rand, radius));
            mutablePos.move(Direction.UP);
            BlockState aboveState = level.getBlockState((BlockPos)mutablePos);
            mutablePos.move(Direction.DOWN);
            if (!Helpers.isBlock(aboveState, (TagKey<Block>)BlockTags.LEAVES) && !Helpers.isBlock(aboveState, (TagKey<Block>)BlockTags.LOGS) && !Helpers.isBlock(aboveState, (TagKey<Block>)BlockTags.BASE_STONE_OVERWORLD) || !level.isEmptyBlock((BlockPos)mutablePos)) continue;
            TFCWeepingVinesFeature.placeColumn((LevelAccessor)level, rand, mutablePos, rand.nextInt(config.maxHeight() - config.minHeight()) + config.minHeight(), 17, 25, config.bodyState(), config.headState());
            placedAny = true;
        }
        return placedAny;
    }
}

