/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.tree;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.dries007.tfc.util.collections.IWeighted;
import net.dries007.tfc.world.Codecs;
import net.dries007.tfc.world.placement.ClimatePlacement;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public record ForestConfig(HolderSet<ConfiguredFeature<?, ?>> entries) implements FeatureConfiguration
{
    public static final Codec<ForestConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.nonEmptyHolderSet((Codec)ConfiguredFeature.LIST_CODEC).fieldOf("entries").forGetter(c -> c.entries)).apply((Applicative)instance, ForestConfig::new));

    public record Entry(ClimatePlacement climate, Optional<BlockState> bushLog, Optional<BlockState> bushLeaves, Optional<BlockState> fallenLog, Optional<BlockState> fallenLeaves, Optional<IWeighted<BlockState>> groundcover, Holder<ConfiguredFeature<?, ?>> treeFeature, Holder<ConfiguredFeature<?, ?>> deadFeature, Optional<Holder<ConfiguredFeature<?, ?>>> oldGrowthFeature, Optional<Holder<ConfiguredFeature<?, ?>>> krummholz, Optional<Holder<ConfiguredFeature<?, ?>>> soilDiscFeature, int oldGrowthChance, int spoilerOldGrowthChance, int fallenChance, int deadChance, boolean floating) implements FeatureConfiguration
    {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> {
            Codec<IWeighted<BlockState>> codec = Codecs.weightedCodec(Codecs.BLOCK_STATE, "block");
            return instance.group((App)ClimatePlacement.CODEC.fieldOf("climate").forGetter(c -> c.climate), (App)Codecs.BLOCK_STATE.optionalFieldOf("bush_log").forGetter(c -> c.bushLog), (App)Codecs.BLOCK_STATE.optionalFieldOf("bush_leaves").forGetter(c -> c.bushLeaves), (App)Codecs.BLOCK_STATE.optionalFieldOf("fallen_log").forGetter(c -> c.fallenLog), (App)Codecs.BLOCK_STATE.optionalFieldOf("fallen_leaves").forGetter(c -> c.fallenLeaves), (App)codec.optionalFieldOf("groundcover").forGetter(c -> c.groundcover), (App)ConfiguredFeature.CODEC.fieldOf("normal_tree").forGetter(c -> c.treeFeature), (App)ConfiguredFeature.CODEC.fieldOf("dead_tree").forGetter(c -> c.deadFeature), (App)ConfiguredFeature.CODEC.optionalFieldOf("old_growth_tree").forGetter(c -> c.oldGrowthFeature), (App)ConfiguredFeature.CODEC.optionalFieldOf("krummholz").forGetter(c -> c.krummholz), (App)ConfiguredFeature.CODEC.optionalFieldOf("soil_disc").forGetter(c -> c.soilDiscFeature), (App)Codec.INT.optionalFieldOf("old_growth_chance", (Object)6).forGetter(c -> c.oldGrowthChance), (App)Codec.INT.optionalFieldOf("spoiler_old_growth_chance", (Object)200).forGetter(c -> c.spoilerOldGrowthChance), (App)Codec.INT.optionalFieldOf("fallen_tree_chance", (Object)14).forGetter(c -> c.fallenChance), (App)Codec.INT.optionalFieldOf("dead_chance", (Object)75).forGetter(c -> c.deadChance), (App)Codec.BOOL.optionalFieldOf("floating", (Object)false).forGetter(c -> c.floating)).apply((Applicative)instance, Entry::new);
        });

        public boolean isValid(float temperature, float groundwater, float rainVar, float elevation) {
            float adjustedRainVar = this.climate.isRainVarianceAbsolute() ? Math.abs(rainVar) : rainVar;
            return groundwater >= this.climate.getMinGroundwater() && groundwater <= this.climate.getMaxGroundwater() && adjustedRainVar >= this.climate.getMinRainVariance() && adjustedRainVar <= this.climate().getMaxRainVariance() && temperature >= this.climate.getMinTemp() && temperature <= this.climate.getMaxTemp() && elevation >= (float)this.climate.getMinElevation() && elevation <= (float)this.climate.getMaxElevation();
        }

        public float distanceFromMean(float temperature, float groundwater, float rainVar, float elevation) {
            float adjustedRainVar = this.climate.isRainVarianceAbsolute() ? Math.abs(rainVar) : rainVar;
            float tempDist = (temperature - this.getAverageTemp()) * 10.0f;
            float waterDist = groundwater - this.getAverageGroundwater();
            float rainVarDist = (adjustedRainVar - this.getAverageRainVar()) * 250.0f;
            float elevationDistance = (elevation - this.getAverageElevation()) * 5.0f;
            return tempDist + waterDist + rainVarDist + elevationDistance;
        }

        public float getAverageTemp() {
            return (this.climate.getMaxTemp() - this.climate.getMinTemp()) / 2.0f;
        }

        public ClimatePlacement getClimatePlacement() {
            return this.climate;
        }

        public float getAverageGroundwater() {
            return (this.climate.getMaxGroundwater() - this.climate.getMinGroundwater()) / 2.0f;
        }

        public float getAverageRainVar() {
            return (this.climate.getMaxRainVariance() - this.climate.getMinRainVariance()) / 2.0f;
        }

        public float getAverageElevation() {
            return (float)(this.climate.getMaxElevation() - this.climate.getMinElevation()) / 2.0f;
        }

        public ConfiguredFeature<?, ?> getFeature() {
            return (ConfiguredFeature)this.treeFeature.value();
        }

        public ConfiguredFeature<?, ?> getDeadFeature() {
            return (ConfiguredFeature)this.deadFeature.value();
        }

        public ConfiguredFeature<?, ?> getOldGrowthFeature() {
            return (ConfiguredFeature)this.oldGrowthFeature.orElse(this.treeFeature).value();
        }
    }
}

